/*
 * generated by Xtext
 */
package de.gebit.integrity.serializer;

import com.google.inject.Inject;
import de.gebit.integrity.dsl.ArbitraryParameterOrResultName;
import de.gebit.integrity.dsl.BooleanValue;
import de.gebit.integrity.dsl.Call;
import de.gebit.integrity.dsl.CallDefinition;
import de.gebit.integrity.dsl.Constant;
import de.gebit.integrity.dsl.ConstantDefinition;
import de.gebit.integrity.dsl.ConstantEntity;
import de.gebit.integrity.dsl.CustomOperation;
import de.gebit.integrity.dsl.DecimalValue;
import de.gebit.integrity.dsl.DocumentationComment;
import de.gebit.integrity.dsl.DslPackage;
import de.gebit.integrity.dsl.Empty;
import de.gebit.integrity.dsl.EnumValue;
import de.gebit.integrity.dsl.EuropeanDateAnd12HrsTimeValue;
import de.gebit.integrity.dsl.EuropeanDateAnd24HrsTimeValue;
import de.gebit.integrity.dsl.EuropeanDateValue;
import de.gebit.integrity.dsl.ExecutionMultiplier;
import de.gebit.integrity.dsl.FixedParameterName;
import de.gebit.integrity.dsl.FixedResultName;
import de.gebit.integrity.dsl.ForkDefinition;
import de.gebit.integrity.dsl.ForkParameter;
import de.gebit.integrity.dsl.Import;
import de.gebit.integrity.dsl.Inexistent;
import de.gebit.integrity.dsl.IntegerValue;
import de.gebit.integrity.dsl.IsoDateAndTimeValue;
import de.gebit.integrity.dsl.IsoDateValue;
import de.gebit.integrity.dsl.IsoTimeValue;
import de.gebit.integrity.dsl.JavaClassReference;
import de.gebit.integrity.dsl.JavaConstantReference;
import de.gebit.integrity.dsl.JavaConstantValue;
import de.gebit.integrity.dsl.KeyValuePair;
import de.gebit.integrity.dsl.MethodReference;
import de.gebit.integrity.dsl.Model;
import de.gebit.integrity.dsl.NamedCallResult;
import de.gebit.integrity.dsl.NamedResult;
import de.gebit.integrity.dsl.NestedObject;
import de.gebit.integrity.dsl.Null;
import de.gebit.integrity.dsl.OperationDefinition;
import de.gebit.integrity.dsl.PackageDefinition;
import de.gebit.integrity.dsl.ParameterTableHeader;
import de.gebit.integrity.dsl.ParameterTableValue;
import de.gebit.integrity.dsl.RegexValue;
import de.gebit.integrity.dsl.ResultTableHeader;
import de.gebit.integrity.dsl.Simple12HrsTimeValue;
import de.gebit.integrity.dsl.Simple24HrsTimeValue;
import de.gebit.integrity.dsl.StandardOperation;
import de.gebit.integrity.dsl.StringValue;
import de.gebit.integrity.dsl.Suite;
import de.gebit.integrity.dsl.SuiteDefinition;
import de.gebit.integrity.dsl.SuiteParameter;
import de.gebit.integrity.dsl.SuiteParameterDefinition;
import de.gebit.integrity.dsl.SuiteReturn;
import de.gebit.integrity.dsl.SuiteReturnDefinition;
import de.gebit.integrity.dsl.TableTest;
import de.gebit.integrity.dsl.TableTestRow;
import de.gebit.integrity.dsl.Test;
import de.gebit.integrity.dsl.TestDefinition;
import de.gebit.integrity.dsl.TimeDifference;
import de.gebit.integrity.dsl.TimeProgressionFactor;
import de.gebit.integrity.dsl.TimeSet;
import de.gebit.integrity.dsl.TypedNestedObject;
import de.gebit.integrity.dsl.USDateAnd12HrsTimeValue;
import de.gebit.integrity.dsl.USDateValue;
import de.gebit.integrity.dsl.ValueOrEnumValueOrOperationCollection;
import de.gebit.integrity.dsl.Variable;
import de.gebit.integrity.dsl.VariableAssignment;
import de.gebit.integrity.dsl.VariableDefinition;
import de.gebit.integrity.dsl.VariableEntity;
import de.gebit.integrity.dsl.VariableVariable;
import de.gebit.integrity.dsl.VariantDefinition;
import de.gebit.integrity.dsl.VariantValue;
import de.gebit.integrity.dsl.VisibleDivider;
import de.gebit.integrity.dsl.VisibleMultiLineNormalComment;
import de.gebit.integrity.dsl.VisibleMultiLineTitleComment;
import de.gebit.integrity.dsl.VisibleSingleLineNormalComment;
import de.gebit.integrity.dsl.VisibleSingleLineTitleComment;
import de.gebit.integrity.services.DSLGrammarAccess;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractDSLSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DSLGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == DslPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case DslPackage.ARBITRARY_PARAMETER_OR_RESULT_NAME:
				sequence_ArbitraryParameterOrResultName(context, (ArbitraryParameterOrResultName) semanticObject); 
				return; 
			case DslPackage.BOOLEAN_VALUE:
				sequence_BooleanValue(context, (BooleanValue) semanticObject); 
				return; 
			case DslPackage.CALL:
				sequence_Call(context, (Call) semanticObject); 
				return; 
			case DslPackage.CALL_DEFINITION:
				sequence_CallDefinition(context, (CallDefinition) semanticObject); 
				return; 
			case DslPackage.CONSTANT:
				sequence_Constant(context, (Constant) semanticObject); 
				return; 
			case DslPackage.CONSTANT_DEFINITION:
				sequence_ConstantDefinition(context, (ConstantDefinition) semanticObject); 
				return; 
			case DslPackage.CONSTANT_ENTITY:
				sequence_ConstantEntity(context, (ConstantEntity) semanticObject); 
				return; 
			case DslPackage.CUSTOM_OPERATION:
				sequence_CustomOperation(context, (CustomOperation) semanticObject); 
				return; 
			case DslPackage.DECIMAL_VALUE:
				sequence_DecimalValue(context, (DecimalValue) semanticObject); 
				return; 
			case DslPackage.DOCUMENTATION_COMMENT:
				sequence_DocumentationComment(context, (DocumentationComment) semanticObject); 
				return; 
			case DslPackage.EMPTY:
				sequence_EmptyValue(context, (Empty) semanticObject); 
				return; 
			case DslPackage.ENUM_VALUE:
				sequence_EnumValue(context, (EnumValue) semanticObject); 
				return; 
			case DslPackage.EUROPEAN_DATE_AND12_HRS_TIME_VALUE:
				sequence_EuropeanDateAnd12HrsTimeValue(context, (EuropeanDateAnd12HrsTimeValue) semanticObject); 
				return; 
			case DslPackage.EUROPEAN_DATE_AND24_HRS_TIME_VALUE:
				sequence_EuropeanDateAnd24HrsTimeValue(context, (EuropeanDateAnd24HrsTimeValue) semanticObject); 
				return; 
			case DslPackage.EUROPEAN_DATE_VALUE:
				sequence_EuropeanDateValue(context, (EuropeanDateValue) semanticObject); 
				return; 
			case DslPackage.EXECUTION_MULTIPLIER:
				sequence_ExecutionMultiplier(context, (ExecutionMultiplier) semanticObject); 
				return; 
			case DslPackage.FIXED_PARAMETER_NAME:
				sequence_FixedParameterName(context, (FixedParameterName) semanticObject); 
				return; 
			case DslPackage.FIXED_RESULT_NAME:
				sequence_FixedResultName(context, (FixedResultName) semanticObject); 
				return; 
			case DslPackage.FORK_DEFINITION:
				sequence_ForkDefinition(context, (ForkDefinition) semanticObject); 
				return; 
			case DslPackage.FORK_PARAMETER:
				sequence_ForkParameter(context, (ForkParameter) semanticObject); 
				return; 
			case DslPackage.IMPORT:
				sequence_Import(context, (Import) semanticObject); 
				return; 
			case DslPackage.INEXISTENT:
				sequence_InexistentValue(context, (Inexistent) semanticObject); 
				return; 
			case DslPackage.INTEGER_VALUE:
				sequence_IntegerValue(context, (IntegerValue) semanticObject); 
				return; 
			case DslPackage.ISO_DATE_AND_TIME_VALUE:
				sequence_IsoDateAndTimeValue(context, (IsoDateAndTimeValue) semanticObject); 
				return; 
			case DslPackage.ISO_DATE_VALUE:
				sequence_IsoDateValue(context, (IsoDateValue) semanticObject); 
				return; 
			case DslPackage.ISO_TIME_VALUE:
				sequence_IsoTimeValue(context, (IsoTimeValue) semanticObject); 
				return; 
			case DslPackage.JAVA_CLASS_REFERENCE:
				sequence_JavaClassReference(context, (JavaClassReference) semanticObject); 
				return; 
			case DslPackage.JAVA_CONSTANT_REFERENCE:
				sequence_JavaConstantReference(context, (JavaConstantReference) semanticObject); 
				return; 
			case DslPackage.JAVA_CONSTANT_VALUE:
				sequence_JavaConstantValue(context, (JavaConstantValue) semanticObject); 
				return; 
			case DslPackage.KEY_VALUE_PAIR:
				sequence_KeyValuePair(context, (KeyValuePair) semanticObject); 
				return; 
			case DslPackage.METHOD_REFERENCE:
				sequence_MethodReference(context, (MethodReference) semanticObject); 
				return; 
			case DslPackage.MODEL:
				sequence_Model(context, (Model) semanticObject); 
				return; 
			case DslPackage.NAMED_CALL_RESULT:
				sequence_NamedCallResult(context, (NamedCallResult) semanticObject); 
				return; 
			case DslPackage.NAMED_RESULT:
				sequence_NamedResult(context, (NamedResult) semanticObject); 
				return; 
			case DslPackage.NESTED_OBJECT:
				sequence_NestedObject(context, (NestedObject) semanticObject); 
				return; 
			case DslPackage.NULL:
				sequence_NullValue(context, (Null) semanticObject); 
				return; 
			case DslPackage.OPERATION_DEFINITION:
				sequence_OperationDefinition(context, (OperationDefinition) semanticObject); 
				return; 
			case DslPackage.PACKAGE_DEFINITION:
				sequence_PackageDefinition(context, (PackageDefinition) semanticObject); 
				return; 
			case DslPackage.PARAMETER:
				sequence_Parameter(context, (de.gebit.integrity.dsl.Parameter) semanticObject); 
				return; 
			case DslPackage.PARAMETER_TABLE_HEADER:
				sequence_ParameterTableHeader(context, (ParameterTableHeader) semanticObject); 
				return; 
			case DslPackage.PARAMETER_TABLE_VALUE:
				sequence_ParameterTableValue(context, (ParameterTableValue) semanticObject); 
				return; 
			case DslPackage.REGEX_VALUE:
				sequence_RegexValue(context, (RegexValue) semanticObject); 
				return; 
			case DslPackage.RESULT_TABLE_HEADER:
				sequence_ResultTableHeader(context, (ResultTableHeader) semanticObject); 
				return; 
			case DslPackage.SIMPLE12_HRS_TIME_VALUE:
				sequence_Simple12HrsTimeValue(context, (Simple12HrsTimeValue) semanticObject); 
				return; 
			case DslPackage.SIMPLE24_HRS_TIME_VALUE:
				sequence_Simple24HrsTimeValue(context, (Simple24HrsTimeValue) semanticObject); 
				return; 
			case DslPackage.STANDARD_OPERATION:
				sequence_StandardOperation(context, (StandardOperation) semanticObject); 
				return; 
			case DslPackage.STRING_VALUE:
				sequence_StringValue(context, (StringValue) semanticObject); 
				return; 
			case DslPackage.SUITE:
				sequence_Suite(context, (Suite) semanticObject); 
				return; 
			case DslPackage.SUITE_DEFINITION:
				sequence_SuiteDefinition(context, (SuiteDefinition) semanticObject); 
				return; 
			case DslPackage.SUITE_PARAMETER:
				sequence_SuiteParameter(context, (SuiteParameter) semanticObject); 
				return; 
			case DslPackage.SUITE_PARAMETER_DEFINITION:
				sequence_SuiteParameterDefinition(context, (SuiteParameterDefinition) semanticObject); 
				return; 
			case DslPackage.SUITE_RETURN:
				sequence_SuiteReturn(context, (SuiteReturn) semanticObject); 
				return; 
			case DslPackage.SUITE_RETURN_DEFINITION:
				sequence_SuiteReturnDefinition(context, (SuiteReturnDefinition) semanticObject); 
				return; 
			case DslPackage.TABLE_TEST:
				sequence_TableTest(context, (TableTest) semanticObject); 
				return; 
			case DslPackage.TABLE_TEST_ROW:
				sequence_TableTestRow(context, (TableTestRow) semanticObject); 
				return; 
			case DslPackage.TEST:
				sequence_Test(context, (Test) semanticObject); 
				return; 
			case DslPackage.TEST_DEFINITION:
				sequence_TestDefinition(context, (TestDefinition) semanticObject); 
				return; 
			case DslPackage.TIME_DIFFERENCE:
				sequence_TimeDifference(context, (TimeDifference) semanticObject); 
				return; 
			case DslPackage.TIME_PROGRESSION_FACTOR:
				sequence_TimeProgressionFactor(context, (TimeProgressionFactor) semanticObject); 
				return; 
			case DslPackage.TIME_SET:
				sequence_TimeSet(context, (TimeSet) semanticObject); 
				return; 
			case DslPackage.TYPED_NESTED_OBJECT:
				sequence_TypedNestedObject(context, (TypedNestedObject) semanticObject); 
				return; 
			case DslPackage.US_DATE_AND12_HRS_TIME_VALUE:
				sequence_USDateAnd12HrsTimeValue(context, (USDateAnd12HrsTimeValue) semanticObject); 
				return; 
			case DslPackage.US_DATE_VALUE:
				sequence_USDateValue(context, (USDateValue) semanticObject); 
				return; 
			case DslPackage.VALUE_OR_ENUM_VALUE_OR_OPERATION_COLLECTION:
				sequence_ValueOrEnumValueOrOperationCollection(context, (ValueOrEnumValueOrOperationCollection) semanticObject); 
				return; 
			case DslPackage.VARIABLE:
				sequence_Variable(context, (Variable) semanticObject); 
				return; 
			case DslPackage.VARIABLE_ASSIGNMENT:
				sequence_VariableAssignment(context, (VariableAssignment) semanticObject); 
				return; 
			case DslPackage.VARIABLE_DEFINITION:
				sequence_VariableDefinition(context, (VariableDefinition) semanticObject); 
				return; 
			case DslPackage.VARIABLE_ENTITY:
				sequence_VariableEntity(context, (VariableEntity) semanticObject); 
				return; 
			case DslPackage.VARIABLE_VARIABLE:
				sequence_VariableVariable(context, (VariableVariable) semanticObject); 
				return; 
			case DslPackage.VARIANT_DEFINITION:
				sequence_VariantDefinition(context, (VariantDefinition) semanticObject); 
				return; 
			case DslPackage.VARIANT_VALUE:
				sequence_VariantValue(context, (VariantValue) semanticObject); 
				return; 
			case DslPackage.VISIBLE_DIVIDER:
				sequence_VisibleDivider(context, (VisibleDivider) semanticObject); 
				return; 
			case DslPackage.VISIBLE_MULTI_LINE_NORMAL_COMMENT:
				sequence_VisibleMultiLineNormalComment(context, (VisibleMultiLineNormalComment) semanticObject); 
				return; 
			case DslPackage.VISIBLE_MULTI_LINE_TITLE_COMMENT:
				sequence_VisibleMultiLineTitleComment(context, (VisibleMultiLineTitleComment) semanticObject); 
				return; 
			case DslPackage.VISIBLE_SINGLE_LINE_NORMAL_COMMENT:
				sequence_VisibleSingleLineNormalComment(context, (VisibleSingleLineNormalComment) semanticObject); 
				return; 
			case DslPackage.VISIBLE_SINGLE_LINE_TITLE_COMMENT:
				sequence_VisibleSingleLineTitleComment(context, (VisibleSingleLineTitleComment) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     ResultName returns ArbitraryParameterOrResultName
	 *     ParameterName returns ArbitraryParameterOrResultName
	 *     ArbitraryParameterOrResultName returns ArbitraryParameterOrResultName
	 *
	 * Constraint:
	 *     (identifier=ID | stringIdentifier=STRING)
	 * </pre>
	 */
	protected void sequence_ArbitraryParameterOrResultName(ISerializationContext context, ArbitraryParameterOrResultName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns BooleanValue
	 *     Value returns BooleanValue
	 *     ConstantValue returns BooleanValue
	 *     StaticValue returns BooleanValue
	 *     BooleanValue returns BooleanValue
	 *
	 * Constraint:
	 *     (booleanValue=BOOLEAN_TRUE | booleanValue=BOOLEAN_FALSE)
	 * </pre>
	 */
	protected void sequence_BooleanValue(ISerializationContext context, BooleanValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns CallDefinition
	 *     CallDefinition returns CallDefinition
	 *
	 * Constraint:
	 *     (documentation=DocumentationComment? name=QualifiedName fixtureMethod=MethodReference)
	 * </pre>
	 */
	protected void sequence_CallDefinition(ISerializationContext context, CallDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns Call
	 *     SuiteStatementWithResult returns Call
	 *     Call returns Call
	 *
	 * Constraint:
	 *     (
	 *         multiplier=ExecutionMultiplier? 
	 *         definition=[CallDefinition|QualifiedName] 
	 *         parameters+=Parameter* 
	 *         results+=NamedCallResult* 
	 *         result=VariableVariable?
	 *     )
	 * </pre>
	 */
	protected void sequence_Call(ISerializationContext context, Call semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns ConstantDefinition
	 *     SuiteStatement returns ConstantDefinition
	 *     ConstantDefinition returns ConstantDefinition
	 *
	 * Constraint:
	 *     (
	 *         documentation=DocumentationComment? 
	 *         private='private'? 
	 *         name=ConstantEntity 
	 *         value=ValueOrEnumValueOrOperationCollection? 
	 *         variantValues+=VariantValue* 
	 *         parameterized='parameterized'?
	 *     )
	 * </pre>
	 */
	protected void sequence_ConstantDefinition(ISerializationContext context, ConstantDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ConstantEntity returns ConstantEntity
	 *     VariableOrConstantEntity returns ConstantEntity
	 *
	 * Constraint:
	 *     name=QualifiedName
	 * </pre>
	 */
	protected void sequence_ConstantEntity(ISerializationContext context, ConstantEntity semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VARIABLE_OR_CONSTANT_ENTITY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VARIABLE_OR_CONSTANT_ENTITY__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConstantEntityAccess().getNameQualifiedNameParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ConstantValue returns Constant
	 *     Constant returns Constant
	 *
	 * Constraint:
	 *     name=[ConstantEntity|QualifiedName]
	 * </pre>
	 */
	protected void sequence_Constant(ISerializationContext context, Constant semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.CONSTANT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.CONSTANT__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConstantAccess().getNameConstantEntityQualifiedNameParserRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.CONSTANT__NAME, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Operation returns CustomOperation
	 *     CustomOperation returns CustomOperation
	 *     ValueOrEnumValueOrOperation returns CustomOperation
	 *
	 * Constraint:
	 *     (
	 *         prefixOperand=ValueOrEnumValueOrOperationCollection? 
	 *         definition=[OperationDefinition|QualifiedName] 
	 *         postfixOperand=ValueOrEnumValueOrOperationCollection?
	 *     )
	 * </pre>
	 */
	protected void sequence_CustomOperation(ISerializationContext context, CustomOperation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns DecimalValue
	 *     Value returns DecimalValue
	 *     ConstantValue returns DecimalValue
	 *     StaticValue returns DecimalValue
	 *     DecimalValue returns DecimalValue
	 *
	 * Constraint:
	 *     decimalValue=DECIMAL
	 * </pre>
	 */
	protected void sequence_DecimalValue(ISerializationContext context, DecimalValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DECIMAL_VALUE__DECIMAL_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DECIMAL_VALUE__DECIMAL_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDecimalValueAccess().getDecimalValueDECIMALTerminalRuleCall_0(), semanticObject.getDecimalValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     DocumentationComment returns DocumentationComment
	 *
	 * Constraint:
	 *     content=ML_DOC_COMMENT
	 * </pre>
	 */
	protected void sequence_DocumentationComment(ISerializationContext context, DocumentationComment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DOCUMENTATION_COMMENT__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DOCUMENTATION_COMMENT__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDocumentationCommentAccess().getContentML_DOC_COMMENTTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Empty
	 *     Value returns Empty
	 *     ConstantValue returns Empty
	 *     StaticValue returns Empty
	 *     EmptyValue returns Empty
	 *
	 * Constraint:
	 *     {Empty}
	 * </pre>
	 */
	protected void sequence_EmptyValue(ISerializationContext context, Empty semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns EnumValue
	 *     EnumValue returns EnumValue
	 *
	 * Constraint:
	 *     enumValue=[JvmEnumerationLiteral|UPPERCASE_ID]
	 * </pre>
	 */
	protected void sequence_EnumValue(ISerializationContext context, EnumValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.ENUM_VALUE__ENUM_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.ENUM_VALUE__ENUM_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEnumValueAccess().getEnumValueJvmEnumerationLiteralUPPERCASE_IDTerminalRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.ENUM_VALUE__ENUM_VALUE, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns EuropeanDateAnd12HrsTimeValue
	 *     Value returns EuropeanDateAnd12HrsTimeValue
	 *     ConstantValue returns EuropeanDateAnd12HrsTimeValue
	 *     StaticValue returns EuropeanDateAnd12HrsTimeValue
	 *     DateAndTimeValue returns EuropeanDateAnd12HrsTimeValue
	 *     EuropeanDateAnd12HrsTimeValue returns EuropeanDateAnd12HrsTimeValue
	 *
	 * Constraint:
	 *     (dateValue=EURODATE timeValue=TWELVEHRSTIME)
	 * </pre>
	 */
	protected void sequence_EuropeanDateAnd12HrsTimeValue(ISerializationContext context, EuropeanDateAnd12HrsTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEuropeanDateAnd12HrsTimeValueAccess().getDateValueEURODATETerminalRuleCall_0_0(), semanticObject.getDateValue());
		feeder.accept(grammarAccess.getEuropeanDateAnd12HrsTimeValueAccess().getTimeValueTWELVEHRSTIMETerminalRuleCall_2_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns EuropeanDateAnd24HrsTimeValue
	 *     Value returns EuropeanDateAnd24HrsTimeValue
	 *     ConstantValue returns EuropeanDateAnd24HrsTimeValue
	 *     StaticValue returns EuropeanDateAnd24HrsTimeValue
	 *     DateAndTimeValue returns EuropeanDateAnd24HrsTimeValue
	 *     EuropeanDateAnd24HrsTimeValue returns EuropeanDateAnd24HrsTimeValue
	 *
	 * Constraint:
	 *     (dateValue=EURODATE timeValue=TWENTYFOURHRSTIME)
	 * </pre>
	 */
	protected void sequence_EuropeanDateAnd24HrsTimeValue(ISerializationContext context, EuropeanDateAnd24HrsTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEuropeanDateAnd24HrsTimeValueAccess().getDateValueEURODATETerminalRuleCall_0_0(), semanticObject.getDateValue());
		feeder.accept(grammarAccess.getEuropeanDateAnd24HrsTimeValueAccess().getTimeValueTWENTYFOURHRSTIMETerminalRuleCall_2_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns EuropeanDateValue
	 *     Value returns EuropeanDateValue
	 *     ConstantValue returns EuropeanDateValue
	 *     StaticValue returns EuropeanDateValue
	 *     DateValue returns EuropeanDateValue
	 *     EuropeanDateValue returns EuropeanDateValue
	 *
	 * Constraint:
	 *     dateValue=EURODATE
	 * </pre>
	 */
	protected void sequence_EuropeanDateValue(ISerializationContext context, EuropeanDateValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEuropeanDateValueAccess().getDateValueEURODATETerminalRuleCall_0(), semanticObject.getDateValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ExecutionMultiplier returns ExecutionMultiplier
	 *
	 * Constraint:
	 *     count=ConstantValue
	 * </pre>
	 */
	protected void sequence_ExecutionMultiplier(ISerializationContext context, ExecutionMultiplier semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.EXECUTION_MULTIPLIER__COUNT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.EXECUTION_MULTIPLIER__COUNT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getExecutionMultiplierAccess().getCountConstantValueParserRuleCall_0_0(), semanticObject.getCount());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ParameterName returns FixedParameterName
	 *     FixedParameterName returns FixedParameterName
	 *
	 * Constraint:
	 *     annotation=[JvmAnnotationReference|ID]
	 * </pre>
	 */
	protected void sequence_FixedParameterName(ISerializationContext context, FixedParameterName semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.FIXED_PARAMETER_NAME__ANNOTATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.FIXED_PARAMETER_NAME__ANNOTATION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFixedParameterNameAccess().getAnnotationJvmAnnotationReferenceIDTerminalRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.FIXED_PARAMETER_NAME__ANNOTATION, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ResultName returns FixedResultName
	 *     FixedResultName returns FixedResultName
	 *
	 * Constraint:
	 *     field=[JvmField|ID]
	 * </pre>
	 */
	protected void sequence_FixedResultName(ISerializationContext context, FixedResultName semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.FIXED_RESULT_NAME__FIELD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.FIXED_RESULT_NAME__FIELD));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFixedResultNameAccess().getFieldJvmFieldIDTerminalRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.FIXED_RESULT_NAME__FIELD, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Statement returns ForkDefinition
	 *     PackageStatement returns ForkDefinition
	 *     ForkDefinition returns ForkDefinition
	 *
	 * Constraint:
	 *     (
	 *         documentation=DocumentationComment? 
	 *         private='private'? 
	 *         name=QualifiedName 
	 *         description=STRING? 
	 *         (forkerClass=JavaClassReference | baseFork=[ForkDefinition|QualifiedName])? 
	 *         parameters+=ForkParameter*
	 *     )
	 * </pre>
	 */
	protected void sequence_ForkDefinition(ISerializationContext context, ForkDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ForkParameter returns ForkParameter
	 *
	 * Constraint:
	 *     (name=FixedParameterName value=ValueOrEnumValueOrOperation)
	 * </pre>
	 */
	protected void sequence_ForkParameter(ISerializationContext context, ForkParameter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.FORK_PARAMETER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.FORK_PARAMETER__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.FORK_PARAMETER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.FORK_PARAMETER__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getForkParameterAccess().getNameFixedParameterNameParserRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getForkParameterAccess().getValueValueOrEnumValueOrOperationParserRuleCall_4_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Import returns Import
	 *
	 * Constraint:
	 *     importedNamespace=QualifiedNameWithWildcard
	 * </pre>
	 */
	protected void sequence_Import(ISerializationContext context, Import semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.IMPORT__IMPORTED_NAMESPACE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.IMPORT__IMPORTED_NAMESPACE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_0(), semanticObject.getImportedNamespace());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Inexistent
	 *     Value returns Inexistent
	 *     ConstantValue returns Inexistent
	 *     StaticValue returns Inexistent
	 *     InexistentValue returns Inexistent
	 *
	 * Constraint:
	 *     {Inexistent}
	 * </pre>
	 */
	protected void sequence_InexistentValue(ISerializationContext context, Inexistent semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns IntegerValue
	 *     Value returns IntegerValue
	 *     ConstantValue returns IntegerValue
	 *     StaticValue returns IntegerValue
	 *     IntegerValue returns IntegerValue
	 *
	 * Constraint:
	 *     integerValue=INTEGER
	 * </pre>
	 */
	protected void sequence_IntegerValue(ISerializationContext context, IntegerValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.INTEGER_VALUE__INTEGER_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.INTEGER_VALUE__INTEGER_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntegerValueAccess().getIntegerValueINTEGERTerminalRuleCall_0(), semanticObject.getIntegerValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns IsoDateAndTimeValue
	 *     Value returns IsoDateAndTimeValue
	 *     ConstantValue returns IsoDateAndTimeValue
	 *     StaticValue returns IsoDateAndTimeValue
	 *     DateAndTimeValue returns IsoDateAndTimeValue
	 *     IsoDateAndTimeValue returns IsoDateAndTimeValue
	 *
	 * Constraint:
	 *     (dateValue=ISODATE timeValue=ISOTIME)
	 * </pre>
	 */
	protected void sequence_IsoDateAndTimeValue(ISerializationContext context, IsoDateAndTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIsoDateAndTimeValueAccess().getDateValueISODATETerminalRuleCall_0_0(), semanticObject.getDateValue());
		feeder.accept(grammarAccess.getIsoDateAndTimeValueAccess().getTimeValueISOTIMETerminalRuleCall_1_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns IsoDateValue
	 *     Value returns IsoDateValue
	 *     ConstantValue returns IsoDateValue
	 *     StaticValue returns IsoDateValue
	 *     DateValue returns IsoDateValue
	 *     IsoDateValue returns IsoDateValue
	 *
	 * Constraint:
	 *     dateValue=ISODATE
	 * </pre>
	 */
	protected void sequence_IsoDateValue(ISerializationContext context, IsoDateValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIsoDateValueAccess().getDateValueISODATETerminalRuleCall_0(), semanticObject.getDateValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns IsoTimeValue
	 *     Value returns IsoTimeValue
	 *     ConstantValue returns IsoTimeValue
	 *     StaticValue returns IsoTimeValue
	 *     TimeValue returns IsoTimeValue
	 *     IsoTimeValue returns IsoTimeValue
	 *
	 * Constraint:
	 *     timeValue=ISOTIME
	 * </pre>
	 */
	protected void sequence_IsoTimeValue(ISerializationContext context, IsoTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIsoTimeValueAccess().getTimeValueISOTIMETerminalRuleCall_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     JavaClassReference returns JavaClassReference
	 *
	 * Constraint:
	 *     type=[JvmType|QualifiedJavaClassName]
	 * </pre>
	 */
	protected void sequence_JavaClassReference(ISerializationContext context, JavaClassReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.JAVA_CLASS_REFERENCE__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.JAVA_CLASS_REFERENCE__TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getJavaClassReferenceAccess().getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.JAVA_CLASS_REFERENCE__TYPE, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     JavaConstantReference returns JavaConstantReference
	 *
	 * Constraint:
	 *     (type=[JvmType|QualifiedJavaClassName] constant=[JvmField|UPPERCASE_ID])
	 * </pre>
	 */
	protected void sequence_JavaConstantReference(ISerializationContext context, JavaConstantReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.JAVA_CONSTANT_REFERENCE__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.JAVA_CONSTANT_REFERENCE__TYPE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.JAVA_CONSTANT_REFERENCE__CONSTANT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.JAVA_CONSTANT_REFERENCE__CONSTANT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getJavaConstantReferenceAccess().getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1(), semanticObject.eGet(DslPackage.Literals.JAVA_CONSTANT_REFERENCE__TYPE, false));
		feeder.accept(grammarAccess.getJavaConstantReferenceAccess().getConstantJvmFieldUPPERCASE_IDTerminalRuleCall_2_0_1(), semanticObject.eGet(DslPackage.Literals.JAVA_CONSTANT_REFERENCE__CONSTANT, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns JavaConstantValue
	 *     Value returns JavaConstantValue
	 *     ConstantValue returns JavaConstantValue
	 *     StaticValue returns JavaConstantValue
	 *     JavaConstantValue returns JavaConstantValue
	 *
	 * Constraint:
	 *     constant=JavaConstantReference
	 * </pre>
	 */
	protected void sequence_JavaConstantValue(ISerializationContext context, JavaConstantValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.JAVA_CONSTANT_VALUE__CONSTANT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.JAVA_CONSTANT_VALUE__CONSTANT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getJavaConstantValueAccess().getConstantJavaConstantReferenceParserRuleCall_1_0(), semanticObject.getConstant());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     KeyValuePair returns KeyValuePair
	 *
	 * Constraint:
	 *     ((identifier=ID | stringIdentifier=STRING) value=ValueOrEnumValueOrOperationCollection)
	 * </pre>
	 */
	protected void sequence_KeyValuePair(ISerializationContext context, KeyValuePair semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     MethodReference returns MethodReference
	 *
	 * Constraint:
	 *     (type=[JvmType|QualifiedJavaClassName] method=[JvmOperation|ID])
	 * </pre>
	 */
	protected void sequence_MethodReference(ISerializationContext context, MethodReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.METHOD_REFERENCE__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.METHOD_REFERENCE__TYPE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.METHOD_REFERENCE__METHOD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.METHOD_REFERENCE__METHOD));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMethodReferenceAccess().getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1(), semanticObject.eGet(DslPackage.Literals.METHOD_REFERENCE__TYPE, false));
		feeder.accept(grammarAccess.getMethodReferenceAccess().getMethodJvmOperationIDTerminalRuleCall_2_0_1(), semanticObject.eGet(DslPackage.Literals.METHOD_REFERENCE__METHOD, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Model returns Model
	 *
	 * Constraint:
	 *     (imports+=Import* statements+=Statement*)
	 * </pre>
	 */
	protected void sequence_Model(ISerializationContext context, Model semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     NamedCallResult returns NamedCallResult
	 *
	 * Constraint:
	 *     (name=ResultName target=VariableVariable)
	 * </pre>
	 */
	protected void sequence_NamedCallResult(ISerializationContext context, NamedCallResult semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.NAMED_CALL_RESULT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.NAMED_CALL_RESULT__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.NAMED_CALL_RESULT__TARGET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.NAMED_CALL_RESULT__TARGET));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getNamedCallResultAccess().getNameResultNameParserRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getNamedCallResultAccess().getTargetVariableVariableParserRuleCall_4_0(), semanticObject.getTarget());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     NamedResult returns NamedResult
	 *
	 * Constraint:
	 *     (name=ResultName value=ValueOrEnumValueOrOperationCollection)
	 * </pre>
	 */
	protected void sequence_NamedResult(ISerializationContext context, NamedResult semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.NAMED_RESULT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.NAMED_RESULT__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.NAMED_RESULT__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.NAMED_RESULT__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getNamedResultAccess().getNameResultNameParserRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getNamedResultAccess().getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns NestedObject
	 *     Value returns NestedObject
	 *     NestedObject returns NestedObject
	 *
	 * Constraint:
	 *     attributes+=KeyValuePair+
	 * </pre>
	 */
	protected void sequence_NestedObject(ISerializationContext context, NestedObject semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Null
	 *     Value returns Null
	 *     ConstantValue returns Null
	 *     StaticValue returns Null
	 *     NullValue returns Null
	 *
	 * Constraint:
	 *     {Null}
	 * </pre>
	 */
	protected void sequence_NullValue(ISerializationContext context, Null semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns OperationDefinition
	 *     OperationDefinition returns OperationDefinition
	 *
	 * Constraint:
	 *     (name=QualifiedName operationType=JavaClassReference)
	 * </pre>
	 */
	protected void sequence_OperationDefinition(ISerializationContext context, OperationDefinition semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.OPERATION_DEFINITION__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.OPERATION_DEFINITION__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.OPERATION_DEFINITION__OPERATION_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.OPERATION_DEFINITION__OPERATION_TYPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getOperationDefinitionAccess().getNameQualifiedNameParserRuleCall_2_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getOperationDefinitionAccess().getOperationTypeJavaClassReferenceParserRuleCall_6_0(), semanticObject.getOperationType());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Statement returns PackageDefinition
	 *     PackageDefinition returns PackageDefinition
	 *
	 * Constraint:
	 *     (documentation=DocumentationComment? name=QualifiedName statements+=PackageStatement*)
	 * </pre>
	 */
	protected void sequence_PackageDefinition(ISerializationContext context, PackageDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ParameterTableHeader returns ParameterTableHeader
	 *
	 * Constraint:
	 *     name=ParameterName
	 * </pre>
	 */
	protected void sequence_ParameterTableHeader(ISerializationContext context, ParameterTableHeader semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.PARAMETER_TABLE_HEADER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.PARAMETER_TABLE_HEADER__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParameterTableHeaderAccess().getNameParameterNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ParameterTableValue returns ParameterTableValue
	 *
	 * Constraint:
	 *     value=ValueOrEnumValueOrOperationCollection
	 * </pre>
	 */
	protected void sequence_ParameterTableValue(ISerializationContext context, ParameterTableValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.PARAMETER_TABLE_VALUE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.PARAMETER_TABLE_VALUE__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParameterTableValueAccess().getValueValueOrEnumValueOrOperationCollectionParserRuleCall_1_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Parameter returns Parameter
	 *
	 * Constraint:
	 *     (name=ParameterName value=ValueOrEnumValueOrOperationCollection)
	 * </pre>
	 */
	protected void sequence_Parameter(ISerializationContext context, de.gebit.integrity.dsl.Parameter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.PARAMETER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.PARAMETER__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.PARAMETER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.PARAMETER__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParameterAccess().getNameParameterNameParserRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getParameterAccess().getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns RegexValue
	 *     Value returns RegexValue
	 *     ConstantValue returns RegexValue
	 *     StaticValue returns RegexValue
	 *     RegexValue returns RegexValue
	 *
	 * Constraint:
	 *     regexValue=REGEX
	 * </pre>
	 */
	protected void sequence_RegexValue(ISerializationContext context, RegexValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.REGEX_VALUE__REGEX_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.REGEX_VALUE__REGEX_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRegexValueAccess().getRegexValueREGEXTerminalRuleCall_0(), semanticObject.getRegexValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ResultTableHeader returns ResultTableHeader
	 *
	 * Constraint:
	 *     name=ResultName
	 * </pre>
	 */
	protected void sequence_ResultTableHeader(ISerializationContext context, ResultTableHeader semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.RESULT_TABLE_HEADER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.RESULT_TABLE_HEADER__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getResultTableHeaderAccess().getNameResultNameParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Simple12HrsTimeValue
	 *     Value returns Simple12HrsTimeValue
	 *     ConstantValue returns Simple12HrsTimeValue
	 *     StaticValue returns Simple12HrsTimeValue
	 *     TimeValue returns Simple12HrsTimeValue
	 *     Simple12HrsTimeValue returns Simple12HrsTimeValue
	 *
	 * Constraint:
	 *     timeValue=TWELVEHRSTIME
	 * </pre>
	 */
	protected void sequence_Simple12HrsTimeValue(ISerializationContext context, Simple12HrsTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSimple12HrsTimeValueAccess().getTimeValueTWELVEHRSTIMETerminalRuleCall_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Simple24HrsTimeValue
	 *     Value returns Simple24HrsTimeValue
	 *     ConstantValue returns Simple24HrsTimeValue
	 *     StaticValue returns Simple24HrsTimeValue
	 *     TimeValue returns Simple24HrsTimeValue
	 *     Simple24HrsTimeValue returns Simple24HrsTimeValue
	 *
	 * Constraint:
	 *     timeValue=TWENTYFOURHRSTIME
	 * </pre>
	 */
	protected void sequence_Simple24HrsTimeValue(ISerializationContext context, Simple24HrsTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSimple24HrsTimeValueAccess().getTimeValueTWENTYFOURHRSTIMETerminalRuleCall_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Operation returns StandardOperation
	 *     StandardOperation returns StandardOperation
	 *     ValueOrEnumValueOrOperation returns StandardOperation
	 *
	 * Constraint:
	 *     (
	 *         firstOperand=ValueOrEnumValueOrOperation 
	 *         (
	 *             (
	 *                 operators+='+' | 
	 *                 operators+='-' | 
	 *                 operators+='*' | 
	 *                 operators+='/' | 
	 *                 operators+='%' | 
	 *                 operators+='..'
	 *             ) 
	 *             moreOperands+=ValueOrEnumValueOrOperation
	 *         )+
	 *     )
	 * </pre>
	 */
	protected void sequence_StandardOperation(ISerializationContext context, StandardOperation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns StringValue
	 *     Value returns StringValue
	 *     ConstantValue returns StringValue
	 *     StaticValue returns StringValue
	 *     StringValue returns StringValue
	 *
	 * Constraint:
	 *     stringValue=STRING
	 * </pre>
	 */
	protected void sequence_StringValue(ISerializationContext context, StringValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.STRING_VALUE__STRING_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.STRING_VALUE__STRING_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStringValueAccess().getStringValueSTRINGTerminalRuleCall_0(), semanticObject.getStringValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns SuiteDefinition
	 *     SuiteDefinition returns SuiteDefinition
	 *
	 * Constraint:
	 *     (
	 *         documentation=DocumentationComment? 
	 *         private='private'? 
	 *         singleRun='single-run'? 
	 *         inlined='inlined'? 
	 *         name=QualifiedName 
	 *         parameters+=SuiteParameterDefinition* 
	 *         return+=SuiteReturnDefinition* 
	 *         dependencies+=[SuiteDefinition|QualifiedName]* 
	 *         finalizers+=[SuiteDefinition|QualifiedName]* 
	 *         statements+=SuiteStatement*
	 *     )
	 * </pre>
	 */
	protected void sequence_SuiteDefinition(ISerializationContext context, SuiteDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteParameterDefinition returns SuiteParameterDefinition
	 *
	 * Constraint:
	 *     (name=VariableEntity default=ValueOrEnumValueOrOperationCollection?)
	 * </pre>
	 */
	protected void sequence_SuiteParameterDefinition(ISerializationContext context, SuiteParameterDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteParameter returns SuiteParameter
	 *
	 * Constraint:
	 *     (name=[VariableOrConstantEntity|QualifiedName] value=ValueOrEnumValueOrOperationCollection)
	 * </pre>
	 */
	protected void sequence_SuiteParameter(ISerializationContext context, SuiteParameter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.SUITE_PARAMETER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.SUITE_PARAMETER__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.SUITE_PARAMETER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.SUITE_PARAMETER__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSuiteParameterAccess().getNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1(), semanticObject.eGet(DslPackage.Literals.SUITE_PARAMETER__NAME, false));
		feeder.accept(grammarAccess.getSuiteParameterAccess().getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteReturnDefinition returns SuiteReturnDefinition
	 *
	 * Constraint:
	 *     name=VariableEntity
	 * </pre>
	 */
	protected void sequence_SuiteReturnDefinition(ISerializationContext context, SuiteReturnDefinition semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.SUITE_RETURN_DEFINITION__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.SUITE_RETURN_DEFINITION__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSuiteReturnDefinitionAccess().getNameVariableEntityParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteReturn returns SuiteReturn
	 *
	 * Constraint:
	 *     (name=[SuiteReturnDefinition|QualifiedName] target=VariableVariable)
	 * </pre>
	 */
	protected void sequence_SuiteReturn(ISerializationContext context, SuiteReturn semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.SUITE_RETURN__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.SUITE_RETURN__NAME));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.SUITE_RETURN__TARGET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.SUITE_RETURN__TARGET));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSuiteReturnAccess().getNameSuiteReturnDefinitionQualifiedNameParserRuleCall_0_0_1(), semanticObject.eGet(DslPackage.Literals.SUITE_RETURN__NAME, false));
		feeder.accept(grammarAccess.getSuiteReturnAccess().getTargetVariableVariableParserRuleCall_4_0(), semanticObject.getTarget());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns Suite
	 *     SuiteStatementWithResult returns Suite
	 *     Suite returns Suite
	 *
	 * Constraint:
	 *     (
	 *         inlined='inlined'? 
	 *         multiplier=ExecutionMultiplier? 
	 *         definition=[SuiteDefinition|QualifiedName] 
	 *         parameters+=SuiteParameter* 
	 *         return+=SuiteReturn* 
	 *         fork=[ForkDefinition|QualifiedName]? 
	 *         variants+=[VariantDefinition|QualifiedName]*
	 *     )
	 * </pre>
	 */
	protected void sequence_Suite(ISerializationContext context, Suite semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TableTestRow returns TableTestRow
	 *
	 * Constraint:
	 *     values+=ParameterTableValue+
	 * </pre>
	 */
	protected void sequence_TableTestRow(ISerializationContext context, TableTestRow semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns TableTest
	 *     SuiteStatementWithResult returns TableTest
	 *     TableTest returns TableTest
	 *
	 * Constraint:
	 *     (
	 *         definition=[TestDefinition|QualifiedName] 
	 *         parameters+=Parameter* 
	 *         parameterHeaders+=ParameterTableHeader* 
	 *         resultHeaders+=ResultTableHeader* 
	 *         defaultResultColumn='='? 
	 *         rows+=TableTestRow+
	 *     )
	 * </pre>
	 */
	protected void sequence_TableTest(ISerializationContext context, TableTest semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns TestDefinition
	 *     TestDefinition returns TestDefinition
	 *
	 * Constraint:
	 *     (documentation=DocumentationComment? name=QualifiedName fixtureMethod=MethodReference)
	 * </pre>
	 */
	protected void sequence_TestDefinition(ISerializationContext context, TestDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns Test
	 *     SuiteStatementWithResult returns Test
	 *     Test returns Test
	 *
	 * Constraint:
	 *     (
	 *         checkpoint='checkpoint'? 
	 *         definition=[TestDefinition|QualifiedName] 
	 *         parameters+=Parameter* 
	 *         results+=NamedResult* 
	 *         result=ValueOrEnumValueOrOperationCollection?
	 *     )
	 * </pre>
	 */
	protected void sequence_Test(ISerializationContext context, Test semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TimeDifference returns TimeDifference
	 *
	 * Constraint:
	 *     ((direction='+' | direction='-') (fixedValues+=TIMESPAN+ | calculatedValue=Variable | calculatedValue=Operation))
	 * </pre>
	 */
	protected void sequence_TimeDifference(ISerializationContext context, TimeDifference semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TimeProgressionFactor returns TimeProgressionFactor
	 *
	 * Constraint:
	 *     (fixedValue=MULTIPLIER | calculatedValue=Variable | calculatedValue=Operation)
	 * </pre>
	 */
	protected void sequence_TimeProgressionFactor(ISerializationContext context, TimeProgressionFactor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns TimeSet
	 *     SuiteStatementWithResult returns TimeSet
	 *     TimeSet returns TimeSet
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             live='live' | 
	 *             ((startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) (progressionMode='progressing' progressionFactor=TimeProgressionFactor?)?)
	 *         ) 
	 *         forks+=[ForkDefinition|QualifiedName]? 
	 *         (masterFork='master'? forks+=[ForkDefinition|QualifiedName]?)*
	 *     )
	 * </pre>
	 */
	protected void sequence_TimeSet(ISerializationContext context, TimeSet semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns TypedNestedObject
	 *     Value returns TypedNestedObject
	 *     TypedNestedObject returns TypedNestedObject
	 *
	 * Constraint:
	 *     (type=JavaClassReference nestedObject=NestedObject)
	 * </pre>
	 */
	protected void sequence_TypedNestedObject(ISerializationContext context, TypedNestedObject semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.TYPED_NESTED_OBJECT__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.TYPED_NESTED_OBJECT__TYPE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.TYPED_NESTED_OBJECT__NESTED_OBJECT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.TYPED_NESTED_OBJECT__NESTED_OBJECT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getTypedNestedObjectAccess().getTypeJavaClassReferenceParserRuleCall_1_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getTypedNestedObjectAccess().getNestedObjectNestedObjectParserRuleCall_4_0(), semanticObject.getNestedObject());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns USDateAnd12HrsTimeValue
	 *     Value returns USDateAnd12HrsTimeValue
	 *     ConstantValue returns USDateAnd12HrsTimeValue
	 *     StaticValue returns USDateAnd12HrsTimeValue
	 *     DateAndTimeValue returns USDateAnd12HrsTimeValue
	 *     USDateAnd12HrsTimeValue returns USDateAnd12HrsTimeValue
	 *
	 * Constraint:
	 *     (dateValue=USDATE timeValue=TWELVEHRSTIME)
	 * </pre>
	 */
	protected void sequence_USDateAnd12HrsTimeValue(ISerializationContext context, USDateAnd12HrsTimeValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__DATE_VALUE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_AND_TIME_VALUE__TIME_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUSDateAnd12HrsTimeValueAccess().getDateValueUSDATETerminalRuleCall_0_0(), semanticObject.getDateValue());
		feeder.accept(grammarAccess.getUSDateAnd12HrsTimeValueAccess().getTimeValueTWELVEHRSTIMETerminalRuleCall_2_0(), semanticObject.getTimeValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns USDateValue
	 *     Value returns USDateValue
	 *     ConstantValue returns USDateValue
	 *     StaticValue returns USDateValue
	 *     DateValue returns USDateValue
	 *     USDateValue returns USDateValue
	 *
	 * Constraint:
	 *     dateValue=USDATE
	 * </pre>
	 */
	protected void sequence_USDateValue(ISerializationContext context, USDateValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.DATE_VALUE__DATE_VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUSDateValueAccess().getDateValueUSDATETerminalRuleCall_0(), semanticObject.getDateValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperationCollection returns ValueOrEnumValueOrOperationCollection
	 *
	 * Constraint:
	 *     (value=ValueOrEnumValueOrOperation moreValues+=ValueOrEnumValueOrOperation*)
	 * </pre>
	 */
	protected void sequence_ValueOrEnumValueOrOperationCollection(ISerializationContext context, ValueOrEnumValueOrOperationCollection semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     SuiteStatement returns VariableAssignment
	 *     VariableAssignment returns VariableAssignment
	 *
	 * Constraint:
	 *     (value=ValueOrEnumValueOrOperationCollection target=VariableVariable)
	 * </pre>
	 */
	protected void sequence_VariableAssignment(ISerializationContext context, VariableAssignment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VARIABLE_ASSIGNMENT__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VARIABLE_ASSIGNMENT__VALUE));
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VARIABLE_ASSIGNMENT__TARGET) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VARIABLE_ASSIGNMENT__TARGET));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVariableAssignmentAccess().getValueValueOrEnumValueOrOperationCollectionParserRuleCall_2_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getVariableAssignmentAccess().getTargetVariableVariableParserRuleCall_6_0(), semanticObject.getTarget());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     PackageStatement returns VariableDefinition
	 *     SuiteStatement returns VariableDefinition
	 *     VariableDefinition returns VariableDefinition
	 *
	 * Constraint:
	 *     (private='private'? name=VariableEntity initialValue=ValueOrEnumValueOrOperationCollection?)
	 * </pre>
	 */
	protected void sequence_VariableDefinition(ISerializationContext context, VariableDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VariableEntity returns VariableEntity
	 *     VariableOrConstantEntity returns VariableEntity
	 *
	 * Constraint:
	 *     name=QualifiedName
	 * </pre>
	 */
	protected void sequence_VariableEntity(ISerializationContext context, VariableEntity semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VARIABLE_OR_CONSTANT_ENTITY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VARIABLE_OR_CONSTANT_ENTITY__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVariableEntityAccess().getNameQualifiedNameParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VariableVariable returns VariableVariable
	 *
	 * Constraint:
	 *     name=[VariableEntity|QualifiedName]
	 * </pre>
	 */
	protected void sequence_VariableVariable(ISerializationContext context, VariableVariable semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VARIABLE_VARIABLE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VARIABLE_VARIABLE__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVariableVariableAccess().getNameVariableEntityQualifiedNameParserRuleCall_0_1(), semanticObject.eGet(DslPackage.Literals.VARIABLE_VARIABLE__NAME, false));
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ValueOrEnumValueOrOperation returns Variable
	 *     Value returns Variable
	 *     Variable returns Variable
	 *
	 * Constraint:
	 *     (name=[VariableOrConstantEntity|QualifiedName] attribute=QualifiedName?)
	 * </pre>
	 */
	protected void sequence_Variable(ISerializationContext context, Variable semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Statement returns VariantDefinition
	 *     PackageStatement returns VariantDefinition
	 *     VariantDefinition returns VariantDefinition
	 *
	 * Constraint:
	 *     (documentation=DocumentationComment? name=QualifiedName description=STRING?)
	 * </pre>
	 */
	protected void sequence_VariantDefinition(ISerializationContext context, VariantDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VariantValue returns VariantValue
	 *
	 * Constraint:
	 *     (names+=[VariantDefinition|QualifiedName]+ value=ValueOrEnumValueOrOperationCollection)
	 * </pre>
	 */
	protected void sequence_VariantValue(ISerializationContext context, VariantValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VisibleDivider returns VisibleDivider
	 *     SuiteStatement returns VisibleDivider
	 *
	 * Constraint:
	 *     content=DIVIDER
	 * </pre>
	 */
	protected void sequence_VisibleDivider(ISerializationContext context, VisibleDivider semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VISIBLE_DIVIDER__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VISIBLE_DIVIDER__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibleDividerAccess().getContentDIVIDERTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VisibleComment returns VisibleMultiLineNormalComment
	 *     VisibleMultiLineComment returns VisibleMultiLineNormalComment
	 *     VisibleMultiLineNormalComment returns VisibleMultiLineNormalComment
	 *     SuiteStatement returns VisibleMultiLineNormalComment
	 *
	 * Constraint:
	 *     content=ML_VISIBLE_COMMENT
	 * </pre>
	 */
	protected void sequence_VisibleMultiLineNormalComment(ISerializationContext context, VisibleMultiLineNormalComment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibleMultiLineNormalCommentAccess().getContentML_VISIBLE_COMMENTTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VisibleComment returns VisibleMultiLineTitleComment
	 *     VisibleMultiLineComment returns VisibleMultiLineTitleComment
	 *     VisibleMultiLineTitleComment returns VisibleMultiLineTitleComment
	 *     SuiteStatement returns VisibleMultiLineTitleComment
	 *
	 * Constraint:
	 *     content=ML_VISIBLE_TITLE_COMMENT
	 * </pre>
	 */
	protected void sequence_VisibleMultiLineTitleComment(ISerializationContext context, VisibleMultiLineTitleComment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibleMultiLineTitleCommentAccess().getContentML_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VisibleComment returns VisibleSingleLineNormalComment
	 *     VisibleSingleLineComment returns VisibleSingleLineNormalComment
	 *     VisibleSingleLineNormalComment returns VisibleSingleLineNormalComment
	 *     SuiteStatement returns VisibleSingleLineNormalComment
	 *
	 * Constraint:
	 *     content=SL_VISIBLE_COMMENT
	 * </pre>
	 */
	protected void sequence_VisibleSingleLineNormalComment(ISerializationContext context, VisibleSingleLineNormalComment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibleSingleLineNormalCommentAccess().getContentSL_VISIBLE_COMMENTTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     VisibleComment returns VisibleSingleLineTitleComment
	 *     VisibleSingleLineComment returns VisibleSingleLineTitleComment
	 *     VisibleSingleLineTitleComment returns VisibleSingleLineTitleComment
	 *     SuiteStatement returns VisibleSingleLineTitleComment
	 *
	 * Constraint:
	 *     content=SL_VISIBLE_TITLE_COMMENT
	 * </pre>
	 */
	protected void sequence_VisibleSingleLineTitleComment(ISerializationContext context, VisibleSingleLineTitleComment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DslPackage.Literals.VISIBLE_COMMENT__CONTENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibleSingleLineTitleCommentAccess().getContentSL_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0(), semanticObject.getContent());
		feeder.finish();
	}
	
	
}
