/*******************************************************************************
 * Copyright (c) 2013 Rene Schneider, GEBIT Solutions GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
/*
 * generated by Xtext
 */
package de.gebit.integrity;

import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.service.DispatchingProvider;

import com.google.inject.Binder;

import de.gebit.integrity.modelsource.DefaultModelSourceExplorer;
import de.gebit.integrity.modelsource.ModelSourceExplorer;
import de.gebit.integrity.operations.standard.DefaultModularStandardOperationProcessor;
import de.gebit.integrity.operations.standard.StandardOperationProcessor;
import de.gebit.integrity.parameter.conversion.ConversionContext;
import de.gebit.integrity.parameter.conversion.DefaultModularValueConverter;
import de.gebit.integrity.parameter.conversion.ValueConverter;
import de.gebit.integrity.parameter.resolving.DefaultParameterResolver;
import de.gebit.integrity.parameter.resolving.ParameterResolver;
import de.gebit.integrity.scoping.DSLResourceDescriptionStrategy;
import de.gebit.integrity.scoping.importer.DSLImportedNamespaceAwareLocalScopeProvider;
import de.gebit.integrity.values.DSLValueConverters;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 * 
 * @author Rene Schneider - initial API and implementation
 */
public class DSLRuntimeModule extends de.gebit.integrity.AbstractDSLRuntimeModule {

	/**
	 * The classloader to use for all class resolving in XText.
	 */
	private ClassLoader classLoader;

	/**
	 * Creates a new instance with the classloader of the current class as default.
	 */
	public DSLRuntimeModule() {
		classLoader = getClass().getClassLoader();
	}

	/**
	 * Creates a new instance using the given classloader.
	 * 
	 * @param aClassLoader
	 */
	public DSLRuntimeModule(ClassLoader aClassLoader) {
		classLoader = aClassLoader;
	}

	/**
	 * Binds Xtext's own converters.
	 */
	public Class<? extends IValueConverterService> bindIValueConverterService() {
		return DSLValueConverters.class;
	}

	@Override
	public ClassLoader bindClassLoaderToInstance() {
		return classLoader;
	}

	/*
	 * public Class<? extends ImportUriResolver> bindImportUriResolver() { return TestDSLImportUriResolver.class; }
	 */

	/**
	 * Bind the value converter.
	 */
	// SUPPRESS CHECKSTYLE Javadoc
	public Class<? extends ValueConverter> bindValueConverter() {
		return DefaultModularValueConverter.class;
	}

	/**
	 * Bind the parameter resolver.
	 */
	// SUPPRESS CHECKSTYLE Javadoc
	public Class<? extends ParameterResolver> bindParameterResolver() {
		return DefaultParameterResolver.class;
	}

	/**
	 * Bind the standard operation processor.
	 * 
	 * @return
	 */
	public Class<? extends StandardOperationProcessor> bindStandardOperationProcessor() {
		return DefaultModularStandardOperationProcessor.class;
	}

	/**
	 * Binds the {@link ModelSourceExplorer}.
	 * 
	 * @return
	 */
	public Class<? extends ModelSourceExplorer> bindModelSourceExplorer() {
		return DefaultModelSourceExplorer.class;
	}

	@Override
	public Class<? extends IScopeProvider> bindIScopeProvider() {
		// TODO Auto-generated method stub
		return super.bindIScopeProvider();
	}

	/**
	 * Bind the custom local scope provider.
	 */
	@Override
	public void configureIScopeProviderDelegate(com.google.inject.Binder aBinder) {
		aBinder.bind(org.eclipse.xtext.scoping.IScopeProvider.class)
				.annotatedWith(com.google.inject.name.Names
						.named(org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.NAMED_DELEGATE))
				.to(DSLImportedNamespaceAwareLocalScopeProvider.class);
	}

	/**
	 * Bind the encoding provider.
	 */
	@Override
	public void configureRuntimeEncodingProvider(Binder aBinder) {
		aBinder.bind(IEncodingProvider.class).annotatedWith(DispatchingProvider.Runtime.class)
				.to(IntegrityRuntimeEncodingProvider.class);
	}

	/**
	 * Binds the {@link ConversionContext}.
	 * 
	 * @return
	 */
	public Class<? extends ConversionContext> bindConversionContext() {
		return ConversionContext.class;
	}

	/**
	 * Binds the {@link IDefaultResourceDescriptionStrategy}.
	 * 
	 * @return
	 */
	public Class<? extends IDefaultResourceDescriptionStrategy> bindIDefaultResourceDescriptionStrategy() {
		return DSLResourceDescriptionStrategy.class;
	}

	/**
	 * Binds the {@link IResourceClusteringPolicy}. This dynamic policy improves memory behavior when dealing with large
	 * script sets.
	 * 
	 * @return
	 */
	@SuppressWarnings("restriction")
	public Class<? extends IResourceClusteringPolicy> bindIResourceClusteringPolicy() {
		return DynamicResourceClusteringPolicy.class;
	}

}
