/*
 * generated by Xtext
 */
package de.gebit.integrity.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;


@Singleton
public class DSLGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class ModelElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Model");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cModelAction_0 = (Action)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cImportsAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cImportsImportParserRuleCall_2_0_0 = (RuleCall)cImportsAssignment_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Assignment cStatementsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cStatementsStatementParserRuleCall_3_0 = (RuleCall)cStatementsAssignment_3.eContents().get(0);
		
		///* This is the Integrity grammar. It's basically just another XText grammar definition, but with one specialty: since
		// * the Integrity language needs to use line breaks as syntactically relevant elements in one specific place (in order to
		// * split lines of tabletest tables), the whole grammar is "newline-aware", although it actually allows optional newlines
		// * at pretty much ANY place where whitespace and newlines are usually allowed (except the mentioned tabletest lines, 
		// * where newlines are not only allowed, but required!). This is done by explicitly stating all the places where newlines
		// * are allowed, but not required (the NL rule), as well as the places where newlines are forced and used as a syntactically
		// * relevant element (NLFORCED rule). 
		// * 
		// * This works rather well in practice, although one sometimes needs to put some additional effort into the integration of new
		// * syntactical elements, especially considering content assist and autoformatting.
		// */ Model:
		//	{Model} NL (imports+=Import NL)* statements+=Statement*;
		@Override public ParserRule getRule() { return rule; }

		//{Model} NL (imports+=Import NL)* statements+=Statement*
		public Group getGroup() { return cGroup; }

		//{Model}
		public Action getModelAction_0() { return cModelAction_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(imports+=Import NL)*
		public Group getGroup_2() { return cGroup_2; }

		//imports+=Import
		public Assignment getImportsAssignment_2_0() { return cImportsAssignment_2_0; }

		//Import
		public RuleCall getImportsImportParserRuleCall_2_0_0() { return cImportsImportParserRuleCall_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1() { return cNLParserRuleCall_2_1; }

		//statements+=Statement*
		public Assignment getStatementsAssignment_3() { return cStatementsAssignment_3; }

		//Statement
		public RuleCall getStatementsStatementParserRuleCall_3_0() { return cStatementsStatementParserRuleCall_3_0; }
	}

	public class StatementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Statement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cPackageDefinitionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cForkDefinitionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cVariantDefinitionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//Statement:
		//	PackageDefinition | ForkDefinition | VariantDefinition;
		@Override public ParserRule getRule() { return rule; }

		//PackageDefinition | ForkDefinition | VariantDefinition
		public Alternatives getAlternatives() { return cAlternatives; }

		//PackageDefinition
		public RuleCall getPackageDefinitionParserRuleCall_0() { return cPackageDefinitionParserRuleCall_0; }

		//ForkDefinition
		public RuleCall getForkDefinitionParserRuleCall_1() { return cForkDefinitionParserRuleCall_1; }

		//VariantDefinition
		public RuleCall getVariantDefinitionParserRuleCall_2() { return cVariantDefinitionParserRuleCall_2; }
	}

	public class VisibleCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleComment");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVisibleSingleLineCommentParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVisibleMultiLineCommentParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VisibleComment:
		//	VisibleSingleLineComment | VisibleMultiLineComment;
		@Override public ParserRule getRule() { return rule; }

		//VisibleSingleLineComment | VisibleMultiLineComment
		public Alternatives getAlternatives() { return cAlternatives; }

		//VisibleSingleLineComment
		public RuleCall getVisibleSingleLineCommentParserRuleCall_0() { return cVisibleSingleLineCommentParserRuleCall_0; }

		//VisibleMultiLineComment
		public RuleCall getVisibleMultiLineCommentParserRuleCall_1() { return cVisibleMultiLineCommentParserRuleCall_1; }
	}

	public class VisibleSingleLineCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleSingleLineComment");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVisibleSingleLineNormalCommentParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVisibleSingleLineTitleCommentParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VisibleSingleLineComment:
		//	VisibleSingleLineNormalComment | VisibleSingleLineTitleComment;
		@Override public ParserRule getRule() { return rule; }

		//VisibleSingleLineNormalComment | VisibleSingleLineTitleComment
		public Alternatives getAlternatives() { return cAlternatives; }

		//VisibleSingleLineNormalComment
		public RuleCall getVisibleSingleLineNormalCommentParserRuleCall_0() { return cVisibleSingleLineNormalCommentParserRuleCall_0; }

		//VisibleSingleLineTitleComment
		public RuleCall getVisibleSingleLineTitleCommentParserRuleCall_1() { return cVisibleSingleLineTitleCommentParserRuleCall_1; }
	}

	public class VisibleSingleLineNormalCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleSingleLineNormalComment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentSL_VISIBLE_COMMENTTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//VisibleSingleLineNormalComment:
		//	content=SL_VISIBLE_COMMENT NL;
		@Override public ParserRule getRule() { return rule; }

		//content=SL_VISIBLE_COMMENT NL
		public Group getGroup() { return cGroup; }

		//content=SL_VISIBLE_COMMENT
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//SL_VISIBLE_COMMENT
		public RuleCall getContentSL_VISIBLE_COMMENTTerminalRuleCall_0_0() { return cContentSL_VISIBLE_COMMENTTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class VisibleSingleLineTitleCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleSingleLineTitleComment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentSL_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//VisibleSingleLineTitleComment:
		//	content=SL_VISIBLE_TITLE_COMMENT NL;
		@Override public ParserRule getRule() { return rule; }

		//content=SL_VISIBLE_TITLE_COMMENT NL
		public Group getGroup() { return cGroup; }

		//content=SL_VISIBLE_TITLE_COMMENT
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//SL_VISIBLE_TITLE_COMMENT
		public RuleCall getContentSL_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0() { return cContentSL_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class VisibleMultiLineCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleMultiLineComment");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVisibleMultiLineNormalCommentParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVisibleMultiLineTitleCommentParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VisibleMultiLineComment:
		//	VisibleMultiLineNormalComment | VisibleMultiLineTitleComment;
		@Override public ParserRule getRule() { return rule; }

		//VisibleMultiLineNormalComment | VisibleMultiLineTitleComment
		public Alternatives getAlternatives() { return cAlternatives; }

		//VisibleMultiLineNormalComment
		public RuleCall getVisibleMultiLineNormalCommentParserRuleCall_0() { return cVisibleMultiLineNormalCommentParserRuleCall_0; }

		//VisibleMultiLineTitleComment
		public RuleCall getVisibleMultiLineTitleCommentParserRuleCall_1() { return cVisibleMultiLineTitleCommentParserRuleCall_1; }
	}

	public class VisibleMultiLineNormalCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleMultiLineNormalComment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentML_VISIBLE_COMMENTTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//VisibleMultiLineNormalComment:
		//	content=ML_VISIBLE_COMMENT NL;
		@Override public ParserRule getRule() { return rule; }

		//content=ML_VISIBLE_COMMENT NL
		public Group getGroup() { return cGroup; }

		//content=ML_VISIBLE_COMMENT
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//ML_VISIBLE_COMMENT
		public RuleCall getContentML_VISIBLE_COMMENTTerminalRuleCall_0_0() { return cContentML_VISIBLE_COMMENTTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class VisibleMultiLineTitleCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleMultiLineTitleComment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentML_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//VisibleMultiLineTitleComment:
		//	content=ML_VISIBLE_TITLE_COMMENT NL;
		@Override public ParserRule getRule() { return rule; }

		//content=ML_VISIBLE_TITLE_COMMENT NL
		public Group getGroup() { return cGroup; }

		//content=ML_VISIBLE_TITLE_COMMENT
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//ML_VISIBLE_TITLE_COMMENT
		public RuleCall getContentML_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0() { return cContentML_VISIBLE_TITLE_COMMENTTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class VisibleDividerElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VisibleDivider");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentDIVIDERTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//VisibleDivider:
		//	content=DIVIDER NL;
		@Override public ParserRule getRule() { return rule; }

		//content=DIVIDER NL
		public Group getGroup() { return cGroup; }

		//content=DIVIDER
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//DIVIDER
		public RuleCall getContentDIVIDERTerminalRuleCall_0_0() { return cContentDIVIDERTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class PackageDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.PackageDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Keyword cPackagedefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameQualifiedNameParserRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Keyword cWithKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Assignment cStatementsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cStatementsPackageStatementParserRuleCall_6_0 = (RuleCall)cStatementsAssignment_6.eContents().get(0);
		private final Keyword cPackageendKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final RuleCall cNLParserRuleCall_8 = (RuleCall)cGroup.eContents().get(8);
		
		//PackageDefinition:
		//	documentation=DocumentationComment? 'packagedef' NL name=QualifiedName 'with' NL statements+=PackageStatement*
		//	'packageend' NL;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? 'packagedef' NL name=QualifiedName 'with' NL statements+=PackageStatement*
		//'packageend' NL
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//'packagedef'
		public Keyword getPackagedefKeyword_1() { return cPackagedefKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//name=QualifiedName
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_3_0() { return cNameQualifiedNameParserRuleCall_3_0; }

		//'with'
		public Keyword getWithKeyword_4() { return cWithKeyword_4; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//statements+=PackageStatement*
		public Assignment getStatementsAssignment_6() { return cStatementsAssignment_6; }

		//PackageStatement
		public RuleCall getStatementsPackageStatementParserRuleCall_6_0() { return cStatementsPackageStatementParserRuleCall_6_0; }

		//'packageend'
		public Keyword getPackageendKeyword_7() { return cPackageendKeyword_7; }

		//NL
		public RuleCall getNLParserRuleCall_8() { return cNLParserRuleCall_8; }
	}

	public class PackageStatementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.PackageStatement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cForkDefinitionParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVariantDefinitionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTestDefinitionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cCallDefinitionParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cOperationDefinitionParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cSuiteDefinitionParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		private final RuleCall cVariableDefinitionParserRuleCall_6 = (RuleCall)cAlternatives.eContents().get(6);
		private final RuleCall cConstantDefinitionParserRuleCall_7 = (RuleCall)cAlternatives.eContents().get(7);
		
		//PackageStatement:
		//	ForkDefinition | VariantDefinition | TestDefinition | CallDefinition | OperationDefinition | SuiteDefinition |
		//	VariableDefinition | ConstantDefinition;
		@Override public ParserRule getRule() { return rule; }

		//ForkDefinition | VariantDefinition | TestDefinition | CallDefinition | OperationDefinition | SuiteDefinition |
		//VariableDefinition | ConstantDefinition
		public Alternatives getAlternatives() { return cAlternatives; }

		//ForkDefinition
		public RuleCall getForkDefinitionParserRuleCall_0() { return cForkDefinitionParserRuleCall_0; }

		//VariantDefinition
		public RuleCall getVariantDefinitionParserRuleCall_1() { return cVariantDefinitionParserRuleCall_1; }

		//TestDefinition
		public RuleCall getTestDefinitionParserRuleCall_2() { return cTestDefinitionParserRuleCall_2; }

		//CallDefinition
		public RuleCall getCallDefinitionParserRuleCall_3() { return cCallDefinitionParserRuleCall_3; }

		//OperationDefinition
		public RuleCall getOperationDefinitionParserRuleCall_4() { return cOperationDefinitionParserRuleCall_4; }

		//SuiteDefinition
		public RuleCall getSuiteDefinitionParserRuleCall_5() { return cSuiteDefinitionParserRuleCall_5; }

		//VariableDefinition
		public RuleCall getVariableDefinitionParserRuleCall_6() { return cVariableDefinitionParserRuleCall_6; }

		//ConstantDefinition
		public RuleCall getConstantDefinitionParserRuleCall_7() { return cConstantDefinitionParserRuleCall_7; }
	}

	public class ImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Import");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cImportedNamespaceAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_0 = (RuleCall)cImportedNamespaceAssignment_2.eContents().get(0);
		
		//Import:
		//	'import' NL importedNamespace=QualifiedNameWithWildcard;
		@Override public ParserRule getRule() { return rule; }

		//'import' NL importedNamespace=QualifiedNameWithWildcard
		public Group getGroup() { return cGroup; }

		//'import'
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//importedNamespace=QualifiedNameWithWildcard
		public Assignment getImportedNamespaceAssignment_2() { return cImportedNamespaceAssignment_2; }

		//QualifiedNameWithWildcard
		public RuleCall getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_0() { return cImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_0; }
	}

	public class ForkDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ForkDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Assignment cPrivateAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Keyword cPrivatePrivateKeyword_1_0 = (Keyword)cPrivateAssignment_1.eContents().get(0);
		private final Keyword cForkdefKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cNameQualifiedNameParserRuleCall_4_0 = (RuleCall)cNameAssignment_4.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Assignment cDescriptionAssignment_6_0 = (Assignment)cGroup_6.eContents().get(0);
		private final RuleCall cDescriptionSTRINGTerminalRuleCall_6_0_0 = (RuleCall)cDescriptionAssignment_6_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_6_1 = (RuleCall)cGroup_6.eContents().get(1);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Alternatives cAlternatives_7_0 = (Alternatives)cGroup_7.eContents().get(0);
		private final Group cGroup_7_0_0 = (Group)cAlternatives_7_0.eContents().get(0);
		private final Keyword cUsesKeyword_7_0_0_0 = (Keyword)cGroup_7_0_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7_0_0_1 = (RuleCall)cGroup_7_0_0.eContents().get(1);
		private final Assignment cForkerClassAssignment_7_0_0_2 = (Assignment)cGroup_7_0_0.eContents().get(2);
		private final RuleCall cForkerClassJavaClassReferenceParserRuleCall_7_0_0_2_0 = (RuleCall)cForkerClassAssignment_7_0_0_2.eContents().get(0);
		private final Group cGroup_7_0_1 = (Group)cAlternatives_7_0.eContents().get(1);
		private final Keyword cBasedOnKeyword_7_0_1_0 = (Keyword)cGroup_7_0_1.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7_0_1_1 = (RuleCall)cGroup_7_0_1.eContents().get(1);
		private final Assignment cBaseForkAssignment_7_0_1_2 = (Assignment)cGroup_7_0_1.eContents().get(2);
		private final CrossReference cBaseForkForkDefinitionCrossReference_7_0_1_2_0 = (CrossReference)cBaseForkAssignment_7_0_1_2.eContents().get(0);
		private final RuleCall cBaseForkForkDefinitionQualifiedNameParserRuleCall_7_0_1_2_0_1 = (RuleCall)cBaseForkForkDefinitionCrossReference_7_0_1_2_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_7_1 = (RuleCall)cGroup_7.eContents().get(1);
		private final Group cGroup_8 = (Group)cGroup.eContents().get(8);
		private final Assignment cParametersAssignment_8_0 = (Assignment)cGroup_8.eContents().get(0);
		private final RuleCall cParametersForkParameterParserRuleCall_8_0_0 = (RuleCall)cParametersAssignment_8_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_8_1 = (RuleCall)cGroup_8.eContents().get(1);
		
		//ForkDefinition:
		//	documentation=DocumentationComment? private='private'? 'forkdef' NL name=QualifiedName NL (description=STRING NL)?
		//	(('uses' NL forkerClass=JavaClassReference | 'based on' NL baseFork=[ForkDefinition|QualifiedName]) NL)?
		//	(parameters+=ForkParameter NL)*;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? private='private'? 'forkdef' NL name=QualifiedName NL (description=STRING NL)?
		//(('uses' NL forkerClass=JavaClassReference | 'based on' NL baseFork=[ForkDefinition|QualifiedName]) NL)?
		//(parameters+=ForkParameter NL)*
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//private='private'?
		public Assignment getPrivateAssignment_1() { return cPrivateAssignment_1; }

		//'private'
		public Keyword getPrivatePrivateKeyword_1_0() { return cPrivatePrivateKeyword_1_0; }

		//'forkdef'
		public Keyword getForkdefKeyword_2() { return cForkdefKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//name=QualifiedName
		public Assignment getNameAssignment_4() { return cNameAssignment_4; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_4_0() { return cNameQualifiedNameParserRuleCall_4_0; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//(description=STRING NL)?
		public Group getGroup_6() { return cGroup_6; }

		//description=STRING
		public Assignment getDescriptionAssignment_6_0() { return cDescriptionAssignment_6_0; }

		//STRING
		public RuleCall getDescriptionSTRINGTerminalRuleCall_6_0_0() { return cDescriptionSTRINGTerminalRuleCall_6_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_6_1() { return cNLParserRuleCall_6_1; }

		//(('uses' NL forkerClass=JavaClassReference | 'based on' NL baseFork=[ForkDefinition|QualifiedName]) NL)?
		public Group getGroup_7() { return cGroup_7; }

		//('uses' NL forkerClass=JavaClassReference | 'based on' NL baseFork=[ForkDefinition|QualifiedName])
		public Alternatives getAlternatives_7_0() { return cAlternatives_7_0; }

		//'uses' NL forkerClass=JavaClassReference
		public Group getGroup_7_0_0() { return cGroup_7_0_0; }

		//'uses'
		public Keyword getUsesKeyword_7_0_0_0() { return cUsesKeyword_7_0_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_7_0_0_1() { return cNLParserRuleCall_7_0_0_1; }

		//forkerClass=JavaClassReference
		public Assignment getForkerClassAssignment_7_0_0_2() { return cForkerClassAssignment_7_0_0_2; }

		//JavaClassReference
		public RuleCall getForkerClassJavaClassReferenceParserRuleCall_7_0_0_2_0() { return cForkerClassJavaClassReferenceParserRuleCall_7_0_0_2_0; }

		//'based on' NL baseFork=[ForkDefinition|QualifiedName]
		public Group getGroup_7_0_1() { return cGroup_7_0_1; }

		//'based on'
		public Keyword getBasedOnKeyword_7_0_1_0() { return cBasedOnKeyword_7_0_1_0; }

		//NL
		public RuleCall getNLParserRuleCall_7_0_1_1() { return cNLParserRuleCall_7_0_1_1; }

		//baseFork=[ForkDefinition|QualifiedName]
		public Assignment getBaseForkAssignment_7_0_1_2() { return cBaseForkAssignment_7_0_1_2; }

		//[ForkDefinition|QualifiedName]
		public CrossReference getBaseForkForkDefinitionCrossReference_7_0_1_2_0() { return cBaseForkForkDefinitionCrossReference_7_0_1_2_0; }

		//QualifiedName
		public RuleCall getBaseForkForkDefinitionQualifiedNameParserRuleCall_7_0_1_2_0_1() { return cBaseForkForkDefinitionQualifiedNameParserRuleCall_7_0_1_2_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_7_1() { return cNLParserRuleCall_7_1; }

		//(parameters+=ForkParameter NL)*
		public Group getGroup_8() { return cGroup_8; }

		//parameters+=ForkParameter
		public Assignment getParametersAssignment_8_0() { return cParametersAssignment_8_0; }

		//ForkParameter
		public RuleCall getParametersForkParameterParserRuleCall_8_0_0() { return cParametersForkParameterParserRuleCall_8_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_8_1() { return cNLParserRuleCall_8_1; }
	}

	public class ForkParameterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ForkParameter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameFixedParameterNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueValueOrEnumValueOrOperationParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//ForkParameter:
		//	name=FixedParameterName NL ':' NL value=ValueOrEnumValueOrOperation;
		@Override public ParserRule getRule() { return rule; }

		//name=FixedParameterName NL ':' NL value=ValueOrEnumValueOrOperation
		public Group getGroup() { return cGroup; }

		//name=FixedParameterName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//FixedParameterName
		public RuleCall getNameFixedParameterNameParserRuleCall_0_0() { return cNameFixedParameterNameParserRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//value=ValueOrEnumValueOrOperation
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ValueOrEnumValueOrOperation
		public RuleCall getValueValueOrEnumValueOrOperationParserRuleCall_4_0() { return cValueValueOrEnumValueOrOperationParserRuleCall_4_0; }
	}

	public class VariantDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariantDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Keyword cVariantdefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameQualifiedNameParserRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Assignment cDescriptionAssignment_5_0 = (Assignment)cGroup_5.eContents().get(0);
		private final RuleCall cDescriptionSTRINGTerminalRuleCall_5_0_0 = (RuleCall)cDescriptionAssignment_5_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5_1 = (RuleCall)cGroup_5.eContents().get(1);
		
		//VariantDefinition:
		//	documentation=DocumentationComment? 'variantdef' NL name=QualifiedName NL (description=STRING NL)?;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? 'variantdef' NL name=QualifiedName NL (description=STRING NL)?
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//'variantdef'
		public Keyword getVariantdefKeyword_1() { return cVariantdefKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//name=QualifiedName
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_3_0() { return cNameQualifiedNameParserRuleCall_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_4() { return cNLParserRuleCall_4; }

		//(description=STRING NL)?
		public Group getGroup_5() { return cGroup_5; }

		//description=STRING
		public Assignment getDescriptionAssignment_5_0() { return cDescriptionAssignment_5_0; }

		//STRING
		public RuleCall getDescriptionSTRINGTerminalRuleCall_5_0_0() { return cDescriptionSTRINGTerminalRuleCall_5_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_5_1() { return cNLParserRuleCall_5_1; }
	}

	public class TestDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TestDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Keyword cTestdefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameQualifiedNameParserRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Keyword cUsesKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final RuleCall cNLParserRuleCall_6 = (RuleCall)cGroup.eContents().get(6);
		private final Assignment cFixtureMethodAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cFixtureMethodMethodReferenceParserRuleCall_7_0 = (RuleCall)cFixtureMethodAssignment_7.eContents().get(0);
		private final RuleCall cNLParserRuleCall_8 = (RuleCall)cGroup.eContents().get(8);
		
		//TestDefinition:
		//	documentation=DocumentationComment? 'testdef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? 'testdef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//'testdef'
		public Keyword getTestdefKeyword_1() { return cTestdefKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//name=QualifiedName
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_3_0() { return cNameQualifiedNameParserRuleCall_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_4() { return cNLParserRuleCall_4; }

		//'uses'
		public Keyword getUsesKeyword_5() { return cUsesKeyword_5; }

		//NL
		public RuleCall getNLParserRuleCall_6() { return cNLParserRuleCall_6; }

		//fixtureMethod=MethodReference
		public Assignment getFixtureMethodAssignment_7() { return cFixtureMethodAssignment_7; }

		//MethodReference
		public RuleCall getFixtureMethodMethodReferenceParserRuleCall_7_0() { return cFixtureMethodMethodReferenceParserRuleCall_7_0; }

		//NL
		public RuleCall getNLParserRuleCall_8() { return cNLParserRuleCall_8; }
	}

	public class CallDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.CallDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Keyword cCalldefKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameQualifiedNameParserRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Keyword cUsesKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final RuleCall cNLParserRuleCall_6 = (RuleCall)cGroup.eContents().get(6);
		private final Assignment cFixtureMethodAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cFixtureMethodMethodReferenceParserRuleCall_7_0 = (RuleCall)cFixtureMethodAssignment_7.eContents().get(0);
		private final RuleCall cNLParserRuleCall_8 = (RuleCall)cGroup.eContents().get(8);
		
		//CallDefinition:
		//	documentation=DocumentationComment? 'calldef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? 'calldef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//'calldef'
		public Keyword getCalldefKeyword_1() { return cCalldefKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//name=QualifiedName
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_3_0() { return cNameQualifiedNameParserRuleCall_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_4() { return cNLParserRuleCall_4; }

		//'uses'
		public Keyword getUsesKeyword_5() { return cUsesKeyword_5; }

		//NL
		public RuleCall getNLParserRuleCall_6() { return cNLParserRuleCall_6; }

		//fixtureMethod=MethodReference
		public Assignment getFixtureMethodAssignment_7() { return cFixtureMethodAssignment_7; }

		//MethodReference
		public RuleCall getFixtureMethodMethodReferenceParserRuleCall_7_0() { return cFixtureMethodMethodReferenceParserRuleCall_7_0; }

		//NL
		public RuleCall getNLParserRuleCall_8() { return cNLParserRuleCall_8; }
	}

	public class SuiteDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Assignment cPrivateAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Keyword cPrivatePrivateKeyword_1_0 = (Keyword)cPrivateAssignment_1.eContents().get(0);
		private final Assignment cSingleRunAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final Keyword cSingleRunSingleRunKeyword_2_0 = (Keyword)cSingleRunAssignment_2.eContents().get(0);
		private final Assignment cInlinedAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final Keyword cInlinedInlinedKeyword_3_0 = (Keyword)cInlinedAssignment_3.eContents().get(0);
		private final Keyword cSuitedefKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Assignment cNameAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cNameQualifiedNameParserRuleCall_6_0 = (RuleCall)cNameAssignment_6.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7 = (RuleCall)cGroup.eContents().get(7);
		private final Group cGroup_8 = (Group)cGroup.eContents().get(8);
		private final Keyword cGetsKeyword_8_0 = (Keyword)cGroup_8.eContents().get(0);
		private final Group cGroup_8_1 = (Group)cGroup_8.eContents().get(1);
		private final Assignment cParametersAssignment_8_1_0 = (Assignment)cGroup_8_1.eContents().get(0);
		private final RuleCall cParametersSuiteParameterDefinitionParserRuleCall_8_1_0_0 = (RuleCall)cParametersAssignment_8_1_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_8_1_1 = (RuleCall)cGroup_8_1.eContents().get(1);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final Keyword cReturnsKeyword_9_0 = (Keyword)cGroup_9.eContents().get(0);
		private final Group cGroup_9_1 = (Group)cGroup_9.eContents().get(1);
		private final Assignment cReturnAssignment_9_1_0 = (Assignment)cGroup_9_1.eContents().get(0);
		private final RuleCall cReturnSuiteReturnDefinitionParserRuleCall_9_1_0_0 = (RuleCall)cReturnAssignment_9_1_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_9_1_1 = (RuleCall)cGroup_9_1.eContents().get(1);
		private final Group cGroup_10 = (Group)cGroup.eContents().get(10);
		private final Keyword cRequiresKeyword_10_0 = (Keyword)cGroup_10.eContents().get(0);
		private final RuleCall cNLParserRuleCall_10_1 = (RuleCall)cGroup_10.eContents().get(1);
		private final Group cGroup_10_2 = (Group)cGroup_10.eContents().get(2);
		private final Assignment cDependenciesAssignment_10_2_0 = (Assignment)cGroup_10_2.eContents().get(0);
		private final CrossReference cDependenciesSuiteDefinitionCrossReference_10_2_0_0 = (CrossReference)cDependenciesAssignment_10_2_0.eContents().get(0);
		private final RuleCall cDependenciesSuiteDefinitionQualifiedNameParserRuleCall_10_2_0_0_1 = (RuleCall)cDependenciesSuiteDefinitionCrossReference_10_2_0_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_10_2_1 = (RuleCall)cGroup_10_2.eContents().get(1);
		private final Group cGroup_11 = (Group)cGroup.eContents().get(11);
		private final Keyword cConcludedbyKeyword_11_0 = (Keyword)cGroup_11.eContents().get(0);
		private final RuleCall cNLParserRuleCall_11_1 = (RuleCall)cGroup_11.eContents().get(1);
		private final Group cGroup_11_2 = (Group)cGroup_11.eContents().get(2);
		private final Assignment cFinalizersAssignment_11_2_0 = (Assignment)cGroup_11_2.eContents().get(0);
		private final CrossReference cFinalizersSuiteDefinitionCrossReference_11_2_0_0 = (CrossReference)cFinalizersAssignment_11_2_0.eContents().get(0);
		private final RuleCall cFinalizersSuiteDefinitionQualifiedNameParserRuleCall_11_2_0_0_1 = (RuleCall)cFinalizersSuiteDefinitionCrossReference_11_2_0_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_11_2_1 = (RuleCall)cGroup_11_2.eContents().get(1);
		private final Keyword cWithKeyword_12 = (Keyword)cGroup.eContents().get(12);
		private final RuleCall cNLParserRuleCall_13 = (RuleCall)cGroup.eContents().get(13);
		private final Assignment cStatementsAssignment_14 = (Assignment)cGroup.eContents().get(14);
		private final RuleCall cStatementsSuiteStatementParserRuleCall_14_0 = (RuleCall)cStatementsAssignment_14.eContents().get(0);
		private final Keyword cSuiteendKeyword_15 = (Keyword)cGroup.eContents().get(15);
		private final RuleCall cNLParserRuleCall_16 = (RuleCall)cGroup.eContents().get(16);
		
		//SuiteDefinition:
		//	documentation=DocumentationComment? private='private'? singleRun='single-run'? inlined='inlined'? 'suitedef' NL
		//	name=QualifiedName NL ('gets' (parameters+=SuiteParameterDefinition NL)+)? ('returns' (return+=SuiteReturnDefinition
		//	NL)+)? ('requires' NL (dependencies+=[SuiteDefinition|QualifiedName] NL)*)? ('concludedby' NL
		//	(finalizers+=[SuiteDefinition|QualifiedName] NL)*)? 'with' NL statements+=SuiteStatement* 'suiteend' NL;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? private='private'? singleRun='single-run'? inlined='inlined'? 'suitedef' NL
		//name=QualifiedName NL ('gets' (parameters+=SuiteParameterDefinition NL)+)? ('returns' (return+=SuiteReturnDefinition
		//NL)+)? ('requires' NL (dependencies+=[SuiteDefinition|QualifiedName] NL)*)? ('concludedby' NL
		//(finalizers+=[SuiteDefinition|QualifiedName] NL)*)? 'with' NL statements+=SuiteStatement* 'suiteend' NL
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//private='private'?
		public Assignment getPrivateAssignment_1() { return cPrivateAssignment_1; }

		//'private'
		public Keyword getPrivatePrivateKeyword_1_0() { return cPrivatePrivateKeyword_1_0; }

		//singleRun='single-run'?
		public Assignment getSingleRunAssignment_2() { return cSingleRunAssignment_2; }

		//'single-run'
		public Keyword getSingleRunSingleRunKeyword_2_0() { return cSingleRunSingleRunKeyword_2_0; }

		//inlined='inlined'?
		public Assignment getInlinedAssignment_3() { return cInlinedAssignment_3; }

		//'inlined'
		public Keyword getInlinedInlinedKeyword_3_0() { return cInlinedInlinedKeyword_3_0; }

		//'suitedef'
		public Keyword getSuitedefKeyword_4() { return cSuitedefKeyword_4; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//name=QualifiedName
		public Assignment getNameAssignment_6() { return cNameAssignment_6; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_6_0() { return cNameQualifiedNameParserRuleCall_6_0; }

		//NL
		public RuleCall getNLParserRuleCall_7() { return cNLParserRuleCall_7; }

		//('gets' (parameters+=SuiteParameterDefinition NL)+)?
		public Group getGroup_8() { return cGroup_8; }

		//'gets'
		public Keyword getGetsKeyword_8_0() { return cGetsKeyword_8_0; }

		//(parameters+=SuiteParameterDefinition NL)+
		public Group getGroup_8_1() { return cGroup_8_1; }

		//parameters+=SuiteParameterDefinition
		public Assignment getParametersAssignment_8_1_0() { return cParametersAssignment_8_1_0; }

		//SuiteParameterDefinition
		public RuleCall getParametersSuiteParameterDefinitionParserRuleCall_8_1_0_0() { return cParametersSuiteParameterDefinitionParserRuleCall_8_1_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_8_1_1() { return cNLParserRuleCall_8_1_1; }

		//('returns' (return+=SuiteReturnDefinition NL)+)?
		public Group getGroup_9() { return cGroup_9; }

		//'returns'
		public Keyword getReturnsKeyword_9_0() { return cReturnsKeyword_9_0; }

		//(return+=SuiteReturnDefinition NL)+
		public Group getGroup_9_1() { return cGroup_9_1; }

		//return+=SuiteReturnDefinition
		public Assignment getReturnAssignment_9_1_0() { return cReturnAssignment_9_1_0; }

		//SuiteReturnDefinition
		public RuleCall getReturnSuiteReturnDefinitionParserRuleCall_9_1_0_0() { return cReturnSuiteReturnDefinitionParserRuleCall_9_1_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_9_1_1() { return cNLParserRuleCall_9_1_1; }

		//('requires' NL (dependencies+=[SuiteDefinition|QualifiedName] NL)*)?
		public Group getGroup_10() { return cGroup_10; }

		//'requires'
		public Keyword getRequiresKeyword_10_0() { return cRequiresKeyword_10_0; }

		//NL
		public RuleCall getNLParserRuleCall_10_1() { return cNLParserRuleCall_10_1; }

		//(dependencies+=[SuiteDefinition|QualifiedName] NL)*
		public Group getGroup_10_2() { return cGroup_10_2; }

		//dependencies+=[SuiteDefinition|QualifiedName]
		public Assignment getDependenciesAssignment_10_2_0() { return cDependenciesAssignment_10_2_0; }

		//[SuiteDefinition|QualifiedName]
		public CrossReference getDependenciesSuiteDefinitionCrossReference_10_2_0_0() { return cDependenciesSuiteDefinitionCrossReference_10_2_0_0; }

		//QualifiedName
		public RuleCall getDependenciesSuiteDefinitionQualifiedNameParserRuleCall_10_2_0_0_1() { return cDependenciesSuiteDefinitionQualifiedNameParserRuleCall_10_2_0_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_10_2_1() { return cNLParserRuleCall_10_2_1; }

		//('concludedby' NL (finalizers+=[SuiteDefinition|QualifiedName] NL)*)?
		public Group getGroup_11() { return cGroup_11; }

		//'concludedby'
		public Keyword getConcludedbyKeyword_11_0() { return cConcludedbyKeyword_11_0; }

		//NL
		public RuleCall getNLParserRuleCall_11_1() { return cNLParserRuleCall_11_1; }

		//(finalizers+=[SuiteDefinition|QualifiedName] NL)*
		public Group getGroup_11_2() { return cGroup_11_2; }

		//finalizers+=[SuiteDefinition|QualifiedName]
		public Assignment getFinalizersAssignment_11_2_0() { return cFinalizersAssignment_11_2_0; }

		//[SuiteDefinition|QualifiedName]
		public CrossReference getFinalizersSuiteDefinitionCrossReference_11_2_0_0() { return cFinalizersSuiteDefinitionCrossReference_11_2_0_0; }

		//QualifiedName
		public RuleCall getFinalizersSuiteDefinitionQualifiedNameParserRuleCall_11_2_0_0_1() { return cFinalizersSuiteDefinitionQualifiedNameParserRuleCall_11_2_0_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_11_2_1() { return cNLParserRuleCall_11_2_1; }

		//'with'
		public Keyword getWithKeyword_12() { return cWithKeyword_12; }

		//NL
		public RuleCall getNLParserRuleCall_13() { return cNLParserRuleCall_13; }

		//statements+=SuiteStatement*
		public Assignment getStatementsAssignment_14() { return cStatementsAssignment_14; }

		//SuiteStatement
		public RuleCall getStatementsSuiteStatementParserRuleCall_14_0() { return cStatementsSuiteStatementParserRuleCall_14_0; }

		//'suiteend'
		public Keyword getSuiteendKeyword_15() { return cSuiteendKeyword_15; }

		//NL
		public RuleCall getNLParserRuleCall_16() { return cNLParserRuleCall_16; }
	}

	public class SuiteParameterDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteParameterDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameVariableEntityParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1_0 = (RuleCall)cGroup_1.eContents().get(0);
		private final Keyword cByDefaultKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Assignment cDefaultAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cDefaultValueOrEnumValueOrOperationCollectionParserRuleCall_1_2_0 = (RuleCall)cDefaultAssignment_1_2.eContents().get(0);
		
		//SuiteParameterDefinition:
		//	name=VariableEntity (NL 'by default' default=ValueOrEnumValueOrOperationCollection)?;
		@Override public ParserRule getRule() { return rule; }

		//name=VariableEntity (NL 'by default' default=ValueOrEnumValueOrOperationCollection)?
		public Group getGroup() { return cGroup; }

		//name=VariableEntity
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//VariableEntity
		public RuleCall getNameVariableEntityParserRuleCall_0_0() { return cNameVariableEntityParserRuleCall_0_0; }

		//(NL 'by default' default=ValueOrEnumValueOrOperationCollection)?
		public Group getGroup_1() { return cGroup_1; }

		//NL
		public RuleCall getNLParserRuleCall_1_0() { return cNLParserRuleCall_1_0; }

		//'by default'
		public Keyword getByDefaultKeyword_1_1() { return cByDefaultKeyword_1_1; }

		//default=ValueOrEnumValueOrOperationCollection
		public Assignment getDefaultAssignment_1_2() { return cDefaultAssignment_1_2; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getDefaultValueOrEnumValueOrOperationCollectionParserRuleCall_1_2_0() { return cDefaultValueOrEnumValueOrOperationCollectionParserRuleCall_1_2_0; }
	}

	public class SuiteReturnDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteReturnDefinition");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameVariableEntityParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//SuiteReturnDefinition:
		//	name=VariableEntity;
		@Override public ParserRule getRule() { return rule; }

		//name=VariableEntity
		public Assignment getNameAssignment() { return cNameAssignment; }

		//VariableEntity
		public RuleCall getNameVariableEntityParserRuleCall_0() { return cNameVariableEntityParserRuleCall_0; }
	}

	public class OperationDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.OperationDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cOperationdefKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameQualifiedNameParserRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Keyword cUsesKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Assignment cOperationTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOperationTypeJavaClassReferenceParserRuleCall_6_0 = (RuleCall)cOperationTypeAssignment_6.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7 = (RuleCall)cGroup.eContents().get(7);
		
		//OperationDefinition:
		//	'operationdef' NL name=QualifiedName NL 'uses' NL operationType=JavaClassReference NL;
		@Override public ParserRule getRule() { return rule; }

		//'operationdef' NL name=QualifiedName NL 'uses' NL operationType=JavaClassReference NL
		public Group getGroup() { return cGroup; }

		//'operationdef'
		public Keyword getOperationdefKeyword_0() { return cOperationdefKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//name=QualifiedName
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_2_0() { return cNameQualifiedNameParserRuleCall_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//'uses'
		public Keyword getUsesKeyword_4() { return cUsesKeyword_4; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//operationType=JavaClassReference
		public Assignment getOperationTypeAssignment_6() { return cOperationTypeAssignment_6; }

		//JavaClassReference
		public RuleCall getOperationTypeJavaClassReferenceParserRuleCall_6_0() { return cOperationTypeJavaClassReferenceParserRuleCall_6_0; }

		//NL
		public RuleCall getNLParserRuleCall_7() { return cNLParserRuleCall_7; }
	}

	public class SuiteStatementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteStatement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSuiteStatementWithResultParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVariableDefinitionParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cConstantDefinitionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cVariableAssignmentParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cVisibleCommentParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cVisibleDividerParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//SuiteStatement:
		//	SuiteStatementWithResult | VariableDefinition | ConstantDefinition | VariableAssignment | VisibleComment |
		//	VisibleDivider;
		@Override public ParserRule getRule() { return rule; }

		//SuiteStatementWithResult | VariableDefinition | ConstantDefinition | VariableAssignment | VisibleComment |
		//VisibleDivider
		public Alternatives getAlternatives() { return cAlternatives; }

		//SuiteStatementWithResult
		public RuleCall getSuiteStatementWithResultParserRuleCall_0() { return cSuiteStatementWithResultParserRuleCall_0; }

		//VariableDefinition
		public RuleCall getVariableDefinitionParserRuleCall_1() { return cVariableDefinitionParserRuleCall_1; }

		//ConstantDefinition
		public RuleCall getConstantDefinitionParserRuleCall_2() { return cConstantDefinitionParserRuleCall_2; }

		//VariableAssignment
		public RuleCall getVariableAssignmentParserRuleCall_3() { return cVariableAssignmentParserRuleCall_3; }

		//VisibleComment
		public RuleCall getVisibleCommentParserRuleCall_4() { return cVisibleCommentParserRuleCall_4; }

		//VisibleDivider
		public RuleCall getVisibleDividerParserRuleCall_5() { return cVisibleDividerParserRuleCall_5; }
	}

	public class SuiteStatementWithResultElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteStatementWithResult");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSuiteParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cTestParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTableTestParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cCallParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cTimeSetParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		
		//SuiteStatementWithResult:
		//	Suite | Test | TableTest | Call | TimeSet;
		@Override public ParserRule getRule() { return rule; }

		//Suite | Test | TableTest | Call | TimeSet
		public Alternatives getAlternatives() { return cAlternatives; }

		//Suite
		public RuleCall getSuiteParserRuleCall_0() { return cSuiteParserRuleCall_0; }

		//Test
		public RuleCall getTestParserRuleCall_1() { return cTestParserRuleCall_1; }

		//TableTest
		public RuleCall getTableTestParserRuleCall_2() { return cTableTestParserRuleCall_2; }

		//Call
		public RuleCall getCallParserRuleCall_3() { return cCallParserRuleCall_3; }

		//TimeSet
		public RuleCall getTimeSetParserRuleCall_4() { return cTimeSetParserRuleCall_4; }
	}

	public class VariableDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariableDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPrivateAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cPrivatePrivateKeyword_0_0 = (Keyword)cPrivateAssignment_0.eContents().get(0);
		private final Keyword cVariableKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameVariableEntityParserRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cInitiallyKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5_1 = (RuleCall)cGroup_5.eContents().get(1);
		private final Assignment cInitialValueAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cInitialValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_2_0 = (RuleCall)cInitialValueAssignment_5_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5_3 = (RuleCall)cGroup_5.eContents().get(3);
		
		//VariableDefinition:
		//	private='private'? 'variable' NL name=VariableEntity NL ('initially' NL
		//	initialValue=ValueOrEnumValueOrOperationCollection NL)?;
		@Override public ParserRule getRule() { return rule; }

		//private='private'? 'variable' NL name=VariableEntity NL ('initially' NL
		//initialValue=ValueOrEnumValueOrOperationCollection NL)?
		public Group getGroup() { return cGroup; }

		//private='private'?
		public Assignment getPrivateAssignment_0() { return cPrivateAssignment_0; }

		//'private'
		public Keyword getPrivatePrivateKeyword_0_0() { return cPrivatePrivateKeyword_0_0; }

		//'variable'
		public Keyword getVariableKeyword_1() { return cVariableKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//name=VariableEntity
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }

		//VariableEntity
		public RuleCall getNameVariableEntityParserRuleCall_3_0() { return cNameVariableEntityParserRuleCall_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_4() { return cNLParserRuleCall_4; }

		//('initially' NL initialValue=ValueOrEnumValueOrOperationCollection NL)?
		public Group getGroup_5() { return cGroup_5; }

		//'initially'
		public Keyword getInitiallyKeyword_5_0() { return cInitiallyKeyword_5_0; }

		//NL
		public RuleCall getNLParserRuleCall_5_1() { return cNLParserRuleCall_5_1; }

		//initialValue=ValueOrEnumValueOrOperationCollection
		public Assignment getInitialValueAssignment_5_2() { return cInitialValueAssignment_5_2; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getInitialValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_2_0() { return cInitialValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_5_3() { return cNLParserRuleCall_5_3; }
	}

	public class ConstantDefinitionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ConstantDefinition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDocumentationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDocumentationDocumentationCommentParserRuleCall_0_0 = (RuleCall)cDocumentationAssignment_0.eContents().get(0);
		private final Assignment cPrivateAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Keyword cPrivatePrivateKeyword_1_0 = (Keyword)cPrivateAssignment_1.eContents().get(0);
		private final Keyword cConstantKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cNameAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cNameConstantEntityParserRuleCall_4_0 = (RuleCall)cNameAssignment_4.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Group cGroup_6_0 = (Group)cGroup_6.eContents().get(0);
		private final Assignment cValueAssignment_6_0_0 = (Assignment)cGroup_6_0.eContents().get(0);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_6_0_0_0 = (RuleCall)cValueAssignment_6_0_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_6_0_1 = (RuleCall)cGroup_6_0.eContents().get(1);
		private final Group cGroup_6_1 = (Group)cGroup_6.eContents().get(1);
		private final Assignment cVariantValuesAssignment_6_1_0 = (Assignment)cGroup_6_1.eContents().get(0);
		private final RuleCall cVariantValuesVariantValueParserRuleCall_6_1_0_0 = (RuleCall)cVariantValuesAssignment_6_1_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_6_1_1 = (RuleCall)cGroup_6_1.eContents().get(1);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Assignment cParameterizedAssignment_7_0 = (Assignment)cGroup_7.eContents().get(0);
		private final Keyword cParameterizedParameterizedKeyword_7_0_0 = (Keyword)cParameterizedAssignment_7_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7_1 = (RuleCall)cGroup_7.eContents().get(1);
		
		//ConstantDefinition:
		//	documentation=DocumentationComment? private='private'? 'constant' NL name=ConstantEntity NL
		//	((value=ValueOrEnumValueOrOperationCollection NL)? (variantValues+=VariantValue NL)*) (parameterized='parameterized'
		//	NL)?;
		@Override public ParserRule getRule() { return rule; }

		//documentation=DocumentationComment? private='private'? 'constant' NL name=ConstantEntity NL
		//((value=ValueOrEnumValueOrOperationCollection NL)? (variantValues+=VariantValue NL)*) (parameterized='parameterized'
		//NL)?
		public Group getGroup() { return cGroup; }

		//documentation=DocumentationComment?
		public Assignment getDocumentationAssignment_0() { return cDocumentationAssignment_0; }

		//DocumentationComment
		public RuleCall getDocumentationDocumentationCommentParserRuleCall_0_0() { return cDocumentationDocumentationCommentParserRuleCall_0_0; }

		//private='private'?
		public Assignment getPrivateAssignment_1() { return cPrivateAssignment_1; }

		//'private'
		public Keyword getPrivatePrivateKeyword_1_0() { return cPrivatePrivateKeyword_1_0; }

		//'constant'
		public Keyword getConstantKeyword_2() { return cConstantKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//name=ConstantEntity
		public Assignment getNameAssignment_4() { return cNameAssignment_4; }

		//ConstantEntity
		public RuleCall getNameConstantEntityParserRuleCall_4_0() { return cNameConstantEntityParserRuleCall_4_0; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//((value=ValueOrEnumValueOrOperationCollection NL)? (variantValues+=VariantValue NL)*)
		public Group getGroup_6() { return cGroup_6; }

		//(value=ValueOrEnumValueOrOperationCollection NL)?
		public Group getGroup_6_0() { return cGroup_6_0; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_6_0_0() { return cValueAssignment_6_0_0; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_6_0_0_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_6_0_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_6_0_1() { return cNLParserRuleCall_6_0_1; }

		//(variantValues+=VariantValue NL)*
		public Group getGroup_6_1() { return cGroup_6_1; }

		//variantValues+=VariantValue
		public Assignment getVariantValuesAssignment_6_1_0() { return cVariantValuesAssignment_6_1_0; }

		//VariantValue
		public RuleCall getVariantValuesVariantValueParserRuleCall_6_1_0_0() { return cVariantValuesVariantValueParserRuleCall_6_1_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_6_1_1() { return cNLParserRuleCall_6_1_1; }

		//(parameterized='parameterized' NL)?
		public Group getGroup_7() { return cGroup_7; }

		//parameterized='parameterized'
		public Assignment getParameterizedAssignment_7_0() { return cParameterizedAssignment_7_0; }

		//'parameterized'
		public Keyword getParameterizedParameterizedKeyword_7_0_0() { return cParameterizedParameterizedKeyword_7_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_7_1() { return cNLParserRuleCall_7_1; }
	}

	public class VariableAssignmentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariableAssignment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cAssignKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Assignment cTargetAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cTargetVariableVariableParserRuleCall_6_0 = (RuleCall)cTargetAssignment_6.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7 = (RuleCall)cGroup.eContents().get(7);
		
		//VariableAssignment:
		//	'assign' NL value=ValueOrEnumValueOrOperationCollection NL '->' NL target=VariableVariable NL;
		@Override public ParserRule getRule() { return rule; }

		//'assign' NL value=ValueOrEnumValueOrOperationCollection NL '->' NL target=VariableVariable NL
		public Group getGroup() { return cGroup; }

		//'assign'
		public Keyword getAssignKeyword_0() { return cAssignKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_2_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_4() { return cHyphenMinusGreaterThanSignKeyword_4; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//target=VariableVariable
		public Assignment getTargetAssignment_6() { return cTargetAssignment_6; }

		//VariableVariable
		public RuleCall getTargetVariableVariableParserRuleCall_6_0() { return cTargetVariableVariableParserRuleCall_6_0; }

		//NL
		public RuleCall getNLParserRuleCall_7() { return cNLParserRuleCall_7; }
	}

	public class VariantValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariantValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cInKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cNamesAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final CrossReference cNamesVariantDefinitionCrossReference_2_0_0 = (CrossReference)cNamesAssignment_2_0.eContents().get(0);
		private final RuleCall cNamesVariantDefinitionQualifiedNameParserRuleCall_2_0_0_1 = (RuleCall)cNamesVariantDefinitionCrossReference_2_0_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final RuleCall cNLParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Assignment cValueAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_0 = (RuleCall)cValueAssignment_5.eContents().get(0);
		
		//VariantValue:
		//	'in' NL (names+=[VariantDefinition|QualifiedName] NL)+ ':' NL value=ValueOrEnumValueOrOperationCollection;
		@Override public ParserRule getRule() { return rule; }

		//'in' NL (names+=[VariantDefinition|QualifiedName] NL)+ ':' NL value=ValueOrEnumValueOrOperationCollection
		public Group getGroup() { return cGroup; }

		//'in'
		public Keyword getInKeyword_0() { return cInKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(names+=[VariantDefinition|QualifiedName] NL)+
		public Group getGroup_2() { return cGroup_2; }

		//names+=[VariantDefinition|QualifiedName]
		public Assignment getNamesAssignment_2_0() { return cNamesAssignment_2_0; }

		//[VariantDefinition|QualifiedName]
		public CrossReference getNamesVariantDefinitionCrossReference_2_0_0() { return cNamesVariantDefinitionCrossReference_2_0_0; }

		//QualifiedName
		public RuleCall getNamesVariantDefinitionQualifiedNameParserRuleCall_2_0_0_1() { return cNamesVariantDefinitionQualifiedNameParserRuleCall_2_0_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_2_1() { return cNLParserRuleCall_2_1; }

		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }

		//NL
		public RuleCall getNLParserRuleCall_4() { return cNLParserRuleCall_4; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_5() { return cValueAssignment_5; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_5_0; }
	}

	public class VariableEntityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariableEntity");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameQualifiedNameParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//VariableEntity:
		//	name=QualifiedName;
		@Override public ParserRule getRule() { return rule; }

		//name=QualifiedName
		public Assignment getNameAssignment() { return cNameAssignment; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_0() { return cNameQualifiedNameParserRuleCall_0; }
	}

	public class ConstantEntityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ConstantEntity");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameQualifiedNameParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//ConstantEntity:
		//	name=QualifiedName;
		@Override public ParserRule getRule() { return rule; }

		//name=QualifiedName
		public Assignment getNameAssignment() { return cNameAssignment; }

		//QualifiedName
		public RuleCall getNameQualifiedNameParserRuleCall_0() { return cNameQualifiedNameParserRuleCall_0; }
	}

	public class VariableOrConstantEntityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariableOrConstantEntity");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cVariableEntityParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cConstantEntityParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//VariableOrConstantEntity:
		//	VariableEntity | ConstantEntity;
		@Override public ParserRule getRule() { return rule; }

		//VariableEntity | ConstantEntity
		public Alternatives getAlternatives() { return cAlternatives; }

		//VariableEntity
		public RuleCall getVariableEntityParserRuleCall_0() { return cVariableEntityParserRuleCall_0; }

		//ConstantEntity
		public RuleCall getConstantEntityParserRuleCall_1() { return cConstantEntityParserRuleCall_1; }
	}

	public class TestElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Test");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cCheckpointAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cCheckpointCheckpointKeyword_0_0 = (Keyword)cCheckpointAssignment_0.eContents().get(0);
		private final Keyword cTestKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Assignment cDefinitionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cDefinitionTestDefinitionCrossReference_3_0 = (CrossReference)cDefinitionAssignment_3.eContents().get(0);
		private final RuleCall cDefinitionTestDefinitionQualifiedNameParserRuleCall_3_0_1 = (RuleCall)cDefinitionTestDefinitionCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_4_0 = (RuleCall)cGroup_4.eContents().get(0);
		private final Assignment cParametersAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cParametersParameterParserRuleCall_4_1_0 = (RuleCall)cParametersAssignment_4_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final RuleCall cNLParserRuleCall_5_0 = (RuleCall)cGroup_5.eContents().get(0);
		private final Assignment cResultsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cResultsNamedResultParserRuleCall_5_1_0 = (RuleCall)cResultsAssignment_5_1.eContents().get(0);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final RuleCall cNLParserRuleCall_6_0 = (RuleCall)cGroup_6.eContents().get(0);
		private final Keyword cEqualsSignKeyword_6_1 = (Keyword)cGroup_6.eContents().get(1);
		private final RuleCall cNLParserRuleCall_6_2 = (RuleCall)cGroup_6.eContents().get(2);
		private final Assignment cResultAssignment_6_3 = (Assignment)cGroup_6.eContents().get(3);
		private final RuleCall cResultValueOrEnumValueOrOperationCollectionParserRuleCall_6_3_0 = (RuleCall)cResultAssignment_6_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7 = (RuleCall)cGroup.eContents().get(7);
		
		//Test:
		//	checkpoint='checkpoint'? 'test' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* (NL
		//	results+=NamedResult)* (NL '=' NL result=ValueOrEnumValueOrOperationCollection)? NL;
		@Override public ParserRule getRule() { return rule; }

		//checkpoint='checkpoint'? 'test' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* (NL
		//results+=NamedResult)* (NL '=' NL result=ValueOrEnumValueOrOperationCollection)? NL
		public Group getGroup() { return cGroup; }

		//checkpoint='checkpoint'?
		public Assignment getCheckpointAssignment_0() { return cCheckpointAssignment_0; }

		//'checkpoint'
		public Keyword getCheckpointCheckpointKeyword_0_0() { return cCheckpointCheckpointKeyword_0_0; }

		//'test'
		public Keyword getTestKeyword_1() { return cTestKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//definition=[TestDefinition|QualifiedName]
		public Assignment getDefinitionAssignment_3() { return cDefinitionAssignment_3; }

		//[TestDefinition|QualifiedName]
		public CrossReference getDefinitionTestDefinitionCrossReference_3_0() { return cDefinitionTestDefinitionCrossReference_3_0; }

		//QualifiedName
		public RuleCall getDefinitionTestDefinitionQualifiedNameParserRuleCall_3_0_1() { return cDefinitionTestDefinitionQualifiedNameParserRuleCall_3_0_1; }

		//(NL parameters+=Parameter)*
		public Group getGroup_4() { return cGroup_4; }

		//NL
		public RuleCall getNLParserRuleCall_4_0() { return cNLParserRuleCall_4_0; }

		//parameters+=Parameter
		public Assignment getParametersAssignment_4_1() { return cParametersAssignment_4_1; }

		//Parameter
		public RuleCall getParametersParameterParserRuleCall_4_1_0() { return cParametersParameterParserRuleCall_4_1_0; }

		//(NL results+=NamedResult)*
		public Group getGroup_5() { return cGroup_5; }

		//NL
		public RuleCall getNLParserRuleCall_5_0() { return cNLParserRuleCall_5_0; }

		//results+=NamedResult
		public Assignment getResultsAssignment_5_1() { return cResultsAssignment_5_1; }

		//NamedResult
		public RuleCall getResultsNamedResultParserRuleCall_5_1_0() { return cResultsNamedResultParserRuleCall_5_1_0; }

		//(NL '=' NL result=ValueOrEnumValueOrOperationCollection)?
		public Group getGroup_6() { return cGroup_6; }

		//NL
		public RuleCall getNLParserRuleCall_6_0() { return cNLParserRuleCall_6_0; }

		//'='
		public Keyword getEqualsSignKeyword_6_1() { return cEqualsSignKeyword_6_1; }

		//NL
		public RuleCall getNLParserRuleCall_6_2() { return cNLParserRuleCall_6_2; }

		//result=ValueOrEnumValueOrOperationCollection
		public Assignment getResultAssignment_6_3() { return cResultAssignment_6_3; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getResultValueOrEnumValueOrOperationCollectionParserRuleCall_6_3_0() { return cResultValueOrEnumValueOrOperationCollectionParserRuleCall_6_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_7() { return cNLParserRuleCall_7; }
	}

	public class TableTestElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TableTest");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cTabletestKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cDefinitionAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cDefinitionTestDefinitionCrossReference_2_0 = (CrossReference)cDefinitionAssignment_2.eContents().get(0);
		private final RuleCall cDefinitionTestDefinitionQualifiedNameParserRuleCall_2_0_1 = (RuleCall)cDefinitionTestDefinitionCrossReference_2_0.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final RuleCall cNLParserRuleCall_3_0 = (RuleCall)cGroup_3.eContents().get(0);
		private final Assignment cParametersAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cParametersParameterParserRuleCall_3_1_0 = (RuleCall)cParametersAssignment_3_1.eContents().get(0);
		private final RuleCall cNLFORCEDParserRuleCall_4 = (RuleCall)cGroup.eContents().get(4);
		private final Assignment cParameterHeadersAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cParameterHeadersParameterTableHeaderParserRuleCall_5_0 = (RuleCall)cParameterHeadersAssignment_5.eContents().get(0);
		private final Assignment cResultHeadersAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cResultHeadersResultTableHeaderParserRuleCall_6_0 = (RuleCall)cResultHeadersAssignment_6.eContents().get(0);
		private final Keyword cVerticalLineKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Group cGroup_8 = (Group)cGroup.eContents().get(8);
		private final Assignment cDefaultResultColumnAssignment_8_0 = (Assignment)cGroup_8.eContents().get(0);
		private final Keyword cDefaultResultColumnEqualsSignKeyword_8_0_0 = (Keyword)cDefaultResultColumnAssignment_8_0.eContents().get(0);
		private final Keyword cVerticalLineKeyword_8_1 = (Keyword)cGroup_8.eContents().get(1);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final RuleCall cNLFORCEDParserRuleCall_9_0 = (RuleCall)cGroup_9.eContents().get(0);
		private final Assignment cRowsAssignment_9_1 = (Assignment)cGroup_9.eContents().get(1);
		private final RuleCall cRowsTableTestRowParserRuleCall_9_1_0 = (RuleCall)cRowsAssignment_9_1.eContents().get(0);
		private final RuleCall cNLFORCEDParserRuleCall_10 = (RuleCall)cGroup.eContents().get(10);
		
		//TableTest:
		//	'tabletest' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* NLFORCED
		//	parameterHeaders+=ParameterTableHeader* resultHeaders+=ResultTableHeader* '|' (defaultResultColumn='=' '|')? (NLFORCED
		//	rows+=TableTestRow)+ NLFORCED;
		@Override public ParserRule getRule() { return rule; }

		//'tabletest' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* NLFORCED
		//parameterHeaders+=ParameterTableHeader* resultHeaders+=ResultTableHeader* '|' (defaultResultColumn='=' '|')? (NLFORCED
		//rows+=TableTestRow)+ NLFORCED
		public Group getGroup() { return cGroup; }

		//'tabletest'
		public Keyword getTabletestKeyword_0() { return cTabletestKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//definition=[TestDefinition|QualifiedName]
		public Assignment getDefinitionAssignment_2() { return cDefinitionAssignment_2; }

		//[TestDefinition|QualifiedName]
		public CrossReference getDefinitionTestDefinitionCrossReference_2_0() { return cDefinitionTestDefinitionCrossReference_2_0; }

		//QualifiedName
		public RuleCall getDefinitionTestDefinitionQualifiedNameParserRuleCall_2_0_1() { return cDefinitionTestDefinitionQualifiedNameParserRuleCall_2_0_1; }

		//(NL parameters+=Parameter)*
		public Group getGroup_3() { return cGroup_3; }

		//NL
		public RuleCall getNLParserRuleCall_3_0() { return cNLParserRuleCall_3_0; }

		//parameters+=Parameter
		public Assignment getParametersAssignment_3_1() { return cParametersAssignment_3_1; }

		//Parameter
		public RuleCall getParametersParameterParserRuleCall_3_1_0() { return cParametersParameterParserRuleCall_3_1_0; }

		//NLFORCED
		public RuleCall getNLFORCEDParserRuleCall_4() { return cNLFORCEDParserRuleCall_4; }

		//parameterHeaders+=ParameterTableHeader*
		public Assignment getParameterHeadersAssignment_5() { return cParameterHeadersAssignment_5; }

		//ParameterTableHeader
		public RuleCall getParameterHeadersParameterTableHeaderParserRuleCall_5_0() { return cParameterHeadersParameterTableHeaderParserRuleCall_5_0; }

		//resultHeaders+=ResultTableHeader*
		public Assignment getResultHeadersAssignment_6() { return cResultHeadersAssignment_6; }

		//ResultTableHeader
		public RuleCall getResultHeadersResultTableHeaderParserRuleCall_6_0() { return cResultHeadersResultTableHeaderParserRuleCall_6_0; }

		//'|'
		public Keyword getVerticalLineKeyword_7() { return cVerticalLineKeyword_7; }

		//(defaultResultColumn='=' '|')?
		public Group getGroup_8() { return cGroup_8; }

		//defaultResultColumn='='
		public Assignment getDefaultResultColumnAssignment_8_0() { return cDefaultResultColumnAssignment_8_0; }

		//'='
		public Keyword getDefaultResultColumnEqualsSignKeyword_8_0_0() { return cDefaultResultColumnEqualsSignKeyword_8_0_0; }

		//'|'
		public Keyword getVerticalLineKeyword_8_1() { return cVerticalLineKeyword_8_1; }

		//(NLFORCED rows+=TableTestRow)+
		public Group getGroup_9() { return cGroup_9; }

		//NLFORCED
		public RuleCall getNLFORCEDParserRuleCall_9_0() { return cNLFORCEDParserRuleCall_9_0; }

		//rows+=TableTestRow
		public Assignment getRowsAssignment_9_1() { return cRowsAssignment_9_1; }

		//TableTestRow
		public RuleCall getRowsTableTestRowParserRuleCall_9_1_0() { return cRowsTableTestRowParserRuleCall_9_1_0; }

		//NLFORCED
		public RuleCall getNLFORCEDParserRuleCall_10() { return cNLFORCEDParserRuleCall_10; }
	}

	public class TableTestRowElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TableTestRow");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cTableTestRowAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValuesAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValuesParameterTableValueParserRuleCall_1_0 = (RuleCall)cValuesAssignment_1.eContents().get(0);
		
		//TableTestRow:
		//	{TableTestRow} values+=ParameterTableValue+;
		@Override public ParserRule getRule() { return rule; }

		//{TableTestRow} values+=ParameterTableValue+
		public Group getGroup() { return cGroup; }

		//{TableTestRow}
		public Action getTableTestRowAction_0() { return cTableTestRowAction_0; }

		//values+=ParameterTableValue+
		public Assignment getValuesAssignment_1() { return cValuesAssignment_1; }

		//ParameterTableValue
		public RuleCall getValuesParameterTableValueParserRuleCall_1_0() { return cValuesParameterTableValueParserRuleCall_1_0; }
	}

	public class ParameterTableHeaderElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ParameterTableHeader");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cVerticalLineKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameParameterNameParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cVerticalLineKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//ParameterTableHeader:
		//	'|' name=ParameterName '|'?;
		@Override public ParserRule getRule() { return rule; }

		//'|' name=ParameterName '|'?
		public Group getGroup() { return cGroup; }

		//'|'
		public Keyword getVerticalLineKeyword_0() { return cVerticalLineKeyword_0; }

		//name=ParameterName
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//ParameterName
		public RuleCall getNameParameterNameParserRuleCall_1_0() { return cNameParameterNameParserRuleCall_1_0; }

		//'|'?
		public Keyword getVerticalLineKeyword_2() { return cVerticalLineKeyword_2; }
	}

	public class ResultTableHeaderElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ResultTableHeader");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cVerticalLineKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameResultNameParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cVerticalLineKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//ResultTableHeader:
		//	'|' name=ResultName '=' '|'?;
		@Override public ParserRule getRule() { return rule; }

		//'|' name=ResultName '=' '|'?
		public Group getGroup() { return cGroup; }

		//'|'
		public Keyword getVerticalLineKeyword_0() { return cVerticalLineKeyword_0; }

		//name=ResultName
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//ResultName
		public RuleCall getNameResultNameParserRuleCall_1_0() { return cNameResultNameParserRuleCall_1_0; }

		//'='
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }

		//'|'?
		public Keyword getVerticalLineKeyword_3() { return cVerticalLineKeyword_3; }
	}

	public class ParameterTableValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ParameterTableValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cVerticalLineKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		private final Keyword cVerticalLineKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//ParameterTableValue:
		//	'|' value=ValueOrEnumValueOrOperationCollection '|'?;
		@Override public ParserRule getRule() { return rule; }

		//'|' value=ValueOrEnumValueOrOperationCollection '|'?
		public Group getGroup() { return cGroup; }

		//'|'
		public Keyword getVerticalLineKeyword_0() { return cVerticalLineKeyword_0; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_1_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_1_0; }

		//'|'?
		public Keyword getVerticalLineKeyword_2() { return cVerticalLineKeyword_2; }
	}

	public class NamedResultElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NamedResult");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameResultNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cEqualsSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//NamedResult:
		//	name=ResultName NL '=' NL value=ValueOrEnumValueOrOperationCollection;
		@Override public ParserRule getRule() { return rule; }

		//name=ResultName NL '=' NL value=ValueOrEnumValueOrOperationCollection
		public Group getGroup() { return cGroup; }

		//name=ResultName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ResultName
		public RuleCall getNameResultNameParserRuleCall_0_0() { return cNameResultNameParserRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//'='
		public Keyword getEqualsSignKeyword_2() { return cEqualsSignKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0; }
	}

	public class ResultNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ResultName");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cFixedResultNameParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cArbitraryParameterOrResultNameParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ResultName:
		//	FixedResultName | ArbitraryParameterOrResultName;
		@Override public ParserRule getRule() { return rule; }

		//FixedResultName | ArbitraryParameterOrResultName
		public Alternatives getAlternatives() { return cAlternatives; }

		//FixedResultName
		public RuleCall getFixedResultNameParserRuleCall_0() { return cFixedResultNameParserRuleCall_0; }

		//ArbitraryParameterOrResultName
		public RuleCall getArbitraryParameterOrResultNameParserRuleCall_1() { return cArbitraryParameterOrResultNameParserRuleCall_1; }
	}

	public class FixedResultNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.FixedResultName");
		private final Assignment cFieldAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cFieldJvmFieldCrossReference_0 = (CrossReference)cFieldAssignment.eContents().get(0);
		private final RuleCall cFieldJvmFieldIDTerminalRuleCall_0_1 = (RuleCall)cFieldJvmFieldCrossReference_0.eContents().get(1);
		
		//FixedResultName:
		//	field=[jvmTypes::JvmField];
		@Override public ParserRule getRule() { return rule; }

		//field=[jvmTypes::JvmField]
		public Assignment getFieldAssignment() { return cFieldAssignment; }

		//[jvmTypes::JvmField]
		public CrossReference getFieldJvmFieldCrossReference_0() { return cFieldJvmFieldCrossReference_0; }

		//ID
		public RuleCall getFieldJvmFieldIDTerminalRuleCall_0_1() { return cFieldJvmFieldIDTerminalRuleCall_0_1; }
	}

	public class CallElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Call");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCallKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cMultiplierAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cMultiplierExecutionMultiplierParserRuleCall_2_0_0 = (RuleCall)cMultiplierAssignment_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Assignment cDefinitionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cDefinitionCallDefinitionCrossReference_3_0 = (CrossReference)cDefinitionAssignment_3.eContents().get(0);
		private final RuleCall cDefinitionCallDefinitionQualifiedNameParserRuleCall_3_0_1 = (RuleCall)cDefinitionCallDefinitionCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_4_0 = (RuleCall)cGroup_4.eContents().get(0);
		private final Assignment cParametersAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cParametersParameterParserRuleCall_4_1_0 = (RuleCall)cParametersAssignment_4_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final RuleCall cNLParserRuleCall_5_0 = (RuleCall)cGroup_5.eContents().get(0);
		private final Assignment cResultsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final RuleCall cResultsNamedCallResultParserRuleCall_5_1_0 = (RuleCall)cResultsAssignment_5_1.eContents().get(0);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final RuleCall cNLParserRuleCall_6_0 = (RuleCall)cGroup_6.eContents().get(0);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_6_1 = (Keyword)cGroup_6.eContents().get(1);
		private final RuleCall cNLParserRuleCall_6_2 = (RuleCall)cGroup_6.eContents().get(2);
		private final Assignment cResultAssignment_6_3 = (Assignment)cGroup_6.eContents().get(3);
		private final RuleCall cResultVariableVariableParserRuleCall_6_3_0 = (RuleCall)cResultAssignment_6_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7 = (RuleCall)cGroup.eContents().get(7);
		
		//Call:
		//	'call' NL (multiplier=ExecutionMultiplier NL)? definition=[CallDefinition|QualifiedName] (NL parameters+=Parameter)*
		//	(NL results+=NamedCallResult)* (NL '->' NL result=VariableVariable)? NL;
		@Override public ParserRule getRule() { return rule; }

		//'call' NL (multiplier=ExecutionMultiplier NL)? definition=[CallDefinition|QualifiedName] (NL parameters+=Parameter)* (NL
		//results+=NamedCallResult)* (NL '->' NL result=VariableVariable)? NL
		public Group getGroup() { return cGroup; }

		//'call'
		public Keyword getCallKeyword_0() { return cCallKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(multiplier=ExecutionMultiplier NL)?
		public Group getGroup_2() { return cGroup_2; }

		//multiplier=ExecutionMultiplier
		public Assignment getMultiplierAssignment_2_0() { return cMultiplierAssignment_2_0; }

		//ExecutionMultiplier
		public RuleCall getMultiplierExecutionMultiplierParserRuleCall_2_0_0() { return cMultiplierExecutionMultiplierParserRuleCall_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1() { return cNLParserRuleCall_2_1; }

		//definition=[CallDefinition|QualifiedName]
		public Assignment getDefinitionAssignment_3() { return cDefinitionAssignment_3; }

		//[CallDefinition|QualifiedName]
		public CrossReference getDefinitionCallDefinitionCrossReference_3_0() { return cDefinitionCallDefinitionCrossReference_3_0; }

		//QualifiedName
		public RuleCall getDefinitionCallDefinitionQualifiedNameParserRuleCall_3_0_1() { return cDefinitionCallDefinitionQualifiedNameParserRuleCall_3_0_1; }

		//(NL parameters+=Parameter)*
		public Group getGroup_4() { return cGroup_4; }

		//NL
		public RuleCall getNLParserRuleCall_4_0() { return cNLParserRuleCall_4_0; }

		//parameters+=Parameter
		public Assignment getParametersAssignment_4_1() { return cParametersAssignment_4_1; }

		//Parameter
		public RuleCall getParametersParameterParserRuleCall_4_1_0() { return cParametersParameterParserRuleCall_4_1_0; }

		//(NL results+=NamedCallResult)*
		public Group getGroup_5() { return cGroup_5; }

		//NL
		public RuleCall getNLParserRuleCall_5_0() { return cNLParserRuleCall_5_0; }

		//results+=NamedCallResult
		public Assignment getResultsAssignment_5_1() { return cResultsAssignment_5_1; }

		//NamedCallResult
		public RuleCall getResultsNamedCallResultParserRuleCall_5_1_0() { return cResultsNamedCallResultParserRuleCall_5_1_0; }

		//(NL '->' NL result=VariableVariable)?
		public Group getGroup_6() { return cGroup_6; }

		//NL
		public RuleCall getNLParserRuleCall_6_0() { return cNLParserRuleCall_6_0; }

		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_6_1() { return cHyphenMinusGreaterThanSignKeyword_6_1; }

		//NL
		public RuleCall getNLParserRuleCall_6_2() { return cNLParserRuleCall_6_2; }

		//result=VariableVariable
		public Assignment getResultAssignment_6_3() { return cResultAssignment_6_3; }

		//VariableVariable
		public RuleCall getResultVariableVariableParserRuleCall_6_3_0() { return cResultVariableVariableParserRuleCall_6_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_7() { return cNLParserRuleCall_7; }
	}

	public class NamedCallResultElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NamedCallResult");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameResultNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cTargetVariableVariableParserRuleCall_4_0 = (RuleCall)cTargetAssignment_4.eContents().get(0);
		
		//NamedCallResult:
		//	name=ResultName NL '->' NL target=VariableVariable;
		@Override public ParserRule getRule() { return rule; }

		//name=ResultName NL '->' NL target=VariableVariable
		public Group getGroup() { return cGroup; }

		//name=ResultName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ResultName
		public RuleCall getNameResultNameParserRuleCall_0_0() { return cNameResultNameParserRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//target=VariableVariable
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }

		//VariableVariable
		public RuleCall getTargetVariableVariableParserRuleCall_4_0() { return cTargetVariableVariableParserRuleCall_4_0; }
	}

	public class TimeSetElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TimeSet");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cTimesetKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Alternatives cAlternatives_2 = (Alternatives)cGroup.eContents().get(2);
		private final Group cGroup_2_0 = (Group)cAlternatives_2.eContents().get(0);
		private final Assignment cLiveAssignment_2_0_0 = (Assignment)cGroup_2_0.eContents().get(0);
		private final Keyword cLiveLiveKeyword_2_0_0_0 = (Keyword)cLiveAssignment_2_0_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_0_1 = (RuleCall)cGroup_2_0.eContents().get(1);
		private final Group cGroup_2_1 = (Group)cAlternatives_2.eContents().get(1);
		private final Alternatives cAlternatives_2_1_0 = (Alternatives)cGroup_2_1.eContents().get(0);
		private final Assignment cStartTimeAssignment_2_1_0_0 = (Assignment)cAlternatives_2_1_0.eContents().get(0);
		private final RuleCall cStartTimeValueOrEnumValueOrOperationParserRuleCall_2_1_0_0_0 = (RuleCall)cStartTimeAssignment_2_1_0_0.eContents().get(0);
		private final Assignment cDiffTimeAssignment_2_1_0_1 = (Assignment)cAlternatives_2_1_0.eContents().get(1);
		private final RuleCall cDiffTimeTimeDifferenceParserRuleCall_2_1_0_1_0 = (RuleCall)cDiffTimeAssignment_2_1_0_1.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1_1 = (RuleCall)cGroup_2_1.eContents().get(1);
		private final Group cGroup_2_1_2 = (Group)cGroup_2_1.eContents().get(2);
		private final Assignment cProgressionModeAssignment_2_1_2_0 = (Assignment)cGroup_2_1_2.eContents().get(0);
		private final Keyword cProgressionModeProgressingKeyword_2_1_2_0_0 = (Keyword)cProgressionModeAssignment_2_1_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1_2_1 = (RuleCall)cGroup_2_1_2.eContents().get(1);
		private final Group cGroup_2_1_2_2 = (Group)cGroup_2_1_2.eContents().get(2);
		private final Assignment cProgressionFactorAssignment_2_1_2_2_0 = (Assignment)cGroup_2_1_2_2.eContents().get(0);
		private final RuleCall cProgressionFactorTimeProgressionFactorParserRuleCall_2_1_2_2_0_0 = (RuleCall)cProgressionFactorAssignment_2_1_2_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1_2_2_1 = (RuleCall)cGroup_2_1_2_2.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cOnKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final RuleCall cNLParserRuleCall_3_1 = (RuleCall)cGroup_3.eContents().get(1);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Alternatives cAlternatives_3_2_0 = (Alternatives)cGroup_3_2.eContents().get(0);
		private final Assignment cForksAssignment_3_2_0_0 = (Assignment)cAlternatives_3_2_0.eContents().get(0);
		private final CrossReference cForksForkDefinitionCrossReference_3_2_0_0_0 = (CrossReference)cForksAssignment_3_2_0_0.eContents().get(0);
		private final RuleCall cForksForkDefinitionQualifiedNameParserRuleCall_3_2_0_0_0_1 = (RuleCall)cForksForkDefinitionCrossReference_3_2_0_0_0.eContents().get(1);
		private final Assignment cMasterForkAssignment_3_2_0_1 = (Assignment)cAlternatives_3_2_0.eContents().get(1);
		private final Keyword cMasterForkMasterKeyword_3_2_0_1_0 = (Keyword)cMasterForkAssignment_3_2_0_1.eContents().get(0);
		private final Keyword cCommaKeyword_3_2_1 = (Keyword)cGroup_3_2.eContents().get(1);
		private final RuleCall cNLParserRuleCall_3_2_2 = (RuleCall)cGroup_3_2.eContents().get(2);
		
		//TimeSet:
		//	'timeset' NL (live='live' NL | (startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) NL
		//	(progressionMode='progressing' NL (progressionFactor=TimeProgressionFactor NL)?)?) ('on' NL
		//	((forks+=[ForkDefinition|QualifiedName] | masterFork='master') ','? NL)+)?;
		@Override public ParserRule getRule() { return rule; }

		//'timeset' NL (live='live' NL | (startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) NL
		//(progressionMode='progressing' NL (progressionFactor=TimeProgressionFactor NL)?)?) ('on' NL
		//((forks+=[ForkDefinition|QualifiedName] | masterFork='master') ','? NL)+)?
		public Group getGroup() { return cGroup; }

		//'timeset'
		public Keyword getTimesetKeyword_0() { return cTimesetKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(live='live' NL | (startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) NL (progressionMode='progressing' NL
		//(progressionFactor=TimeProgressionFactor NL)?)?)
		public Alternatives getAlternatives_2() { return cAlternatives_2; }

		//live='live' NL
		public Group getGroup_2_0() { return cGroup_2_0; }

		//live='live'
		public Assignment getLiveAssignment_2_0_0() { return cLiveAssignment_2_0_0; }

		//'live'
		public Keyword getLiveLiveKeyword_2_0_0_0() { return cLiveLiveKeyword_2_0_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_0_1() { return cNLParserRuleCall_2_0_1; }

		//(startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) NL (progressionMode='progressing' NL
		//(progressionFactor=TimeProgressionFactor NL)?)?
		public Group getGroup_2_1() { return cGroup_2_1; }

		//(startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference)
		public Alternatives getAlternatives_2_1_0() { return cAlternatives_2_1_0; }

		//startTime=ValueOrEnumValueOrOperation
		public Assignment getStartTimeAssignment_2_1_0_0() { return cStartTimeAssignment_2_1_0_0; }

		//ValueOrEnumValueOrOperation
		public RuleCall getStartTimeValueOrEnumValueOrOperationParserRuleCall_2_1_0_0_0() { return cStartTimeValueOrEnumValueOrOperationParserRuleCall_2_1_0_0_0; }

		//diffTime=TimeDifference
		public Assignment getDiffTimeAssignment_2_1_0_1() { return cDiffTimeAssignment_2_1_0_1; }

		//TimeDifference
		public RuleCall getDiffTimeTimeDifferenceParserRuleCall_2_1_0_1_0() { return cDiffTimeTimeDifferenceParserRuleCall_2_1_0_1_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1_1() { return cNLParserRuleCall_2_1_1; }

		//(progressionMode='progressing' NL (progressionFactor=TimeProgressionFactor NL)?)?
		public Group getGroup_2_1_2() { return cGroup_2_1_2; }

		//progressionMode='progressing'
		public Assignment getProgressionModeAssignment_2_1_2_0() { return cProgressionModeAssignment_2_1_2_0; }

		//'progressing'
		public Keyword getProgressionModeProgressingKeyword_2_1_2_0_0() { return cProgressionModeProgressingKeyword_2_1_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1_2_1() { return cNLParserRuleCall_2_1_2_1; }

		//(progressionFactor=TimeProgressionFactor NL)?
		public Group getGroup_2_1_2_2() { return cGroup_2_1_2_2; }

		//progressionFactor=TimeProgressionFactor
		public Assignment getProgressionFactorAssignment_2_1_2_2_0() { return cProgressionFactorAssignment_2_1_2_2_0; }

		//TimeProgressionFactor
		public RuleCall getProgressionFactorTimeProgressionFactorParserRuleCall_2_1_2_2_0_0() { return cProgressionFactorTimeProgressionFactorParserRuleCall_2_1_2_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1_2_2_1() { return cNLParserRuleCall_2_1_2_2_1; }

		//('on' NL ((forks+=[ForkDefinition|QualifiedName] | masterFork='master') ','? NL)+)?
		public Group getGroup_3() { return cGroup_3; }

		//'on'
		public Keyword getOnKeyword_3_0() { return cOnKeyword_3_0; }

		//NL
		public RuleCall getNLParserRuleCall_3_1() { return cNLParserRuleCall_3_1; }

		//((forks+=[ForkDefinition|QualifiedName] | masterFork='master') ','? NL)+
		public Group getGroup_3_2() { return cGroup_3_2; }

		//(forks+=[ForkDefinition|QualifiedName] | masterFork='master')
		public Alternatives getAlternatives_3_2_0() { return cAlternatives_3_2_0; }

		//forks+=[ForkDefinition|QualifiedName]
		public Assignment getForksAssignment_3_2_0_0() { return cForksAssignment_3_2_0_0; }

		//[ForkDefinition|QualifiedName]
		public CrossReference getForksForkDefinitionCrossReference_3_2_0_0_0() { return cForksForkDefinitionCrossReference_3_2_0_0_0; }

		//QualifiedName
		public RuleCall getForksForkDefinitionQualifiedNameParserRuleCall_3_2_0_0_0_1() { return cForksForkDefinitionQualifiedNameParserRuleCall_3_2_0_0_0_1; }

		//masterFork='master'
		public Assignment getMasterForkAssignment_3_2_0_1() { return cMasterForkAssignment_3_2_0_1; }

		//'master'
		public Keyword getMasterForkMasterKeyword_3_2_0_1_0() { return cMasterForkMasterKeyword_3_2_0_1_0; }

		//','?
		public Keyword getCommaKeyword_3_2_1() { return cCommaKeyword_3_2_1; }

		//NL
		public RuleCall getNLParserRuleCall_3_2_2() { return cNLParserRuleCall_3_2_2; }
	}

	public class TimeProgressionFactorElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TimeProgressionFactor");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cFixedValueAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final RuleCall cFixedValueMULTIPLIERTerminalRuleCall_0_0 = (RuleCall)cFixedValueAssignment_0.eContents().get(0);
		private final Assignment cCalculatedValueAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final Alternatives cCalculatedValueAlternatives_1_0 = (Alternatives)cCalculatedValueAssignment_1.eContents().get(0);
		private final RuleCall cCalculatedValueVariableParserRuleCall_1_0_0 = (RuleCall)cCalculatedValueAlternatives_1_0.eContents().get(0);
		private final RuleCall cCalculatedValueOperationParserRuleCall_1_0_1 = (RuleCall)cCalculatedValueAlternatives_1_0.eContents().get(1);
		
		//TimeProgressionFactor:
		//	fixedValue=MULTIPLIER | calculatedValue=(Variable | Operation);
		@Override public ParserRule getRule() { return rule; }

		//fixedValue=MULTIPLIER | calculatedValue=(Variable | Operation)
		public Alternatives getAlternatives() { return cAlternatives; }

		//fixedValue=MULTIPLIER
		public Assignment getFixedValueAssignment_0() { return cFixedValueAssignment_0; }

		//MULTIPLIER
		public RuleCall getFixedValueMULTIPLIERTerminalRuleCall_0_0() { return cFixedValueMULTIPLIERTerminalRuleCall_0_0; }

		//calculatedValue=(Variable | Operation)
		public Assignment getCalculatedValueAssignment_1() { return cCalculatedValueAssignment_1; }

		//(Variable | Operation)
		public Alternatives getCalculatedValueAlternatives_1_0() { return cCalculatedValueAlternatives_1_0; }

		//Variable
		public RuleCall getCalculatedValueVariableParserRuleCall_1_0_0() { return cCalculatedValueVariableParserRuleCall_1_0_0; }

		//Operation
		public RuleCall getCalculatedValueOperationParserRuleCall_1_0_1() { return cCalculatedValueOperationParserRuleCall_1_0_1; }
	}

	public class TimeDifferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TimeDifference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDirectionAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Alternatives cDirectionAlternatives_0_0 = (Alternatives)cDirectionAssignment_0.eContents().get(0);
		private final Keyword cDirectionPlusSignKeyword_0_0_0 = (Keyword)cDirectionAlternatives_0_0.eContents().get(0);
		private final Keyword cDirectionHyphenMinusKeyword_0_0_1 = (Keyword)cDirectionAlternatives_0_0.eContents().get(1);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Group cGroup_1_0 = (Group)cAlternatives_1.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1_0_0 = (RuleCall)cGroup_1_0.eContents().get(0);
		private final Assignment cFixedValuesAssignment_1_0_1 = (Assignment)cGroup_1_0.eContents().get(1);
		private final RuleCall cFixedValuesTIMESPANTerminalRuleCall_1_0_1_0 = (RuleCall)cFixedValuesAssignment_1_0_1.eContents().get(0);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1_1_0 = (RuleCall)cGroup_1_1.eContents().get(0);
		private final Assignment cCalculatedValueAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final Alternatives cCalculatedValueAlternatives_1_1_1_0 = (Alternatives)cCalculatedValueAssignment_1_1_1.eContents().get(0);
		private final RuleCall cCalculatedValueVariableParserRuleCall_1_1_1_0_0 = (RuleCall)cCalculatedValueAlternatives_1_1_1_0.eContents().get(0);
		private final RuleCall cCalculatedValueOperationParserRuleCall_1_1_1_0_1 = (RuleCall)cCalculatedValueAlternatives_1_1_1_0.eContents().get(1);
		
		//TimeDifference:
		//	direction=('+' | '-') ((NL fixedValues+=TIMESPAN)+ | NL calculatedValue=(Variable | Operation));
		@Override public ParserRule getRule() { return rule; }

		//// In case of calculated values for time differences, those are assumed to be in msecs
		//direction=('+' | '-') ((NL fixedValues+=TIMESPAN)+ | NL calculatedValue=(Variable | Operation))
		public Group getGroup() { return cGroup; }

		//// In case of calculated values for time differences, those are assumed to be in msecs
		//direction=('+' | '-')
		public Assignment getDirectionAssignment_0() { return cDirectionAssignment_0; }

		//('+' | '-')
		public Alternatives getDirectionAlternatives_0_0() { return cDirectionAlternatives_0_0; }

		//'+'
		public Keyword getDirectionPlusSignKeyword_0_0_0() { return cDirectionPlusSignKeyword_0_0_0; }

		//'-'
		public Keyword getDirectionHyphenMinusKeyword_0_0_1() { return cDirectionHyphenMinusKeyword_0_0_1; }

		//((NL fixedValues+=TIMESPAN)+ | NL calculatedValue=(Variable | Operation))
		public Alternatives getAlternatives_1() { return cAlternatives_1; }

		//(NL fixedValues+=TIMESPAN)+
		public Group getGroup_1_0() { return cGroup_1_0; }

		//NL
		public RuleCall getNLParserRuleCall_1_0_0() { return cNLParserRuleCall_1_0_0; }

		//fixedValues+=TIMESPAN
		public Assignment getFixedValuesAssignment_1_0_1() { return cFixedValuesAssignment_1_0_1; }

		//TIMESPAN
		public RuleCall getFixedValuesTIMESPANTerminalRuleCall_1_0_1_0() { return cFixedValuesTIMESPANTerminalRuleCall_1_0_1_0; }

		//NL calculatedValue=(Variable | Operation)
		public Group getGroup_1_1() { return cGroup_1_1; }

		//NL
		public RuleCall getNLParserRuleCall_1_1_0() { return cNLParserRuleCall_1_1_0; }

		//calculatedValue=(Variable | Operation)
		public Assignment getCalculatedValueAssignment_1_1_1() { return cCalculatedValueAssignment_1_1_1; }

		//(Variable | Operation)
		public Alternatives getCalculatedValueAlternatives_1_1_1_0() { return cCalculatedValueAlternatives_1_1_1_0; }

		//Variable
		public RuleCall getCalculatedValueVariableParserRuleCall_1_1_1_0_0() { return cCalculatedValueVariableParserRuleCall_1_1_1_0_0; }

		//Operation
		public RuleCall getCalculatedValueOperationParserRuleCall_1_1_1_0_1() { return cCalculatedValueOperationParserRuleCall_1_1_1_0_1; }
	}

	public class SuiteElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Suite");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cInlinedAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cInlinedInlinedKeyword_0_0 = (Keyword)cInlinedAssignment_0.eContents().get(0);
		private final Keyword cSuiteKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cMultiplierAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cMultiplierExecutionMultiplierParserRuleCall_3_0_0 = (RuleCall)cMultiplierAssignment_3_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_3_1 = (RuleCall)cGroup_3.eContents().get(1);
		private final Assignment cDefinitionAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cDefinitionSuiteDefinitionCrossReference_4_0 = (CrossReference)cDefinitionAssignment_4.eContents().get(0);
		private final RuleCall cDefinitionSuiteDefinitionQualifiedNameParserRuleCall_4_0_1 = (RuleCall)cDefinitionSuiteDefinitionCrossReference_4_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Assignment cParametersAssignment_6_0 = (Assignment)cGroup_6.eContents().get(0);
		private final RuleCall cParametersSuiteParameterParserRuleCall_6_0_0 = (RuleCall)cParametersAssignment_6_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_6_1 = (RuleCall)cGroup_6.eContents().get(1);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Assignment cReturnAssignment_7_0 = (Assignment)cGroup_7.eContents().get(0);
		private final RuleCall cReturnSuiteReturnParserRuleCall_7_0_0 = (RuleCall)cReturnAssignment_7_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_7_1 = (RuleCall)cGroup_7.eContents().get(1);
		private final Group cGroup_8 = (Group)cGroup.eContents().get(8);
		private final Keyword cOnKeyword_8_0 = (Keyword)cGroup_8.eContents().get(0);
		private final RuleCall cNLParserRuleCall_8_1 = (RuleCall)cGroup_8.eContents().get(1);
		private final Assignment cForkAssignment_8_2 = (Assignment)cGroup_8.eContents().get(2);
		private final CrossReference cForkForkDefinitionCrossReference_8_2_0 = (CrossReference)cForkAssignment_8_2.eContents().get(0);
		private final RuleCall cForkForkDefinitionQualifiedNameParserRuleCall_8_2_0_1 = (RuleCall)cForkForkDefinitionCrossReference_8_2_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_8_3 = (RuleCall)cGroup_8.eContents().get(3);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final Keyword cInKeyword_9_0 = (Keyword)cGroup_9.eContents().get(0);
		private final RuleCall cNLParserRuleCall_9_1 = (RuleCall)cGroup_9.eContents().get(1);
		private final Group cGroup_9_2 = (Group)cGroup_9.eContents().get(2);
		private final Assignment cVariantsAssignment_9_2_0 = (Assignment)cGroup_9_2.eContents().get(0);
		private final CrossReference cVariantsVariantDefinitionCrossReference_9_2_0_0 = (CrossReference)cVariantsAssignment_9_2_0.eContents().get(0);
		private final RuleCall cVariantsVariantDefinitionQualifiedNameParserRuleCall_9_2_0_0_1 = (RuleCall)cVariantsVariantDefinitionCrossReference_9_2_0_0.eContents().get(1);
		private final Keyword cCommaKeyword_9_2_1 = (Keyword)cGroup_9_2.eContents().get(1);
		private final RuleCall cNLParserRuleCall_9_2_2 = (RuleCall)cGroup_9_2.eContents().get(2);
		
		//Suite:
		//	inlined='inlined'? 'suite' NL (multiplier=ExecutionMultiplier NL)? definition=[SuiteDefinition|QualifiedName] NL
		//	(parameters+=SuiteParameter NL)* (return+=SuiteReturn NL)* ('on' NL fork=[ForkDefinition|QualifiedName] NL)? ('in' NL
		//	(variants+=[VariantDefinition|QualifiedName] ','? NL)+)?;
		@Override public ParserRule getRule() { return rule; }

		//inlined='inlined'? 'suite' NL (multiplier=ExecutionMultiplier NL)? definition=[SuiteDefinition|QualifiedName] NL
		//(parameters+=SuiteParameter NL)* (return+=SuiteReturn NL)* ('on' NL fork=[ForkDefinition|QualifiedName] NL)? ('in' NL
		//(variants+=[VariantDefinition|QualifiedName] ','? NL)+)?
		public Group getGroup() { return cGroup; }

		//inlined='inlined'?
		public Assignment getInlinedAssignment_0() { return cInlinedAssignment_0; }

		//'inlined'
		public Keyword getInlinedInlinedKeyword_0_0() { return cInlinedInlinedKeyword_0_0; }

		//'suite'
		public Keyword getSuiteKeyword_1() { return cSuiteKeyword_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }

		//(multiplier=ExecutionMultiplier NL)?
		public Group getGroup_3() { return cGroup_3; }

		//multiplier=ExecutionMultiplier
		public Assignment getMultiplierAssignment_3_0() { return cMultiplierAssignment_3_0; }

		//ExecutionMultiplier
		public RuleCall getMultiplierExecutionMultiplierParserRuleCall_3_0_0() { return cMultiplierExecutionMultiplierParserRuleCall_3_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_3_1() { return cNLParserRuleCall_3_1; }

		//definition=[SuiteDefinition|QualifiedName]
		public Assignment getDefinitionAssignment_4() { return cDefinitionAssignment_4; }

		//[SuiteDefinition|QualifiedName]
		public CrossReference getDefinitionSuiteDefinitionCrossReference_4_0() { return cDefinitionSuiteDefinitionCrossReference_4_0; }

		//QualifiedName
		public RuleCall getDefinitionSuiteDefinitionQualifiedNameParserRuleCall_4_0_1() { return cDefinitionSuiteDefinitionQualifiedNameParserRuleCall_4_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//(parameters+=SuiteParameter NL)*
		public Group getGroup_6() { return cGroup_6; }

		//parameters+=SuiteParameter
		public Assignment getParametersAssignment_6_0() { return cParametersAssignment_6_0; }

		//SuiteParameter
		public RuleCall getParametersSuiteParameterParserRuleCall_6_0_0() { return cParametersSuiteParameterParserRuleCall_6_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_6_1() { return cNLParserRuleCall_6_1; }

		//(return+=SuiteReturn NL)*
		public Group getGroup_7() { return cGroup_7; }

		//return+=SuiteReturn
		public Assignment getReturnAssignment_7_0() { return cReturnAssignment_7_0; }

		//SuiteReturn
		public RuleCall getReturnSuiteReturnParserRuleCall_7_0_0() { return cReturnSuiteReturnParserRuleCall_7_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_7_1() { return cNLParserRuleCall_7_1; }

		//('on' NL fork=[ForkDefinition|QualifiedName] NL)?
		public Group getGroup_8() { return cGroup_8; }

		//'on'
		public Keyword getOnKeyword_8_0() { return cOnKeyword_8_0; }

		//NL
		public RuleCall getNLParserRuleCall_8_1() { return cNLParserRuleCall_8_1; }

		//fork=[ForkDefinition|QualifiedName]
		public Assignment getForkAssignment_8_2() { return cForkAssignment_8_2; }

		//[ForkDefinition|QualifiedName]
		public CrossReference getForkForkDefinitionCrossReference_8_2_0() { return cForkForkDefinitionCrossReference_8_2_0; }

		//QualifiedName
		public RuleCall getForkForkDefinitionQualifiedNameParserRuleCall_8_2_0_1() { return cForkForkDefinitionQualifiedNameParserRuleCall_8_2_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_8_3() { return cNLParserRuleCall_8_3; }

		//('in' NL (variants+=[VariantDefinition|QualifiedName] ','? NL)+)?
		public Group getGroup_9() { return cGroup_9; }

		//'in'
		public Keyword getInKeyword_9_0() { return cInKeyword_9_0; }

		//NL
		public RuleCall getNLParserRuleCall_9_1() { return cNLParserRuleCall_9_1; }

		//(variants+=[VariantDefinition|QualifiedName] ','? NL)+
		public Group getGroup_9_2() { return cGroup_9_2; }

		//variants+=[VariantDefinition|QualifiedName]
		public Assignment getVariantsAssignment_9_2_0() { return cVariantsAssignment_9_2_0; }

		//[VariantDefinition|QualifiedName]
		public CrossReference getVariantsVariantDefinitionCrossReference_9_2_0_0() { return cVariantsVariantDefinitionCrossReference_9_2_0_0; }

		//QualifiedName
		public RuleCall getVariantsVariantDefinitionQualifiedNameParserRuleCall_9_2_0_0_1() { return cVariantsVariantDefinitionQualifiedNameParserRuleCall_9_2_0_0_1; }

		//','?
		public Keyword getCommaKeyword_9_2_1() { return cCommaKeyword_9_2_1; }

		//NL
		public RuleCall getNLParserRuleCall_9_2_2() { return cNLParserRuleCall_9_2_2; }
	}

	public class SuiteParameterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteParameter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cNameVariableOrConstantEntityCrossReference_0_0 = (CrossReference)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1 = (RuleCall)cNameVariableOrConstantEntityCrossReference_0_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//SuiteParameter:
		//	name=[VariableOrConstantEntity|QualifiedName] NL ':' NL value=ValueOrEnumValueOrOperationCollection;
		@Override public ParserRule getRule() { return rule; }

		//name=[VariableOrConstantEntity|QualifiedName] NL ':' NL value=ValueOrEnumValueOrOperationCollection
		public Group getGroup() { return cGroup; }

		//name=[VariableOrConstantEntity|QualifiedName]
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//[VariableOrConstantEntity|QualifiedName]
		public CrossReference getNameVariableOrConstantEntityCrossReference_0_0() { return cNameVariableOrConstantEntityCrossReference_0_0; }

		//QualifiedName
		public RuleCall getNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1() { return cNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0; }
	}

	public class SuiteReturnElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SuiteReturn");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cNameSuiteReturnDefinitionCrossReference_0_0 = (CrossReference)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNameSuiteReturnDefinitionQualifiedNameParserRuleCall_0_0_1 = (RuleCall)cNameSuiteReturnDefinitionCrossReference_0_0.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cTargetVariableVariableParserRuleCall_4_0 = (RuleCall)cTargetAssignment_4.eContents().get(0);
		
		//SuiteReturn:
		//	name=[SuiteReturnDefinition|QualifiedName] NL '->' NL target=VariableVariable;
		@Override public ParserRule getRule() { return rule; }

		//name=[SuiteReturnDefinition|QualifiedName] NL '->' NL target=VariableVariable
		public Group getGroup() { return cGroup; }

		//name=[SuiteReturnDefinition|QualifiedName]
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//[SuiteReturnDefinition|QualifiedName]
		public CrossReference getNameSuiteReturnDefinitionCrossReference_0_0() { return cNameSuiteReturnDefinitionCrossReference_0_0; }

		//QualifiedName
		public RuleCall getNameSuiteReturnDefinitionQualifiedNameParserRuleCall_0_0_1() { return cNameSuiteReturnDefinitionQualifiedNameParserRuleCall_0_0_1; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//target=VariableVariable
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }

		//VariableVariable
		public RuleCall getTargetVariableVariableParserRuleCall_4_0() { return cTargetVariableVariableParserRuleCall_4_0; }
	}

	public class ParameterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Parameter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameParameterNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//Parameter:
		//	name=ParameterName NL ':' NL value=ValueOrEnumValueOrOperationCollection;
		@Override public ParserRule getRule() { return rule; }

		//name=ParameterName NL ':' NL value=ValueOrEnumValueOrOperationCollection
		public Group getGroup() { return cGroup; }

		//name=ParameterName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//ParameterName
		public RuleCall getNameParameterNameParserRuleCall_0_0() { return cNameParameterNameParserRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0; }
	}

	public class ParameterNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ParameterName");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cFixedParameterNameParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cArbitraryParameterOrResultNameParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ParameterName:
		//	FixedParameterName | ArbitraryParameterOrResultName;
		@Override public ParserRule getRule() { return rule; }

		//FixedParameterName | ArbitraryParameterOrResultName
		public Alternatives getAlternatives() { return cAlternatives; }

		//FixedParameterName
		public RuleCall getFixedParameterNameParserRuleCall_0() { return cFixedParameterNameParserRuleCall_0; }

		//ArbitraryParameterOrResultName
		public RuleCall getArbitraryParameterOrResultNameParserRuleCall_1() { return cArbitraryParameterOrResultNameParserRuleCall_1; }
	}

	public class FixedParameterNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.FixedParameterName");
		private final Assignment cAnnotationAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cAnnotationJvmAnnotationReferenceCrossReference_0 = (CrossReference)cAnnotationAssignment.eContents().get(0);
		private final RuleCall cAnnotationJvmAnnotationReferenceIDTerminalRuleCall_0_1 = (RuleCall)cAnnotationJvmAnnotationReferenceCrossReference_0.eContents().get(1);
		
		//FixedParameterName:
		//	annotation=[jvmTypes::JvmAnnotationReference];
		@Override public ParserRule getRule() { return rule; }

		//annotation=[jvmTypes::JvmAnnotationReference]
		public Assignment getAnnotationAssignment() { return cAnnotationAssignment; }

		//[jvmTypes::JvmAnnotationReference]
		public CrossReference getAnnotationJvmAnnotationReferenceCrossReference_0() { return cAnnotationJvmAnnotationReferenceCrossReference_0; }

		//ID
		public RuleCall getAnnotationJvmAnnotationReferenceIDTerminalRuleCall_0_1() { return cAnnotationJvmAnnotationReferenceIDTerminalRuleCall_0_1; }
	}

	public class ArbitraryParameterOrResultNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ArbitraryParameterOrResultName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPlusSignKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cIdentifierAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cIdentifierIDTerminalRuleCall_1_0_0 = (RuleCall)cIdentifierAssignment_1_0.eContents().get(0);
		private final Assignment cStringIdentifierAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cStringIdentifierSTRINGTerminalRuleCall_1_1_0 = (RuleCall)cStringIdentifierAssignment_1_1.eContents().get(0);
		
		//ArbitraryParameterOrResultName:
		//	'+' (identifier=ID | stringIdentifier=STRING);
		@Override public ParserRule getRule() { return rule; }

		//'+' (identifier=ID | stringIdentifier=STRING)
		public Group getGroup() { return cGroup; }

		//'+'
		public Keyword getPlusSignKeyword_0() { return cPlusSignKeyword_0; }

		//(identifier=ID | stringIdentifier=STRING)
		public Alternatives getAlternatives_1() { return cAlternatives_1; }

		//identifier=ID
		public Assignment getIdentifierAssignment_1_0() { return cIdentifierAssignment_1_0; }

		//ID
		public RuleCall getIdentifierIDTerminalRuleCall_1_0_0() { return cIdentifierIDTerminalRuleCall_1_0_0; }

		//stringIdentifier=STRING
		public Assignment getStringIdentifierAssignment_1_1() { return cStringIdentifierAssignment_1_1; }

		//STRING
		public RuleCall getStringIdentifierSTRINGTerminalRuleCall_1_1_0() { return cStringIdentifierSTRINGTerminalRuleCall_1_1_0; }
	}

	public class OperationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Operation");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cStandardOperationParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cCustomOperationParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Operation:
		//	StandardOperation | CustomOperation;
		@Override public ParserRule getRule() { return rule; }

		//StandardOperation | CustomOperation
		public Alternatives getAlternatives() { return cAlternatives; }

		//StandardOperation
		public RuleCall getStandardOperationParserRuleCall_0() { return cStandardOperationParserRuleCall_0; }

		//CustomOperation
		public RuleCall getCustomOperationParserRuleCall_1() { return cCustomOperationParserRuleCall_1; }
	}

	public class StandardOperationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.StandardOperation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cFirstOperandAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cFirstOperandValueOrEnumValueOrOperationParserRuleCall_2_0 = (RuleCall)cFirstOperandAssignment_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Assignment cOperatorsAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final Alternatives cOperatorsAlternatives_4_0_0 = (Alternatives)cOperatorsAssignment_4_0.eContents().get(0);
		private final Keyword cOperatorsPlusSignKeyword_4_0_0_0 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(0);
		private final Keyword cOperatorsHyphenMinusKeyword_4_0_0_1 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(1);
		private final Keyword cOperatorsAsteriskKeyword_4_0_0_2 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(2);
		private final Keyword cOperatorsSolidusKeyword_4_0_0_3 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(3);
		private final Keyword cOperatorsPercentSignKeyword_4_0_0_4 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(4);
		private final Keyword cOperatorsFullStopFullStopKeyword_4_0_0_5 = (Keyword)cOperatorsAlternatives_4_0_0.eContents().get(5);
		private final RuleCall cNLParserRuleCall_4_1 = (RuleCall)cGroup_4.eContents().get(1);
		private final Assignment cMoreOperandsAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cMoreOperandsValueOrEnumValueOrOperationParserRuleCall_4_2_0 = (RuleCall)cMoreOperandsAssignment_4_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_4_3 = (RuleCall)cGroup_4.eContents().get(3);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//StandardOperation:
		//	'(' NL firstOperand=ValueOrEnumValueOrOperation NL (operators+=('+' | '-' | '*' | '/' | '%' | '..') NL
		//	moreOperands+=ValueOrEnumValueOrOperation NL)+ ')';
		@Override public ParserRule getRule() { return rule; }

		//'(' NL firstOperand=ValueOrEnumValueOrOperation NL (operators+=('+' | '-' | '*' | '/' | '%' | '..') NL
		//moreOperands+=ValueOrEnumValueOrOperation NL)+ ')'
		public Group getGroup() { return cGroup; }

		//'('
		public Keyword getLeftParenthesisKeyword_0() { return cLeftParenthesisKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//firstOperand=ValueOrEnumValueOrOperation
		public Assignment getFirstOperandAssignment_2() { return cFirstOperandAssignment_2; }

		//ValueOrEnumValueOrOperation
		public RuleCall getFirstOperandValueOrEnumValueOrOperationParserRuleCall_2_0() { return cFirstOperandValueOrEnumValueOrOperationParserRuleCall_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//(operators+=('+' | '-' | '*' | '/' | '%' | '..') NL moreOperands+=ValueOrEnumValueOrOperation NL)+
		public Group getGroup_4() { return cGroup_4; }

		//operators+=('+' | '-' | '*' | '/' | '%' | '..')
		public Assignment getOperatorsAssignment_4_0() { return cOperatorsAssignment_4_0; }

		//('+' | '-' | '*' | '/' | '%' | '..')
		public Alternatives getOperatorsAlternatives_4_0_0() { return cOperatorsAlternatives_4_0_0; }

		//'+'
		public Keyword getOperatorsPlusSignKeyword_4_0_0_0() { return cOperatorsPlusSignKeyword_4_0_0_0; }

		//'-'
		public Keyword getOperatorsHyphenMinusKeyword_4_0_0_1() { return cOperatorsHyphenMinusKeyword_4_0_0_1; }

		//'*'
		public Keyword getOperatorsAsteriskKeyword_4_0_0_2() { return cOperatorsAsteriskKeyword_4_0_0_2; }

		//'/'
		public Keyword getOperatorsSolidusKeyword_4_0_0_3() { return cOperatorsSolidusKeyword_4_0_0_3; }

		//'%'
		public Keyword getOperatorsPercentSignKeyword_4_0_0_4() { return cOperatorsPercentSignKeyword_4_0_0_4; }

		//'..'
		public Keyword getOperatorsFullStopFullStopKeyword_4_0_0_5() { return cOperatorsFullStopFullStopKeyword_4_0_0_5; }

		//NL
		public RuleCall getNLParserRuleCall_4_1() { return cNLParserRuleCall_4_1; }

		//moreOperands+=ValueOrEnumValueOrOperation
		public Assignment getMoreOperandsAssignment_4_2() { return cMoreOperandsAssignment_4_2; }

		//ValueOrEnumValueOrOperation
		public RuleCall getMoreOperandsValueOrEnumValueOrOperationParserRuleCall_4_2_0() { return cMoreOperandsValueOrEnumValueOrOperationParserRuleCall_4_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_4_3() { return cNLParserRuleCall_4_3; }

		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}

	public class CustomOperationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.CustomOperation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cPrefixOperandAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cPrefixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_2_0_0 = (RuleCall)cPrefixOperandAssignment_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Assignment cDefinitionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cDefinitionOperationDefinitionCrossReference_3_0 = (CrossReference)cDefinitionAssignment_3.eContents().get(0);
		private final RuleCall cDefinitionOperationDefinitionQualifiedNameParserRuleCall_3_0_1 = (RuleCall)cDefinitionOperationDefinitionCrossReference_3_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final RuleCall cNLParserRuleCall_4_0 = (RuleCall)cGroup_4.eContents().get(0);
		private final Keyword cWithKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cPostfixOperandAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cPostfixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_4_2_0 = (RuleCall)cPostfixOperandAssignment_4_2.eContents().get(0);
		private final RuleCall cNLParserRuleCall_5 = (RuleCall)cGroup.eContents().get(5);
		private final Keyword cRightSquareBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//CustomOperation:
		//	'[' NL (prefixOperand=ValueOrEnumValueOrOperationCollection NL)? definition=[OperationDefinition|QualifiedName] (NL
		//	'with' postfixOperand=ValueOrEnumValueOrOperationCollection)? NL ']';
		@Override public ParserRule getRule() { return rule; }

		//'[' NL (prefixOperand=ValueOrEnumValueOrOperationCollection NL)? definition=[OperationDefinition|QualifiedName] (NL
		//'with' postfixOperand=ValueOrEnumValueOrOperationCollection)? NL ']'
		public Group getGroup() { return cGroup; }

		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(prefixOperand=ValueOrEnumValueOrOperationCollection NL)?
		public Group getGroup_2() { return cGroup_2; }

		//prefixOperand=ValueOrEnumValueOrOperationCollection
		public Assignment getPrefixOperandAssignment_2_0() { return cPrefixOperandAssignment_2_0; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getPrefixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_2_0_0() { return cPrefixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1() { return cNLParserRuleCall_2_1; }

		//definition=[OperationDefinition|QualifiedName]
		public Assignment getDefinitionAssignment_3() { return cDefinitionAssignment_3; }

		//[OperationDefinition|QualifiedName]
		public CrossReference getDefinitionOperationDefinitionCrossReference_3_0() { return cDefinitionOperationDefinitionCrossReference_3_0; }

		//QualifiedName
		public RuleCall getDefinitionOperationDefinitionQualifiedNameParserRuleCall_3_0_1() { return cDefinitionOperationDefinitionQualifiedNameParserRuleCall_3_0_1; }

		//(NL 'with' postfixOperand=ValueOrEnumValueOrOperationCollection)?
		public Group getGroup_4() { return cGroup_4; }

		//NL
		public RuleCall getNLParserRuleCall_4_0() { return cNLParserRuleCall_4_0; }

		//'with'
		public Keyword getWithKeyword_4_1() { return cWithKeyword_4_1; }

		//postfixOperand=ValueOrEnumValueOrOperationCollection
		public Assignment getPostfixOperandAssignment_4_2() { return cPostfixOperandAssignment_4_2; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getPostfixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_4_2_0() { return cPostfixOperandValueOrEnumValueOrOperationCollectionParserRuleCall_4_2_0; }

		//NL
		public RuleCall getNLParserRuleCall_5() { return cNLParserRuleCall_5; }

		//']'
		public Keyword getRightSquareBracketKeyword_6() { return cRightSquareBracketKeyword_6; }
	}

	public class ValueOrEnumValueOrOperationCollectionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ValueOrEnumValueOrOperationCollection");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cValueValueOrEnumValueOrOperationParserRuleCall_0_0 = (RuleCall)cValueAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1_0 = (RuleCall)cGroup_1.eContents().get(0);
		private final Keyword cCommaKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final RuleCall cNLParserRuleCall_1_2 = (RuleCall)cGroup_1.eContents().get(2);
		private final Assignment cMoreValuesAssignment_1_3 = (Assignment)cGroup_1.eContents().get(3);
		private final RuleCall cMoreValuesValueOrEnumValueOrOperationParserRuleCall_1_3_0 = (RuleCall)cMoreValuesAssignment_1_3.eContents().get(0);
		
		//ValueOrEnumValueOrOperationCollection:
		//	value=ValueOrEnumValueOrOperation (NL ',' NL moreValues+=ValueOrEnumValueOrOperation)*;
		@Override public ParserRule getRule() { return rule; }

		//value=ValueOrEnumValueOrOperation (NL ',' NL moreValues+=ValueOrEnumValueOrOperation)*
		public Group getGroup() { return cGroup; }

		//value=ValueOrEnumValueOrOperation
		public Assignment getValueAssignment_0() { return cValueAssignment_0; }

		//ValueOrEnumValueOrOperation
		public RuleCall getValueValueOrEnumValueOrOperationParserRuleCall_0_0() { return cValueValueOrEnumValueOrOperationParserRuleCall_0_0; }

		//(NL ',' NL moreValues+=ValueOrEnumValueOrOperation)*
		public Group getGroup_1() { return cGroup_1; }

		//NL
		public RuleCall getNLParserRuleCall_1_0() { return cNLParserRuleCall_1_0; }

		//','
		public Keyword getCommaKeyword_1_1() { return cCommaKeyword_1_1; }

		//NL
		public RuleCall getNLParserRuleCall_1_2() { return cNLParserRuleCall_1_2; }

		//moreValues+=ValueOrEnumValueOrOperation
		public Assignment getMoreValuesAssignment_1_3() { return cMoreValuesAssignment_1_3; }

		//ValueOrEnumValueOrOperation
		public RuleCall getMoreValuesValueOrEnumValueOrOperationParserRuleCall_1_3_0() { return cMoreValuesValueOrEnumValueOrOperationParserRuleCall_1_3_0; }
	}

	public class ValueOrEnumValueOrOperationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ValueOrEnumValueOrOperation");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEnumValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cOperationParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//ValueOrEnumValueOrOperation:
		//	Value | EnumValue | Operation;
		@Override public ParserRule getRule() { return rule; }

		//Value | EnumValue | Operation
		public Alternatives getAlternatives() { return cAlternatives; }

		//Value
		public RuleCall getValueParserRuleCall_0() { return cValueParserRuleCall_0; }

		//EnumValue
		public RuleCall getEnumValueParserRuleCall_1() { return cEnumValueParserRuleCall_1; }

		//Operation
		public RuleCall getOperationParserRuleCall_2() { return cOperationParserRuleCall_2; }
	}

	public class ValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Value");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cStaticValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVariableParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cNestedObjectParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cTypedNestedObjectParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//Value:
		//	StaticValue | Variable | NestedObject | TypedNestedObject;
		@Override public ParserRule getRule() { return rule; }

		//StaticValue | Variable | NestedObject | TypedNestedObject
		public Alternatives getAlternatives() { return cAlternatives; }

		//StaticValue
		public RuleCall getStaticValueParserRuleCall_0() { return cStaticValueParserRuleCall_0; }

		//Variable
		public RuleCall getVariableParserRuleCall_1() { return cVariableParserRuleCall_1; }

		//NestedObject
		public RuleCall getNestedObjectParserRuleCall_2() { return cNestedObjectParserRuleCall_2; }

		//TypedNestedObject
		public RuleCall getTypedNestedObjectParserRuleCall_3() { return cTypedNestedObjectParserRuleCall_3; }
	}

	public class ConstantValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ConstantValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cStaticValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cConstantParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ConstantValue:
		//	StaticValue | Constant;
		@Override public ParserRule getRule() { return rule; }

		//StaticValue | Constant
		public Alternatives getAlternatives() { return cAlternatives; }

		//StaticValue
		public RuleCall getStaticValueParserRuleCall_0() { return cStaticValueParserRuleCall_0; }

		//Constant
		public RuleCall getConstantParserRuleCall_1() { return cConstantParserRuleCall_1; }
	}

	public class StaticValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.StaticValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cStringValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cRegexValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cIntegerValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cDecimalValueParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cBooleanValueParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cDateValueParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		private final RuleCall cTimeValueParserRuleCall_6 = (RuleCall)cAlternatives.eContents().get(6);
		private final RuleCall cDateAndTimeValueParserRuleCall_7 = (RuleCall)cAlternatives.eContents().get(7);
		private final RuleCall cNullValueParserRuleCall_8 = (RuleCall)cAlternatives.eContents().get(8);
		private final RuleCall cInexistentValueParserRuleCall_9 = (RuleCall)cAlternatives.eContents().get(9);
		private final RuleCall cEmptyValueParserRuleCall_10 = (RuleCall)cAlternatives.eContents().get(10);
		private final RuleCall cJavaConstantValueParserRuleCall_11 = (RuleCall)cAlternatives.eContents().get(11);
		
		//StaticValue:
		//	StringValue | RegexValue | IntegerValue | DecimalValue | BooleanValue | DateValue | TimeValue | DateAndTimeValue |
		//	NullValue | InexistentValue | EmptyValue | JavaConstantValue;
		@Override public ParserRule getRule() { return rule; }

		//StringValue | RegexValue | IntegerValue | DecimalValue | BooleanValue | DateValue | TimeValue | DateAndTimeValue |
		//NullValue | InexistentValue | EmptyValue | JavaConstantValue
		public Alternatives getAlternatives() { return cAlternatives; }

		//StringValue
		public RuleCall getStringValueParserRuleCall_0() { return cStringValueParserRuleCall_0; }

		//RegexValue
		public RuleCall getRegexValueParserRuleCall_1() { return cRegexValueParserRuleCall_1; }

		//IntegerValue
		public RuleCall getIntegerValueParserRuleCall_2() { return cIntegerValueParserRuleCall_2; }

		//DecimalValue
		public RuleCall getDecimalValueParserRuleCall_3() { return cDecimalValueParserRuleCall_3; }

		//BooleanValue
		public RuleCall getBooleanValueParserRuleCall_4() { return cBooleanValueParserRuleCall_4; }

		//DateValue
		public RuleCall getDateValueParserRuleCall_5() { return cDateValueParserRuleCall_5; }

		//TimeValue
		public RuleCall getTimeValueParserRuleCall_6() { return cTimeValueParserRuleCall_6; }

		//DateAndTimeValue
		public RuleCall getDateAndTimeValueParserRuleCall_7() { return cDateAndTimeValueParserRuleCall_7; }

		//NullValue
		public RuleCall getNullValueParserRuleCall_8() { return cNullValueParserRuleCall_8; }

		//InexistentValue
		public RuleCall getInexistentValueParserRuleCall_9() { return cInexistentValueParserRuleCall_9; }

		//EmptyValue
		public RuleCall getEmptyValueParserRuleCall_10() { return cEmptyValueParserRuleCall_10; }

		//JavaConstantValue
		public RuleCall getJavaConstantValueParserRuleCall_11() { return cJavaConstantValueParserRuleCall_11; }
	}

	public class IntegerValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.IntegerValue");
		private final Assignment cIntegerValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cIntegerValueINTEGERTerminalRuleCall_0 = (RuleCall)cIntegerValueAssignment.eContents().get(0);
		
		//IntegerValue:
		//	integerValue=INTEGER;
		@Override public ParserRule getRule() { return rule; }

		//integerValue=INTEGER
		public Assignment getIntegerValueAssignment() { return cIntegerValueAssignment; }

		//INTEGER
		public RuleCall getIntegerValueINTEGERTerminalRuleCall_0() { return cIntegerValueINTEGERTerminalRuleCall_0; }
	}

	public class DecimalValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DecimalValue");
		private final Assignment cDecimalValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cDecimalValueDECIMALTerminalRuleCall_0 = (RuleCall)cDecimalValueAssignment.eContents().get(0);
		
		//DecimalValue:
		//	decimalValue=DECIMAL;
		@Override public ParserRule getRule() { return rule; }

		//decimalValue=DECIMAL
		public Assignment getDecimalValueAssignment() { return cDecimalValueAssignment; }

		//DECIMAL
		public RuleCall getDecimalValueDECIMALTerminalRuleCall_0() { return cDecimalValueDECIMALTerminalRuleCall_0; }
	}

	public class StringValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.StringValue");
		private final Assignment cStringValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cStringValueSTRINGTerminalRuleCall_0 = (RuleCall)cStringValueAssignment.eContents().get(0);
		
		//StringValue:
		//	stringValue=STRING;
		@Override public ParserRule getRule() { return rule; }

		//stringValue=STRING
		public Assignment getStringValueAssignment() { return cStringValueAssignment; }

		//STRING
		public RuleCall getStringValueSTRINGTerminalRuleCall_0() { return cStringValueSTRINGTerminalRuleCall_0; }
	}

	public class RegexValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.RegexValue");
		private final Assignment cRegexValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cRegexValueREGEXTerminalRuleCall_0 = (RuleCall)cRegexValueAssignment.eContents().get(0);
		
		//RegexValue:
		//	regexValue=REGEX;
		@Override public ParserRule getRule() { return rule; }

		//regexValue=REGEX
		public Assignment getRegexValueAssignment() { return cRegexValueAssignment; }

		//REGEX
		public RuleCall getRegexValueREGEXTerminalRuleCall_0() { return cRegexValueREGEXTerminalRuleCall_0; }
	}

	public class BooleanValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.BooleanValue");
		private final Assignment cBooleanValueAssignment = (Assignment)rule.eContents().get(1);
		private final Alternatives cBooleanValueAlternatives_0 = (Alternatives)cBooleanValueAssignment.eContents().get(0);
		private final RuleCall cBooleanValueBOOLEAN_TRUETerminalRuleCall_0_0 = (RuleCall)cBooleanValueAlternatives_0.eContents().get(0);
		private final RuleCall cBooleanValueBOOLEAN_FALSETerminalRuleCall_0_1 = (RuleCall)cBooleanValueAlternatives_0.eContents().get(1);
		
		//BooleanValue:
		//	booleanValue=(BOOLEAN_TRUE | BOOLEAN_FALSE);
		@Override public ParserRule getRule() { return rule; }

		//booleanValue=(BOOLEAN_TRUE | BOOLEAN_FALSE)
		public Assignment getBooleanValueAssignment() { return cBooleanValueAssignment; }

		//(BOOLEAN_TRUE | BOOLEAN_FALSE)
		public Alternatives getBooleanValueAlternatives_0() { return cBooleanValueAlternatives_0; }

		//BOOLEAN_TRUE
		public RuleCall getBooleanValueBOOLEAN_TRUETerminalRuleCall_0_0() { return cBooleanValueBOOLEAN_TRUETerminalRuleCall_0_0; }

		//BOOLEAN_FALSE
		public RuleCall getBooleanValueBOOLEAN_FALSETerminalRuleCall_0_1() { return cBooleanValueBOOLEAN_FALSETerminalRuleCall_0_1; }
	}

	public class DateValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DateValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIsoDateValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEuropeanDateValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cUSDateValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//DateValue:
		//	IsoDateValue | EuropeanDateValue | USDateValue;
		@Override public ParserRule getRule() { return rule; }

		//IsoDateValue | EuropeanDateValue | USDateValue
		public Alternatives getAlternatives() { return cAlternatives; }

		//IsoDateValue
		public RuleCall getIsoDateValueParserRuleCall_0() { return cIsoDateValueParserRuleCall_0; }

		//EuropeanDateValue
		public RuleCall getEuropeanDateValueParserRuleCall_1() { return cEuropeanDateValueParserRuleCall_1; }

		//USDateValue
		public RuleCall getUSDateValueParserRuleCall_2() { return cUSDateValueParserRuleCall_2; }
	}

	public class IsoDateValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.IsoDateValue");
		private final Assignment cDateValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cDateValueISODATETerminalRuleCall_0 = (RuleCall)cDateValueAssignment.eContents().get(0);
		
		//IsoDateValue:
		//	dateValue=ISODATE;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=ISODATE
		public Assignment getDateValueAssignment() { return cDateValueAssignment; }

		//ISODATE
		public RuleCall getDateValueISODATETerminalRuleCall_0() { return cDateValueISODATETerminalRuleCall_0; }
	}

	public class EuropeanDateValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EuropeanDateValue");
		private final Assignment cDateValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cDateValueEURODATETerminalRuleCall_0 = (RuleCall)cDateValueAssignment.eContents().get(0);
		
		//EuropeanDateValue:
		//	dateValue=EURODATE;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=EURODATE
		public Assignment getDateValueAssignment() { return cDateValueAssignment; }

		//EURODATE
		public RuleCall getDateValueEURODATETerminalRuleCall_0() { return cDateValueEURODATETerminalRuleCall_0; }
	}

	public class USDateValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.USDateValue");
		private final Assignment cDateValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cDateValueUSDATETerminalRuleCall_0 = (RuleCall)cDateValueAssignment.eContents().get(0);
		
		//USDateValue:
		//	dateValue=USDATE;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=USDATE
		public Assignment getDateValueAssignment() { return cDateValueAssignment; }

		//USDATE
		public RuleCall getDateValueUSDATETerminalRuleCall_0() { return cDateValueUSDATETerminalRuleCall_0; }
	}

	public class TimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TimeValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIsoTimeValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cSimple24HrsTimeValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSimple12HrsTimeValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//TimeValue:
		//	IsoTimeValue | Simple24HrsTimeValue | Simple12HrsTimeValue;
		@Override public ParserRule getRule() { return rule; }

		//IsoTimeValue | Simple24HrsTimeValue | Simple12HrsTimeValue
		public Alternatives getAlternatives() { return cAlternatives; }

		//IsoTimeValue
		public RuleCall getIsoTimeValueParserRuleCall_0() { return cIsoTimeValueParserRuleCall_0; }

		//Simple24HrsTimeValue
		public RuleCall getSimple24HrsTimeValueParserRuleCall_1() { return cSimple24HrsTimeValueParserRuleCall_1; }

		//Simple12HrsTimeValue
		public RuleCall getSimple12HrsTimeValueParserRuleCall_2() { return cSimple12HrsTimeValueParserRuleCall_2; }
	}

	public class IsoTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.IsoTimeValue");
		private final Assignment cTimeValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cTimeValueISOTIMETerminalRuleCall_0 = (RuleCall)cTimeValueAssignment.eContents().get(0);
		
		//IsoTimeValue:
		//	timeValue=ISOTIME;
		@Override public ParserRule getRule() { return rule; }

		//timeValue=ISOTIME
		public Assignment getTimeValueAssignment() { return cTimeValueAssignment; }

		//ISOTIME
		public RuleCall getTimeValueISOTIMETerminalRuleCall_0() { return cTimeValueISOTIMETerminalRuleCall_0; }
	}

	public class Simple24HrsTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Simple24HrsTimeValue");
		private final Assignment cTimeValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cTimeValueTWENTYFOURHRSTIMETerminalRuleCall_0 = (RuleCall)cTimeValueAssignment.eContents().get(0);
		
		//Simple24HrsTimeValue:
		//	timeValue=TWENTYFOURHRSTIME;
		@Override public ParserRule getRule() { return rule; }

		//timeValue=TWENTYFOURHRSTIME
		public Assignment getTimeValueAssignment() { return cTimeValueAssignment; }

		//TWENTYFOURHRSTIME
		public RuleCall getTimeValueTWENTYFOURHRSTIMETerminalRuleCall_0() { return cTimeValueTWENTYFOURHRSTIMETerminalRuleCall_0; }
	}

	public class Simple12HrsTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Simple12HrsTimeValue");
		private final Assignment cTimeValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cTimeValueTWELVEHRSTIMETerminalRuleCall_0 = (RuleCall)cTimeValueAssignment.eContents().get(0);
		
		//Simple12HrsTimeValue:
		//	timeValue=TWELVEHRSTIME;
		@Override public ParserRule getRule() { return rule; }

		//timeValue=TWELVEHRSTIME
		public Assignment getTimeValueAssignment() { return cTimeValueAssignment; }

		//TWELVEHRSTIME
		public RuleCall getTimeValueTWELVEHRSTIMETerminalRuleCall_0() { return cTimeValueTWELVEHRSTIMETerminalRuleCall_0; }
	}

	public class DateAndTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DateAndTimeValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cIsoDateAndTimeValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEuropeanDateAnd24HrsTimeValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cEuropeanDateAnd12HrsTimeValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cUSDateAnd12HrsTimeValueParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//DateAndTimeValue:
		//	IsoDateAndTimeValue | EuropeanDateAnd24HrsTimeValue | EuropeanDateAnd12HrsTimeValue | USDateAnd12HrsTimeValue;
		@Override public ParserRule getRule() { return rule; }

		//IsoDateAndTimeValue | EuropeanDateAnd24HrsTimeValue | EuropeanDateAnd12HrsTimeValue | USDateAnd12HrsTimeValue
		public Alternatives getAlternatives() { return cAlternatives; }

		//IsoDateAndTimeValue
		public RuleCall getIsoDateAndTimeValueParserRuleCall_0() { return cIsoDateAndTimeValueParserRuleCall_0; }

		//EuropeanDateAnd24HrsTimeValue
		public RuleCall getEuropeanDateAnd24HrsTimeValueParserRuleCall_1() { return cEuropeanDateAnd24HrsTimeValueParserRuleCall_1; }

		//EuropeanDateAnd12HrsTimeValue
		public RuleCall getEuropeanDateAnd12HrsTimeValueParserRuleCall_2() { return cEuropeanDateAnd12HrsTimeValueParserRuleCall_2; }

		//USDateAnd12HrsTimeValue
		public RuleCall getUSDateAnd12HrsTimeValueParserRuleCall_3() { return cUSDateAnd12HrsTimeValueParserRuleCall_3; }
	}

	public class IsoDateAndTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.IsoDateAndTimeValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDateValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDateValueISODATETerminalRuleCall_0_0 = (RuleCall)cDateValueAssignment_0.eContents().get(0);
		private final Assignment cTimeValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTimeValueISOTIMETerminalRuleCall_1_0 = (RuleCall)cTimeValueAssignment_1.eContents().get(0);
		
		//IsoDateAndTimeValue:
		//	dateValue=ISODATE timeValue=ISOTIME;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=ISODATE timeValue=ISOTIME
		public Group getGroup() { return cGroup; }

		//dateValue=ISODATE
		public Assignment getDateValueAssignment_0() { return cDateValueAssignment_0; }

		//ISODATE
		public RuleCall getDateValueISODATETerminalRuleCall_0_0() { return cDateValueISODATETerminalRuleCall_0_0; }

		//timeValue=ISOTIME
		public Assignment getTimeValueAssignment_1() { return cTimeValueAssignment_1; }

		//ISOTIME
		public RuleCall getTimeValueISOTIMETerminalRuleCall_1_0() { return cTimeValueISOTIMETerminalRuleCall_1_0; }
	}

	public class EuropeanDateAnd24HrsTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EuropeanDateAnd24HrsTimeValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDateValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDateValueEURODATETerminalRuleCall_0_0 = (RuleCall)cDateValueAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cTimeValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTimeValueTWENTYFOURHRSTIMETerminalRuleCall_2_0 = (RuleCall)cTimeValueAssignment_2.eContents().get(0);
		
		//EuropeanDateAnd24HrsTimeValue:
		//	dateValue=EURODATE NL timeValue=TWENTYFOURHRSTIME;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=EURODATE NL timeValue=TWENTYFOURHRSTIME
		public Group getGroup() { return cGroup; }

		//dateValue=EURODATE
		public Assignment getDateValueAssignment_0() { return cDateValueAssignment_0; }

		//EURODATE
		public RuleCall getDateValueEURODATETerminalRuleCall_0_0() { return cDateValueEURODATETerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//timeValue=TWENTYFOURHRSTIME
		public Assignment getTimeValueAssignment_2() { return cTimeValueAssignment_2; }

		//TWENTYFOURHRSTIME
		public RuleCall getTimeValueTWENTYFOURHRSTIMETerminalRuleCall_2_0() { return cTimeValueTWENTYFOURHRSTIMETerminalRuleCall_2_0; }
	}

	public class EuropeanDateAnd12HrsTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EuropeanDateAnd12HrsTimeValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDateValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDateValueEURODATETerminalRuleCall_0_0 = (RuleCall)cDateValueAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cTimeValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTimeValueTWELVEHRSTIMETerminalRuleCall_2_0 = (RuleCall)cTimeValueAssignment_2.eContents().get(0);
		
		//EuropeanDateAnd12HrsTimeValue:
		//	dateValue=EURODATE NL timeValue=TWELVEHRSTIME;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=EURODATE NL timeValue=TWELVEHRSTIME
		public Group getGroup() { return cGroup; }

		//dateValue=EURODATE
		public Assignment getDateValueAssignment_0() { return cDateValueAssignment_0; }

		//EURODATE
		public RuleCall getDateValueEURODATETerminalRuleCall_0_0() { return cDateValueEURODATETerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//timeValue=TWELVEHRSTIME
		public Assignment getTimeValueAssignment_2() { return cTimeValueAssignment_2; }

		//TWELVEHRSTIME
		public RuleCall getTimeValueTWELVEHRSTIMETerminalRuleCall_2_0() { return cTimeValueTWELVEHRSTIMETerminalRuleCall_2_0; }
	}

	public class USDateAnd12HrsTimeValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.USDateAnd12HrsTimeValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDateValueAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDateValueUSDATETerminalRuleCall_0_0 = (RuleCall)cDateValueAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Assignment cTimeValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTimeValueTWELVEHRSTIMETerminalRuleCall_2_0 = (RuleCall)cTimeValueAssignment_2.eContents().get(0);
		
		//USDateAnd12HrsTimeValue:
		//	dateValue=USDATE NL timeValue=TWELVEHRSTIME;
		@Override public ParserRule getRule() { return rule; }

		//dateValue=USDATE NL timeValue=TWELVEHRSTIME
		public Group getGroup() { return cGroup; }

		//dateValue=USDATE
		public Assignment getDateValueAssignment_0() { return cDateValueAssignment_0; }

		//USDATE
		public RuleCall getDateValueUSDATETerminalRuleCall_0_0() { return cDateValueUSDATETerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//timeValue=TWELVEHRSTIME
		public Assignment getTimeValueAssignment_2() { return cTimeValueAssignment_2; }

		//TWELVEHRSTIME
		public RuleCall getTimeValueTWELVEHRSTIMETerminalRuleCall_2_0() { return cTimeValueTWELVEHRSTIMETerminalRuleCall_2_0; }
	}

	public class JavaConstantValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.JavaConstantValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLessThanSignKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cConstantAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cConstantJavaConstantReferenceParserRuleCall_1_0 = (RuleCall)cConstantAssignment_1.eContents().get(0);
		private final Keyword cGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//JavaConstantValue:
		//	'<' constant=JavaConstantReference '>';
		@Override public ParserRule getRule() { return rule; }

		//'<' constant=JavaConstantReference '>'
		public Group getGroup() { return cGroup; }

		//'<'
		public Keyword getLessThanSignKeyword_0() { return cLessThanSignKeyword_0; }

		//constant=JavaConstantReference
		public Assignment getConstantAssignment_1() { return cConstantAssignment_1; }

		//JavaConstantReference
		public RuleCall getConstantJavaConstantReferenceParserRuleCall_1_0() { return cConstantJavaConstantReferenceParserRuleCall_1_0; }

		//'>'
		public Keyword getGreaterThanSignKeyword_2() { return cGreaterThanSignKeyword_2; }
	}

	public class VariableElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Variable");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cNameVariableOrConstantEntityCrossReference_0_0 = (CrossReference)cNameAssignment_0.eContents().get(0);
		private final RuleCall cNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1 = (RuleCall)cNameVariableOrConstantEntityCrossReference_0_0.eContents().get(1);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cNumberSignKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cAttributeAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cAttributeQualifiedNameParserRuleCall_1_1_0 = (RuleCall)cAttributeAssignment_1_1.eContents().get(0);
		
		//Variable:
		//	name=[VariableOrConstantEntity|QualifiedName] ('#' attribute=QualifiedName)?;
		@Override public ParserRule getRule() { return rule; }

		//name=[VariableOrConstantEntity|QualifiedName] ('#' attribute=QualifiedName)?
		public Group getGroup() { return cGroup; }

		//name=[VariableOrConstantEntity|QualifiedName]
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//[VariableOrConstantEntity|QualifiedName]
		public CrossReference getNameVariableOrConstantEntityCrossReference_0_0() { return cNameVariableOrConstantEntityCrossReference_0_0; }

		//QualifiedName
		public RuleCall getNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1() { return cNameVariableOrConstantEntityQualifiedNameParserRuleCall_0_0_1; }

		//('#' attribute=QualifiedName)?
		public Group getGroup_1() { return cGroup_1; }

		//'#'
		public Keyword getNumberSignKeyword_1_0() { return cNumberSignKeyword_1_0; }

		//attribute=QualifiedName
		public Assignment getAttributeAssignment_1_1() { return cAttributeAssignment_1_1; }

		//QualifiedName
		public RuleCall getAttributeQualifiedNameParserRuleCall_1_1_0() { return cAttributeQualifiedNameParserRuleCall_1_1_0; }
	}

	public class VariableVariableElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.VariableVariable");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cNameVariableEntityCrossReference_0 = (CrossReference)cNameAssignment.eContents().get(0);
		private final RuleCall cNameVariableEntityQualifiedNameParserRuleCall_0_1 = (RuleCall)cNameVariableEntityCrossReference_0.eContents().get(1);
		
		//VariableVariable:
		//	name=[VariableEntity|QualifiedName];
		@Override public ParserRule getRule() { return rule; }

		//name=[VariableEntity|QualifiedName]
		public Assignment getNameAssignment() { return cNameAssignment; }

		//[VariableEntity|QualifiedName]
		public CrossReference getNameVariableEntityCrossReference_0() { return cNameVariableEntityCrossReference_0; }

		//QualifiedName
		public RuleCall getNameVariableEntityQualifiedNameParserRuleCall_0_1() { return cNameVariableEntityQualifiedNameParserRuleCall_0_1; }
	}

	public class ConstantElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.Constant");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cNameConstantEntityCrossReference_0 = (CrossReference)cNameAssignment.eContents().get(0);
		private final RuleCall cNameConstantEntityQualifiedNameParserRuleCall_0_1 = (RuleCall)cNameConstantEntityCrossReference_0.eContents().get(1);
		
		//Constant:
		//	name=[ConstantEntity|QualifiedName];
		@Override public ParserRule getRule() { return rule; }

		//name=[ConstantEntity|QualifiedName]
		public Assignment getNameAssignment() { return cNameAssignment; }

		//[ConstantEntity|QualifiedName]
		public CrossReference getNameConstantEntityCrossReference_0() { return cNameConstantEntityCrossReference_0; }

		//QualifiedName
		public RuleCall getNameConstantEntityQualifiedNameParserRuleCall_0_1() { return cNameConstantEntityQualifiedNameParserRuleCall_0_1; }
	}

	public class NullValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NullValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cNullAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cNullKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//NullValue:
		//	{Null} 'null';
		@Override public ParserRule getRule() { return rule; }

		//{Null} 'null'
		public Group getGroup() { return cGroup; }

		//{Null}
		public Action getNullAction_0() { return cNullAction_0; }

		//'null'
		public Keyword getNullKeyword_1() { return cNullKeyword_1; }
	}

	public class InexistentValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.InexistentValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cInexistentAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cInexistentKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//InexistentValue:
		//	{Inexistent} 'inexistent';
		@Override public ParserRule getRule() { return rule; }

		//{Inexistent} 'inexistent'
		public Group getGroup() { return cGroup; }

		//{Inexistent}
		public Action getInexistentAction_0() { return cInexistentAction_0; }

		//'inexistent'
		public Keyword getInexistentKeyword_1() { return cInexistentKeyword_1; }
	}

	public class EmptyValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EmptyValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cEmptyAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cEmptyKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//EmptyValue:
		//	{Empty} 'empty';
		@Override public ParserRule getRule() { return rule; }

		//{Empty} 'empty'
		public Group getGroup() { return cGroup; }

		//{Empty}
		public Action getEmptyAction_0() { return cEmptyAction_0; }

		//'empty'
		public Keyword getEmptyKeyword_1() { return cEmptyKeyword_1; }
	}

	public class EnumValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EnumValue");
		private final Assignment cEnumValueAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cEnumValueJvmEnumerationLiteralCrossReference_0 = (CrossReference)cEnumValueAssignment.eContents().get(0);
		private final RuleCall cEnumValueJvmEnumerationLiteralUPPERCASE_IDTerminalRuleCall_0_1 = (RuleCall)cEnumValueJvmEnumerationLiteralCrossReference_0.eContents().get(1);
		
		//EnumValue:
		//	enumValue=[jvmTypes::JvmEnumerationLiteral|UPPERCASE_ID];
		@Override public ParserRule getRule() { return rule; }

		//enumValue=[jvmTypes::JvmEnumerationLiteral|UPPERCASE_ID]
		public Assignment getEnumValueAssignment() { return cEnumValueAssignment; }

		//[jvmTypes::JvmEnumerationLiteral|UPPERCASE_ID]
		public CrossReference getEnumValueJvmEnumerationLiteralCrossReference_0() { return cEnumValueJvmEnumerationLiteralCrossReference_0; }

		//UPPERCASE_ID
		public RuleCall getEnumValueJvmEnumerationLiteralUPPERCASE_IDTerminalRuleCall_0_1() { return cEnumValueJvmEnumerationLiteralUPPERCASE_IDTerminalRuleCall_0_1; }
	}

	public class NestedObjectElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NestedObject");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Assignment cAttributesAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cAttributesKeyValuePairParserRuleCall_2_0_0 = (RuleCall)cAttributesAssignment_2_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Keyword cRightCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//NestedObject:
		//	'{' NL (attributes+=KeyValuePair NL)+ '}';
		@Override public ParserRule getRule() { return rule; }

		//'{' NL (attributes+=KeyValuePair NL)+ '}'
		public Group getGroup() { return cGroup; }

		//'{'
		public Keyword getLeftCurlyBracketKeyword_0() { return cLeftCurlyBracketKeyword_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//(attributes+=KeyValuePair NL)+
		public Group getGroup_2() { return cGroup_2; }

		//attributes+=KeyValuePair
		public Assignment getAttributesAssignment_2_0() { return cAttributesAssignment_2_0; }

		//KeyValuePair
		public RuleCall getAttributesKeyValuePairParserRuleCall_2_0_0() { return cAttributesKeyValuePairParserRuleCall_2_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_2_1() { return cNLParserRuleCall_2_1; }

		//'}'
		public Keyword getRightCurlyBracketKeyword_3() { return cRightCurlyBracketKeyword_3; }
	}

	public class TypedNestedObjectElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TypedNestedObject");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLessThanSignKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cTypeAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTypeJavaClassReferenceParserRuleCall_1_0 = (RuleCall)cTypeAssignment_1.eContents().get(0);
		private final Keyword cGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cNestedObjectAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cNestedObjectNestedObjectParserRuleCall_4_0 = (RuleCall)cNestedObjectAssignment_4.eContents().get(0);
		
		//TypedNestedObject:
		//	'<' type=JavaClassReference '>' NL nestedObject=NestedObject;
		@Override public ParserRule getRule() { return rule; }

		//'<' type=JavaClassReference '>' NL nestedObject=NestedObject
		public Group getGroup() { return cGroup; }

		//'<'
		public Keyword getLessThanSignKeyword_0() { return cLessThanSignKeyword_0; }

		//type=JavaClassReference
		public Assignment getTypeAssignment_1() { return cTypeAssignment_1; }

		//JavaClassReference
		public RuleCall getTypeJavaClassReferenceParserRuleCall_1_0() { return cTypeJavaClassReferenceParserRuleCall_1_0; }

		//'>'
		public Keyword getGreaterThanSignKeyword_2() { return cGreaterThanSignKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//nestedObject=NestedObject
		public Assignment getNestedObjectAssignment_4() { return cNestedObjectAssignment_4; }

		//NestedObject
		public RuleCall getNestedObjectNestedObjectParserRuleCall_4_0() { return cNestedObjectNestedObjectParserRuleCall_4_0; }
	}

	public class KeyValuePairElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.KeyValuePair");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cIdentifierAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final RuleCall cIdentifierIDTerminalRuleCall_0_0_0 = (RuleCall)cIdentifierAssignment_0_0.eContents().get(0);
		private final Assignment cStringIdentifierAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final RuleCall cStringIdentifierSTRINGTerminalRuleCall_0_1_0 = (RuleCall)cStringIdentifierAssignment_0_1.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final RuleCall cNLParserRuleCall_3 = (RuleCall)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		
		//KeyValuePair:
		//	(identifier=ID | stringIdentifier=STRING) NL ':' NL value=ValueOrEnumValueOrOperationCollection;
		@Override public ParserRule getRule() { return rule; }

		//(identifier=ID | stringIdentifier=STRING) NL ':' NL value=ValueOrEnumValueOrOperationCollection
		public Group getGroup() { return cGroup; }

		//(identifier=ID | stringIdentifier=STRING)
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//identifier=ID
		public Assignment getIdentifierAssignment_0_0() { return cIdentifierAssignment_0_0; }

		//ID
		public RuleCall getIdentifierIDTerminalRuleCall_0_0_0() { return cIdentifierIDTerminalRuleCall_0_0_0; }

		//stringIdentifier=STRING
		public Assignment getStringIdentifierAssignment_0_1() { return cStringIdentifierAssignment_0_1; }

		//STRING
		public RuleCall getStringIdentifierSTRINGTerminalRuleCall_0_1_0() { return cStringIdentifierSTRINGTerminalRuleCall_0_1_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }

		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//NL
		public RuleCall getNLParserRuleCall_3() { return cNLParserRuleCall_3; }

		//value=ValueOrEnumValueOrOperationCollection
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }

		//ValueOrEnumValueOrOperationCollection
		public RuleCall getValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0() { return cValueValueOrEnumValueOrOperationCollectionParserRuleCall_4_0; }
	}

	public class JavaClassReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.JavaClassReference");
		private final Assignment cTypeAssignment = (Assignment)rule.eContents().get(1);
		private final CrossReference cTypeJvmTypeCrossReference_0 = (CrossReference)cTypeAssignment.eContents().get(0);
		private final RuleCall cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_1 = (RuleCall)cTypeJvmTypeCrossReference_0.eContents().get(1);
		
		//JavaClassReference:
		//	type=[jvmTypes::JvmType|QualifiedJavaClassName];
		@Override public ParserRule getRule() { return rule; }

		//type=[jvmTypes::JvmType|QualifiedJavaClassName]
		public Assignment getTypeAssignment() { return cTypeAssignment; }

		//[jvmTypes::JvmType|QualifiedJavaClassName]
		public CrossReference getTypeJvmTypeCrossReference_0() { return cTypeJvmTypeCrossReference_0; }

		//QualifiedJavaClassName
		public RuleCall getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_1() { return cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_1; }
	}

	public class MethodReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.MethodReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cTypeJvmTypeCrossReference_0_0 = (CrossReference)cTypeAssignment_0.eContents().get(0);
		private final RuleCall cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1 = (RuleCall)cTypeJvmTypeCrossReference_0_0.eContents().get(1);
		private final Keyword cNumberSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cMethodAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cMethodJvmOperationCrossReference_2_0 = (CrossReference)cMethodAssignment_2.eContents().get(0);
		private final RuleCall cMethodJvmOperationIDTerminalRuleCall_2_0_1 = (RuleCall)cMethodJvmOperationCrossReference_2_0.eContents().get(1);
		
		//MethodReference:
		//	type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' method=[jvmTypes::JvmOperation];
		@Override public ParserRule getRule() { return rule; }

		//type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' method=[jvmTypes::JvmOperation]
		public Group getGroup() { return cGroup; }

		//type=[jvmTypes::JvmType|QualifiedJavaClassName]
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }

		//[jvmTypes::JvmType|QualifiedJavaClassName]
		public CrossReference getTypeJvmTypeCrossReference_0_0() { return cTypeJvmTypeCrossReference_0_0; }

		//QualifiedJavaClassName
		public RuleCall getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1() { return cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1; }

		//'#'
		public Keyword getNumberSignKeyword_1() { return cNumberSignKeyword_1; }

		//method=[jvmTypes::JvmOperation]
		public Assignment getMethodAssignment_2() { return cMethodAssignment_2; }

		//[jvmTypes::JvmOperation]
		public CrossReference getMethodJvmOperationCrossReference_2_0() { return cMethodJvmOperationCrossReference_2_0; }

		//ID
		public RuleCall getMethodJvmOperationIDTerminalRuleCall_2_0_1() { return cMethodJvmOperationIDTerminalRuleCall_2_0_1; }
	}

	public class JavaConstantReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.JavaConstantReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cTypeJvmTypeCrossReference_0_0 = (CrossReference)cTypeAssignment_0.eContents().get(0);
		private final RuleCall cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1 = (RuleCall)cTypeJvmTypeCrossReference_0_0.eContents().get(1);
		private final Keyword cNumberSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cConstantAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cConstantJvmFieldCrossReference_2_0 = (CrossReference)cConstantAssignment_2.eContents().get(0);
		private final RuleCall cConstantJvmFieldUPPERCASE_IDTerminalRuleCall_2_0_1 = (RuleCall)cConstantJvmFieldCrossReference_2_0.eContents().get(1);
		
		//JavaConstantReference:
		//	type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' constant=[jvmTypes::JvmField|UPPERCASE_ID];
		@Override public ParserRule getRule() { return rule; }

		//type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' constant=[jvmTypes::JvmField|UPPERCASE_ID]
		public Group getGroup() { return cGroup; }

		//type=[jvmTypes::JvmType|QualifiedJavaClassName]
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }

		//[jvmTypes::JvmType|QualifiedJavaClassName]
		public CrossReference getTypeJvmTypeCrossReference_0_0() { return cTypeJvmTypeCrossReference_0_0; }

		//QualifiedJavaClassName
		public RuleCall getTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1() { return cTypeJvmTypeQualifiedJavaClassNameParserRuleCall_0_0_1; }

		//'#'
		public Keyword getNumberSignKeyword_1() { return cNumberSignKeyword_1; }

		//constant=[jvmTypes::JvmField|UPPERCASE_ID]
		public Assignment getConstantAssignment_2() { return cConstantAssignment_2; }

		//[jvmTypes::JvmField|UPPERCASE_ID]
		public CrossReference getConstantJvmFieldCrossReference_2_0() { return cConstantJvmFieldCrossReference_2_0; }

		//UPPERCASE_ID
		public RuleCall getConstantJvmFieldUPPERCASE_IDTerminalRuleCall_2_0_1() { return cConstantJvmFieldUPPERCASE_IDTerminalRuleCall_2_0_1; }
	}

	public class ExecutionMultiplierElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ExecutionMultiplier");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cCountAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cCountConstantValueParserRuleCall_0_0 = (RuleCall)cCountAssignment_0.eContents().get(0);
		private final Keyword cAsteriskKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//ExecutionMultiplier:
		//	count=ConstantValue '*';
		@Override public ParserRule getRule() { return rule; }

		//count=ConstantValue '*'
		public Group getGroup() { return cGroup; }

		//count=ConstantValue
		public Assignment getCountAssignment_0() { return cCountAssignment_0; }

		//ConstantValue
		public RuleCall getCountConstantValueParserRuleCall_0_0() { return cCountConstantValueParserRuleCall_0_0; }

		//'*'
		public Keyword getAsteriskKeyword_1() { return cAsteriskKeyword_1; }
	}

	public class QualifiedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.QualifiedName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cIDTerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1_1 = (RuleCall)cGroup_1.eContents().get(1);
		
		//QualifiedName:
		//	ID ('.' ID)*;
		@Override public ParserRule getRule() { return rule; }

		//ID ('.' ID)*
		public Group getGroup() { return cGroup; }

		//ID
		public RuleCall getIDTerminalRuleCall_0() { return cIDTerminalRuleCall_0; }

		//('.' ID)*
		public Group getGroup_1() { return cGroup_1; }

		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }

		//ID
		public RuleCall getIDTerminalRuleCall_1_1() { return cIDTerminalRuleCall_1_1; }
	}

	public class QualifiedJavaClassNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.QualifiedJavaClassName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cQualifiedNameParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Keyword cFullStopKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final RuleCall cUPPERCASE_IDTerminalRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		
		//QualifiedJavaClassName:
		//	QualifiedName '.' UPPERCASE_ID;
		@Override public ParserRule getRule() { return rule; }

		//QualifiedName '.' UPPERCASE_ID
		public Group getGroup() { return cGroup; }

		//QualifiedName
		public RuleCall getQualifiedNameParserRuleCall_0() { return cQualifiedNameParserRuleCall_0; }

		//'.'
		public Keyword getFullStopKeyword_1() { return cFullStopKeyword_1; }

		//UPPERCASE_ID
		public RuleCall getUPPERCASE_IDTerminalRuleCall_2() { return cUPPERCASE_IDTerminalRuleCall_2; }
	}

	public class QualifiedNameWithWildcardElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.QualifiedNameWithWildcard");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cQualifiedNameParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Keyword cFullStopAsteriskKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//QualifiedNameWithWildcard:
		//	QualifiedName '.*'?;
		@Override public ParserRule getRule() { return rule; }

		//QualifiedName '.*'?
		public Group getGroup() { return cGroup; }

		//QualifiedName
		public RuleCall getQualifiedNameParserRuleCall_0() { return cQualifiedNameParserRuleCall_0; }

		//'.*'?
		public Keyword getFullStopAsteriskKeyword_1() { return cFullStopAsteriskKeyword_1; }
	}

	public class DocumentationCommentElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DocumentationComment");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cContentAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cContentML_DOC_COMMENTTerminalRuleCall_0_0 = (RuleCall)cContentAssignment_0.eContents().get(0);
		private final RuleCall cNLParserRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//DocumentationComment:
		//	content=ML_DOC_COMMENT NL;
		@Override public ParserRule getRule() { return rule; }

		//content=ML_DOC_COMMENT NL
		public Group getGroup() { return cGroup; }

		//content=ML_DOC_COMMENT
		public Assignment getContentAssignment_0() { return cContentAssignment_0; }

		//ML_DOC_COMMENT
		public RuleCall getContentML_DOC_COMMENTTerminalRuleCall_0_0() { return cContentML_DOC_COMMENTTerminalRuleCall_0_0; }

		//NL
		public RuleCall getNLParserRuleCall_1() { return cNLParserRuleCall_1; }
	}

	public class NLElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NL");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cNEWLINETerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final RuleCall cWSTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		
		//NL:
		//	(NEWLINE WS?)*;
		@Override public ParserRule getRule() { return rule; }

		//(NEWLINE WS?)*
		public Group getGroup() { return cGroup; }

		//NEWLINE
		public RuleCall getNEWLINETerminalRuleCall_0() { return cNEWLINETerminalRuleCall_0; }

		//WS?
		public RuleCall getWSTerminalRuleCall_1() { return cWSTerminalRuleCall_1; }
	}

	public class NLFORCEDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NLFORCED");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cNEWLINETerminalRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final RuleCall cWSTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final RuleCall cNLParserRuleCall_2 = (RuleCall)cGroup.eContents().get(2);
		
		//NLFORCED:
		//	NEWLINE WS? NL;
		@Override public ParserRule getRule() { return rule; }

		//NEWLINE WS? NL
		public Group getGroup() { return cGroup; }

		//NEWLINE
		public RuleCall getNEWLINETerminalRuleCall_0() { return cNEWLINETerminalRuleCall_0; }

		//WS?
		public RuleCall getWSTerminalRuleCall_1() { return cWSTerminalRuleCall_1; }

		//NL
		public RuleCall getNLParserRuleCall_2() { return cNLParserRuleCall_2; }
	}
	
	
	private final ModelElements pModel;
	private final StatementElements pStatement;
	private final VisibleCommentElements pVisibleComment;
	private final VisibleSingleLineCommentElements pVisibleSingleLineComment;
	private final VisibleSingleLineNormalCommentElements pVisibleSingleLineNormalComment;
	private final VisibleSingleLineTitleCommentElements pVisibleSingleLineTitleComment;
	private final VisibleMultiLineCommentElements pVisibleMultiLineComment;
	private final VisibleMultiLineNormalCommentElements pVisibleMultiLineNormalComment;
	private final VisibleMultiLineTitleCommentElements pVisibleMultiLineTitleComment;
	private final VisibleDividerElements pVisibleDivider;
	private final PackageDefinitionElements pPackageDefinition;
	private final PackageStatementElements pPackageStatement;
	private final ImportElements pImport;
	private final ForkDefinitionElements pForkDefinition;
	private final ForkParameterElements pForkParameter;
	private final VariantDefinitionElements pVariantDefinition;
	private final TestDefinitionElements pTestDefinition;
	private final CallDefinitionElements pCallDefinition;
	private final SuiteDefinitionElements pSuiteDefinition;
	private final SuiteParameterDefinitionElements pSuiteParameterDefinition;
	private final SuiteReturnDefinitionElements pSuiteReturnDefinition;
	private final OperationDefinitionElements pOperationDefinition;
	private final SuiteStatementElements pSuiteStatement;
	private final SuiteStatementWithResultElements pSuiteStatementWithResult;
	private final VariableDefinitionElements pVariableDefinition;
	private final ConstantDefinitionElements pConstantDefinition;
	private final VariableAssignmentElements pVariableAssignment;
	private final VariantValueElements pVariantValue;
	private final VariableEntityElements pVariableEntity;
	private final ConstantEntityElements pConstantEntity;
	private final VariableOrConstantEntityElements pVariableOrConstantEntity;
	private final TestElements pTest;
	private final TableTestElements pTableTest;
	private final TableTestRowElements pTableTestRow;
	private final ParameterTableHeaderElements pParameterTableHeader;
	private final ResultTableHeaderElements pResultTableHeader;
	private final ParameterTableValueElements pParameterTableValue;
	private final NamedResultElements pNamedResult;
	private final ResultNameElements pResultName;
	private final FixedResultNameElements pFixedResultName;
	private final CallElements pCall;
	private final NamedCallResultElements pNamedCallResult;
	private final TimeSetElements pTimeSet;
	private final TimeProgressionFactorElements pTimeProgressionFactor;
	private final TimeDifferenceElements pTimeDifference;
	private final SuiteElements pSuite;
	private final SuiteParameterElements pSuiteParameter;
	private final SuiteReturnElements pSuiteReturn;
	private final ParameterElements pParameter;
	private final ParameterNameElements pParameterName;
	private final FixedParameterNameElements pFixedParameterName;
	private final ArbitraryParameterOrResultNameElements pArbitraryParameterOrResultName;
	private final OperationElements pOperation;
	private final StandardOperationElements pStandardOperation;
	private final CustomOperationElements pCustomOperation;
	private final ValueOrEnumValueOrOperationCollectionElements pValueOrEnumValueOrOperationCollection;
	private final ValueOrEnumValueOrOperationElements pValueOrEnumValueOrOperation;
	private final ValueElements pValue;
	private final ConstantValueElements pConstantValue;
	private final StaticValueElements pStaticValue;
	private final IntegerValueElements pIntegerValue;
	private final DecimalValueElements pDecimalValue;
	private final StringValueElements pStringValue;
	private final RegexValueElements pRegexValue;
	private final BooleanValueElements pBooleanValue;
	private final DateValueElements pDateValue;
	private final IsoDateValueElements pIsoDateValue;
	private final EuropeanDateValueElements pEuropeanDateValue;
	private final USDateValueElements pUSDateValue;
	private final TimeValueElements pTimeValue;
	private final IsoTimeValueElements pIsoTimeValue;
	private final Simple24HrsTimeValueElements pSimple24HrsTimeValue;
	private final Simple12HrsTimeValueElements pSimple12HrsTimeValue;
	private final DateAndTimeValueElements pDateAndTimeValue;
	private final IsoDateAndTimeValueElements pIsoDateAndTimeValue;
	private final EuropeanDateAnd24HrsTimeValueElements pEuropeanDateAnd24HrsTimeValue;
	private final EuropeanDateAnd12HrsTimeValueElements pEuropeanDateAnd12HrsTimeValue;
	private final USDateAnd12HrsTimeValueElements pUSDateAnd12HrsTimeValue;
	private final JavaConstantValueElements pJavaConstantValue;
	private final VariableElements pVariable;
	private final VariableVariableElements pVariableVariable;
	private final ConstantElements pConstant;
	private final NullValueElements pNullValue;
	private final InexistentValueElements pInexistentValue;
	private final EmptyValueElements pEmptyValue;
	private final EnumValueElements pEnumValue;
	private final NestedObjectElements pNestedObject;
	private final TypedNestedObjectElements pTypedNestedObject;
	private final KeyValuePairElements pKeyValuePair;
	private final JavaClassReferenceElements pJavaClassReference;
	private final MethodReferenceElements pMethodReference;
	private final JavaConstantReferenceElements pJavaConstantReference;
	private final ExecutionMultiplierElements pExecutionMultiplier;
	private final QualifiedNameElements pQualifiedName;
	private final QualifiedJavaClassNameElements pQualifiedJavaClassName;
	private final QualifiedNameWithWildcardElements pQualifiedNameWithWildcard;
	private final DocumentationCommentElements pDocumentationComment;
	private final NLElements pNL;
	private final NLFORCEDElements pNLFORCED;
	private final TerminalRule tBOOLEAN_TRUE;
	private final TerminalRule tBOOLEAN_FALSE;
	private final TerminalRule tUPPERCASE_ID;
	private final TerminalRule tID;
	private final TerminalRule tINTEGER;
	private final TerminalRule tDECIMAL;
	private final TerminalRule tSTRING;
	private final TerminalRule tREGEX;
	private final TerminalRule tML_COMMENT;
	private final TerminalRule tSL_COMMENT;
	private final TerminalRule tSL_VISIBLE_COMMENT;
	private final TerminalRule tSL_VISIBLE_TITLE_COMMENT;
	private final TerminalRule tML_VISIBLE_COMMENT;
	private final TerminalRule tML_VISIBLE_TITLE_COMMENT;
	private final TerminalRule tML_DOC_COMMENT;
	private final TerminalRule tDIVIDER;
	private final TerminalRule tWS;
	private final TerminalRule tNEWLINE;
	private final TerminalRule tISODATE;
	private final TerminalRule tISOTIME;
	private final TerminalRule tISOTIMEZONE;
	private final TerminalRule tEURODATE;
	private final TerminalRule tUSDATE;
	private final TerminalRule tTWENTYFOURHRSTIME;
	private final TerminalRule tTWELVEHRSTIME;
	private final TerminalRule tTIMESPAN;
	private final TerminalRule tMULTIPLIER;
	private final TerminalRule tANY_OTHER;
	
	private final Grammar grammar;

	@Inject
	public DSLGrammarAccess(GrammarProvider grammarProvider) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.pModel = new ModelElements();
		this.pStatement = new StatementElements();
		this.pVisibleComment = new VisibleCommentElements();
		this.pVisibleSingleLineComment = new VisibleSingleLineCommentElements();
		this.pVisibleSingleLineNormalComment = new VisibleSingleLineNormalCommentElements();
		this.pVisibleSingleLineTitleComment = new VisibleSingleLineTitleCommentElements();
		this.pVisibleMultiLineComment = new VisibleMultiLineCommentElements();
		this.pVisibleMultiLineNormalComment = new VisibleMultiLineNormalCommentElements();
		this.pVisibleMultiLineTitleComment = new VisibleMultiLineTitleCommentElements();
		this.pVisibleDivider = new VisibleDividerElements();
		this.pPackageDefinition = new PackageDefinitionElements();
		this.pPackageStatement = new PackageStatementElements();
		this.pImport = new ImportElements();
		this.pForkDefinition = new ForkDefinitionElements();
		this.pForkParameter = new ForkParameterElements();
		this.pVariantDefinition = new VariantDefinitionElements();
		this.pTestDefinition = new TestDefinitionElements();
		this.pCallDefinition = new CallDefinitionElements();
		this.pSuiteDefinition = new SuiteDefinitionElements();
		this.pSuiteParameterDefinition = new SuiteParameterDefinitionElements();
		this.pSuiteReturnDefinition = new SuiteReturnDefinitionElements();
		this.pOperationDefinition = new OperationDefinitionElements();
		this.pSuiteStatement = new SuiteStatementElements();
		this.pSuiteStatementWithResult = new SuiteStatementWithResultElements();
		this.pVariableDefinition = new VariableDefinitionElements();
		this.pConstantDefinition = new ConstantDefinitionElements();
		this.pVariableAssignment = new VariableAssignmentElements();
		this.pVariantValue = new VariantValueElements();
		this.pVariableEntity = new VariableEntityElements();
		this.pConstantEntity = new ConstantEntityElements();
		this.pVariableOrConstantEntity = new VariableOrConstantEntityElements();
		this.pTest = new TestElements();
		this.pTableTest = new TableTestElements();
		this.pTableTestRow = new TableTestRowElements();
		this.pParameterTableHeader = new ParameterTableHeaderElements();
		this.pResultTableHeader = new ResultTableHeaderElements();
		this.pParameterTableValue = new ParameterTableValueElements();
		this.pNamedResult = new NamedResultElements();
		this.pResultName = new ResultNameElements();
		this.pFixedResultName = new FixedResultNameElements();
		this.pCall = new CallElements();
		this.pNamedCallResult = new NamedCallResultElements();
		this.pTimeSet = new TimeSetElements();
		this.pTimeProgressionFactor = new TimeProgressionFactorElements();
		this.pTimeDifference = new TimeDifferenceElements();
		this.pSuite = new SuiteElements();
		this.pSuiteParameter = new SuiteParameterElements();
		this.pSuiteReturn = new SuiteReturnElements();
		this.pParameter = new ParameterElements();
		this.pParameterName = new ParameterNameElements();
		this.pFixedParameterName = new FixedParameterNameElements();
		this.pArbitraryParameterOrResultName = new ArbitraryParameterOrResultNameElements();
		this.pOperation = new OperationElements();
		this.pStandardOperation = new StandardOperationElements();
		this.pCustomOperation = new CustomOperationElements();
		this.pValueOrEnumValueOrOperationCollection = new ValueOrEnumValueOrOperationCollectionElements();
		this.pValueOrEnumValueOrOperation = new ValueOrEnumValueOrOperationElements();
		this.pValue = new ValueElements();
		this.pConstantValue = new ConstantValueElements();
		this.pStaticValue = new StaticValueElements();
		this.pIntegerValue = new IntegerValueElements();
		this.pDecimalValue = new DecimalValueElements();
		this.pStringValue = new StringValueElements();
		this.pRegexValue = new RegexValueElements();
		this.pBooleanValue = new BooleanValueElements();
		this.pDateValue = new DateValueElements();
		this.pIsoDateValue = new IsoDateValueElements();
		this.pEuropeanDateValue = new EuropeanDateValueElements();
		this.pUSDateValue = new USDateValueElements();
		this.pTimeValue = new TimeValueElements();
		this.pIsoTimeValue = new IsoTimeValueElements();
		this.pSimple24HrsTimeValue = new Simple24HrsTimeValueElements();
		this.pSimple12HrsTimeValue = new Simple12HrsTimeValueElements();
		this.pDateAndTimeValue = new DateAndTimeValueElements();
		this.pIsoDateAndTimeValue = new IsoDateAndTimeValueElements();
		this.pEuropeanDateAnd24HrsTimeValue = new EuropeanDateAnd24HrsTimeValueElements();
		this.pEuropeanDateAnd12HrsTimeValue = new EuropeanDateAnd12HrsTimeValueElements();
		this.pUSDateAnd12HrsTimeValue = new USDateAnd12HrsTimeValueElements();
		this.pJavaConstantValue = new JavaConstantValueElements();
		this.pVariable = new VariableElements();
		this.pVariableVariable = new VariableVariableElements();
		this.pConstant = new ConstantElements();
		this.pNullValue = new NullValueElements();
		this.pInexistentValue = new InexistentValueElements();
		this.pEmptyValue = new EmptyValueElements();
		this.pEnumValue = new EnumValueElements();
		this.pNestedObject = new NestedObjectElements();
		this.pTypedNestedObject = new TypedNestedObjectElements();
		this.pKeyValuePair = new KeyValuePairElements();
		this.pJavaClassReference = new JavaClassReferenceElements();
		this.pMethodReference = new MethodReferenceElements();
		this.pJavaConstantReference = new JavaConstantReferenceElements();
		this.pExecutionMultiplier = new ExecutionMultiplierElements();
		this.pQualifiedName = new QualifiedNameElements();
		this.pQualifiedJavaClassName = new QualifiedJavaClassNameElements();
		this.pQualifiedNameWithWildcard = new QualifiedNameWithWildcardElements();
		this.pDocumentationComment = new DocumentationCommentElements();
		this.pNL = new NLElements();
		this.pNLFORCED = new NLFORCEDElements();
		this.tBOOLEAN_TRUE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.BOOLEAN_TRUE");
		this.tBOOLEAN_FALSE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.BOOLEAN_FALSE");
		this.tUPPERCASE_ID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.UPPERCASE_ID");
		this.tID = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ID");
		this.tINTEGER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.INTEGER");
		this.tDECIMAL = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DECIMAL");
		this.tSTRING = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.STRING");
		this.tREGEX = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.REGEX");
		this.tML_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ML_COMMENT");
		this.tSL_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SL_COMMENT");
		this.tSL_VISIBLE_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SL_VISIBLE_COMMENT");
		this.tSL_VISIBLE_TITLE_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.SL_VISIBLE_TITLE_COMMENT");
		this.tML_VISIBLE_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ML_VISIBLE_COMMENT");
		this.tML_VISIBLE_TITLE_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ML_VISIBLE_TITLE_COMMENT");
		this.tML_DOC_COMMENT = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ML_DOC_COMMENT");
		this.tDIVIDER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.DIVIDER");
		this.tWS = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.WS");
		this.tNEWLINE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.NEWLINE");
		this.tISODATE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ISODATE");
		this.tISOTIME = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ISOTIME");
		this.tISOTIMEZONE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ISOTIMEZONE");
		this.tEURODATE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.EURODATE");
		this.tUSDATE = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.USDATE");
		this.tTWENTYFOURHRSTIME = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TWENTYFOURHRSTIME");
		this.tTWELVEHRSTIME = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TWELVEHRSTIME");
		this.tTIMESPAN = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.TIMESPAN");
		this.tMULTIPLIER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.MULTIPLIER");
		this.tANY_OTHER = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "de.gebit.integrity.DSL.ANY_OTHER");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("de.gebit.integrity.DSL".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	

	
	///* This is the Integrity grammar. It's basically just another XText grammar definition, but with one specialty: since
	// * the Integrity language needs to use line breaks as syntactically relevant elements in one specific place (in order to
	// * split lines of tabletest tables), the whole grammar is "newline-aware", although it actually allows optional newlines
	// * at pretty much ANY place where whitespace and newlines are usually allowed (except the mentioned tabletest lines, 
	// * where newlines are not only allowed, but required!). This is done by explicitly stating all the places where newlines
	// * are allowed, but not required (the NL rule), as well as the places where newlines are forced and used as a syntactically
	// * relevant element (NLFORCED rule). 
	// * 
	// * This works rather well in practice, although one sometimes needs to put some additional effort into the integration of new
	// * syntactical elements, especially considering content assist and autoformatting.
	// */ Model:
	//	{Model} NL (imports+=Import NL)* statements+=Statement*;
	public ModelElements getModelAccess() {
		return pModel;
	}
	
	public ParserRule getModelRule() {
		return getModelAccess().getRule();
	}

	//Statement:
	//	PackageDefinition | ForkDefinition | VariantDefinition;
	public StatementElements getStatementAccess() {
		return pStatement;
	}
	
	public ParserRule getStatementRule() {
		return getStatementAccess().getRule();
	}

	//VisibleComment:
	//	VisibleSingleLineComment | VisibleMultiLineComment;
	public VisibleCommentElements getVisibleCommentAccess() {
		return pVisibleComment;
	}
	
	public ParserRule getVisibleCommentRule() {
		return getVisibleCommentAccess().getRule();
	}

	//VisibleSingleLineComment:
	//	VisibleSingleLineNormalComment | VisibleSingleLineTitleComment;
	public VisibleSingleLineCommentElements getVisibleSingleLineCommentAccess() {
		return pVisibleSingleLineComment;
	}
	
	public ParserRule getVisibleSingleLineCommentRule() {
		return getVisibleSingleLineCommentAccess().getRule();
	}

	//VisibleSingleLineNormalComment:
	//	content=SL_VISIBLE_COMMENT NL;
	public VisibleSingleLineNormalCommentElements getVisibleSingleLineNormalCommentAccess() {
		return pVisibleSingleLineNormalComment;
	}
	
	public ParserRule getVisibleSingleLineNormalCommentRule() {
		return getVisibleSingleLineNormalCommentAccess().getRule();
	}

	//VisibleSingleLineTitleComment:
	//	content=SL_VISIBLE_TITLE_COMMENT NL;
	public VisibleSingleLineTitleCommentElements getVisibleSingleLineTitleCommentAccess() {
		return pVisibleSingleLineTitleComment;
	}
	
	public ParserRule getVisibleSingleLineTitleCommentRule() {
		return getVisibleSingleLineTitleCommentAccess().getRule();
	}

	//VisibleMultiLineComment:
	//	VisibleMultiLineNormalComment | VisibleMultiLineTitleComment;
	public VisibleMultiLineCommentElements getVisibleMultiLineCommentAccess() {
		return pVisibleMultiLineComment;
	}
	
	public ParserRule getVisibleMultiLineCommentRule() {
		return getVisibleMultiLineCommentAccess().getRule();
	}

	//VisibleMultiLineNormalComment:
	//	content=ML_VISIBLE_COMMENT NL;
	public VisibleMultiLineNormalCommentElements getVisibleMultiLineNormalCommentAccess() {
		return pVisibleMultiLineNormalComment;
	}
	
	public ParserRule getVisibleMultiLineNormalCommentRule() {
		return getVisibleMultiLineNormalCommentAccess().getRule();
	}

	//VisibleMultiLineTitleComment:
	//	content=ML_VISIBLE_TITLE_COMMENT NL;
	public VisibleMultiLineTitleCommentElements getVisibleMultiLineTitleCommentAccess() {
		return pVisibleMultiLineTitleComment;
	}
	
	public ParserRule getVisibleMultiLineTitleCommentRule() {
		return getVisibleMultiLineTitleCommentAccess().getRule();
	}

	//VisibleDivider:
	//	content=DIVIDER NL;
	public VisibleDividerElements getVisibleDividerAccess() {
		return pVisibleDivider;
	}
	
	public ParserRule getVisibleDividerRule() {
		return getVisibleDividerAccess().getRule();
	}

	//PackageDefinition:
	//	documentation=DocumentationComment? 'packagedef' NL name=QualifiedName 'with' NL statements+=PackageStatement*
	//	'packageend' NL;
	public PackageDefinitionElements getPackageDefinitionAccess() {
		return pPackageDefinition;
	}
	
	public ParserRule getPackageDefinitionRule() {
		return getPackageDefinitionAccess().getRule();
	}

	//PackageStatement:
	//	ForkDefinition | VariantDefinition | TestDefinition | CallDefinition | OperationDefinition | SuiteDefinition |
	//	VariableDefinition | ConstantDefinition;
	public PackageStatementElements getPackageStatementAccess() {
		return pPackageStatement;
	}
	
	public ParserRule getPackageStatementRule() {
		return getPackageStatementAccess().getRule();
	}

	//Import:
	//	'import' NL importedNamespace=QualifiedNameWithWildcard;
	public ImportElements getImportAccess() {
		return pImport;
	}
	
	public ParserRule getImportRule() {
		return getImportAccess().getRule();
	}

	//ForkDefinition:
	//	documentation=DocumentationComment? private='private'? 'forkdef' NL name=QualifiedName NL (description=STRING NL)?
	//	(('uses' NL forkerClass=JavaClassReference | 'based on' NL baseFork=[ForkDefinition|QualifiedName]) NL)?
	//	(parameters+=ForkParameter NL)*;
	public ForkDefinitionElements getForkDefinitionAccess() {
		return pForkDefinition;
	}
	
	public ParserRule getForkDefinitionRule() {
		return getForkDefinitionAccess().getRule();
	}

	//ForkParameter:
	//	name=FixedParameterName NL ':' NL value=ValueOrEnumValueOrOperation;
	public ForkParameterElements getForkParameterAccess() {
		return pForkParameter;
	}
	
	public ParserRule getForkParameterRule() {
		return getForkParameterAccess().getRule();
	}

	//VariantDefinition:
	//	documentation=DocumentationComment? 'variantdef' NL name=QualifiedName NL (description=STRING NL)?;
	public VariantDefinitionElements getVariantDefinitionAccess() {
		return pVariantDefinition;
	}
	
	public ParserRule getVariantDefinitionRule() {
		return getVariantDefinitionAccess().getRule();
	}

	//TestDefinition:
	//	documentation=DocumentationComment? 'testdef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL;
	public TestDefinitionElements getTestDefinitionAccess() {
		return pTestDefinition;
	}
	
	public ParserRule getTestDefinitionRule() {
		return getTestDefinitionAccess().getRule();
	}

	//CallDefinition:
	//	documentation=DocumentationComment? 'calldef' NL name=QualifiedName NL 'uses' NL fixtureMethod=MethodReference NL;
	public CallDefinitionElements getCallDefinitionAccess() {
		return pCallDefinition;
	}
	
	public ParserRule getCallDefinitionRule() {
		return getCallDefinitionAccess().getRule();
	}

	//SuiteDefinition:
	//	documentation=DocumentationComment? private='private'? singleRun='single-run'? inlined='inlined'? 'suitedef' NL
	//	name=QualifiedName NL ('gets' (parameters+=SuiteParameterDefinition NL)+)? ('returns' (return+=SuiteReturnDefinition
	//	NL)+)? ('requires' NL (dependencies+=[SuiteDefinition|QualifiedName] NL)*)? ('concludedby' NL
	//	(finalizers+=[SuiteDefinition|QualifiedName] NL)*)? 'with' NL statements+=SuiteStatement* 'suiteend' NL;
	public SuiteDefinitionElements getSuiteDefinitionAccess() {
		return pSuiteDefinition;
	}
	
	public ParserRule getSuiteDefinitionRule() {
		return getSuiteDefinitionAccess().getRule();
	}

	//SuiteParameterDefinition:
	//	name=VariableEntity (NL 'by default' default=ValueOrEnumValueOrOperationCollection)?;
	public SuiteParameterDefinitionElements getSuiteParameterDefinitionAccess() {
		return pSuiteParameterDefinition;
	}
	
	public ParserRule getSuiteParameterDefinitionRule() {
		return getSuiteParameterDefinitionAccess().getRule();
	}

	//SuiteReturnDefinition:
	//	name=VariableEntity;
	public SuiteReturnDefinitionElements getSuiteReturnDefinitionAccess() {
		return pSuiteReturnDefinition;
	}
	
	public ParserRule getSuiteReturnDefinitionRule() {
		return getSuiteReturnDefinitionAccess().getRule();
	}

	//OperationDefinition:
	//	'operationdef' NL name=QualifiedName NL 'uses' NL operationType=JavaClassReference NL;
	public OperationDefinitionElements getOperationDefinitionAccess() {
		return pOperationDefinition;
	}
	
	public ParserRule getOperationDefinitionRule() {
		return getOperationDefinitionAccess().getRule();
	}

	//SuiteStatement:
	//	SuiteStatementWithResult | VariableDefinition | ConstantDefinition | VariableAssignment | VisibleComment |
	//	VisibleDivider;
	public SuiteStatementElements getSuiteStatementAccess() {
		return pSuiteStatement;
	}
	
	public ParserRule getSuiteStatementRule() {
		return getSuiteStatementAccess().getRule();
	}

	//SuiteStatementWithResult:
	//	Suite | Test | TableTest | Call | TimeSet;
	public SuiteStatementWithResultElements getSuiteStatementWithResultAccess() {
		return pSuiteStatementWithResult;
	}
	
	public ParserRule getSuiteStatementWithResultRule() {
		return getSuiteStatementWithResultAccess().getRule();
	}

	//VariableDefinition:
	//	private='private'? 'variable' NL name=VariableEntity NL ('initially' NL
	//	initialValue=ValueOrEnumValueOrOperationCollection NL)?;
	public VariableDefinitionElements getVariableDefinitionAccess() {
		return pVariableDefinition;
	}
	
	public ParserRule getVariableDefinitionRule() {
		return getVariableDefinitionAccess().getRule();
	}

	//ConstantDefinition:
	//	documentation=DocumentationComment? private='private'? 'constant' NL name=ConstantEntity NL
	//	((value=ValueOrEnumValueOrOperationCollection NL)? (variantValues+=VariantValue NL)*) (parameterized='parameterized'
	//	NL)?;
	public ConstantDefinitionElements getConstantDefinitionAccess() {
		return pConstantDefinition;
	}
	
	public ParserRule getConstantDefinitionRule() {
		return getConstantDefinitionAccess().getRule();
	}

	//VariableAssignment:
	//	'assign' NL value=ValueOrEnumValueOrOperationCollection NL '->' NL target=VariableVariable NL;
	public VariableAssignmentElements getVariableAssignmentAccess() {
		return pVariableAssignment;
	}
	
	public ParserRule getVariableAssignmentRule() {
		return getVariableAssignmentAccess().getRule();
	}

	//VariantValue:
	//	'in' NL (names+=[VariantDefinition|QualifiedName] NL)+ ':' NL value=ValueOrEnumValueOrOperationCollection;
	public VariantValueElements getVariantValueAccess() {
		return pVariantValue;
	}
	
	public ParserRule getVariantValueRule() {
		return getVariantValueAccess().getRule();
	}

	//VariableEntity:
	//	name=QualifiedName;
	public VariableEntityElements getVariableEntityAccess() {
		return pVariableEntity;
	}
	
	public ParserRule getVariableEntityRule() {
		return getVariableEntityAccess().getRule();
	}

	//ConstantEntity:
	//	name=QualifiedName;
	public ConstantEntityElements getConstantEntityAccess() {
		return pConstantEntity;
	}
	
	public ParserRule getConstantEntityRule() {
		return getConstantEntityAccess().getRule();
	}

	//VariableOrConstantEntity:
	//	VariableEntity | ConstantEntity;
	public VariableOrConstantEntityElements getVariableOrConstantEntityAccess() {
		return pVariableOrConstantEntity;
	}
	
	public ParserRule getVariableOrConstantEntityRule() {
		return getVariableOrConstantEntityAccess().getRule();
	}

	//Test:
	//	checkpoint='checkpoint'? 'test' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* (NL
	//	results+=NamedResult)* (NL '=' NL result=ValueOrEnumValueOrOperationCollection)? NL;
	public TestElements getTestAccess() {
		return pTest;
	}
	
	public ParserRule getTestRule() {
		return getTestAccess().getRule();
	}

	//TableTest:
	//	'tabletest' NL definition=[TestDefinition|QualifiedName] (NL parameters+=Parameter)* NLFORCED
	//	parameterHeaders+=ParameterTableHeader* resultHeaders+=ResultTableHeader* '|' (defaultResultColumn='=' '|')? (NLFORCED
	//	rows+=TableTestRow)+ NLFORCED;
	public TableTestElements getTableTestAccess() {
		return pTableTest;
	}
	
	public ParserRule getTableTestRule() {
		return getTableTestAccess().getRule();
	}

	//TableTestRow:
	//	{TableTestRow} values+=ParameterTableValue+;
	public TableTestRowElements getTableTestRowAccess() {
		return pTableTestRow;
	}
	
	public ParserRule getTableTestRowRule() {
		return getTableTestRowAccess().getRule();
	}

	//ParameterTableHeader:
	//	'|' name=ParameterName '|'?;
	public ParameterTableHeaderElements getParameterTableHeaderAccess() {
		return pParameterTableHeader;
	}
	
	public ParserRule getParameterTableHeaderRule() {
		return getParameterTableHeaderAccess().getRule();
	}

	//ResultTableHeader:
	//	'|' name=ResultName '=' '|'?;
	public ResultTableHeaderElements getResultTableHeaderAccess() {
		return pResultTableHeader;
	}
	
	public ParserRule getResultTableHeaderRule() {
		return getResultTableHeaderAccess().getRule();
	}

	//ParameterTableValue:
	//	'|' value=ValueOrEnumValueOrOperationCollection '|'?;
	public ParameterTableValueElements getParameterTableValueAccess() {
		return pParameterTableValue;
	}
	
	public ParserRule getParameterTableValueRule() {
		return getParameterTableValueAccess().getRule();
	}

	//NamedResult:
	//	name=ResultName NL '=' NL value=ValueOrEnumValueOrOperationCollection;
	public NamedResultElements getNamedResultAccess() {
		return pNamedResult;
	}
	
	public ParserRule getNamedResultRule() {
		return getNamedResultAccess().getRule();
	}

	//ResultName:
	//	FixedResultName | ArbitraryParameterOrResultName;
	public ResultNameElements getResultNameAccess() {
		return pResultName;
	}
	
	public ParserRule getResultNameRule() {
		return getResultNameAccess().getRule();
	}

	//FixedResultName:
	//	field=[jvmTypes::JvmField];
	public FixedResultNameElements getFixedResultNameAccess() {
		return pFixedResultName;
	}
	
	public ParserRule getFixedResultNameRule() {
		return getFixedResultNameAccess().getRule();
	}

	//Call:
	//	'call' NL (multiplier=ExecutionMultiplier NL)? definition=[CallDefinition|QualifiedName] (NL parameters+=Parameter)*
	//	(NL results+=NamedCallResult)* (NL '->' NL result=VariableVariable)? NL;
	public CallElements getCallAccess() {
		return pCall;
	}
	
	public ParserRule getCallRule() {
		return getCallAccess().getRule();
	}

	//NamedCallResult:
	//	name=ResultName NL '->' NL target=VariableVariable;
	public NamedCallResultElements getNamedCallResultAccess() {
		return pNamedCallResult;
	}
	
	public ParserRule getNamedCallResultRule() {
		return getNamedCallResultAccess().getRule();
	}

	//TimeSet:
	//	'timeset' NL (live='live' NL | (startTime=ValueOrEnumValueOrOperation | diffTime=TimeDifference) NL
	//	(progressionMode='progressing' NL (progressionFactor=TimeProgressionFactor NL)?)?) ('on' NL
	//	((forks+=[ForkDefinition|QualifiedName] | masterFork='master') ','? NL)+)?;
	public TimeSetElements getTimeSetAccess() {
		return pTimeSet;
	}
	
	public ParserRule getTimeSetRule() {
		return getTimeSetAccess().getRule();
	}

	//TimeProgressionFactor:
	//	fixedValue=MULTIPLIER | calculatedValue=(Variable | Operation);
	public TimeProgressionFactorElements getTimeProgressionFactorAccess() {
		return pTimeProgressionFactor;
	}
	
	public ParserRule getTimeProgressionFactorRule() {
		return getTimeProgressionFactorAccess().getRule();
	}

	//TimeDifference:
	//	direction=('+' | '-') ((NL fixedValues+=TIMESPAN)+ | NL calculatedValue=(Variable | Operation));
	public TimeDifferenceElements getTimeDifferenceAccess() {
		return pTimeDifference;
	}
	
	public ParserRule getTimeDifferenceRule() {
		return getTimeDifferenceAccess().getRule();
	}

	//Suite:
	//	inlined='inlined'? 'suite' NL (multiplier=ExecutionMultiplier NL)? definition=[SuiteDefinition|QualifiedName] NL
	//	(parameters+=SuiteParameter NL)* (return+=SuiteReturn NL)* ('on' NL fork=[ForkDefinition|QualifiedName] NL)? ('in' NL
	//	(variants+=[VariantDefinition|QualifiedName] ','? NL)+)?;
	public SuiteElements getSuiteAccess() {
		return pSuite;
	}
	
	public ParserRule getSuiteRule() {
		return getSuiteAccess().getRule();
	}

	//SuiteParameter:
	//	name=[VariableOrConstantEntity|QualifiedName] NL ':' NL value=ValueOrEnumValueOrOperationCollection;
	public SuiteParameterElements getSuiteParameterAccess() {
		return pSuiteParameter;
	}
	
	public ParserRule getSuiteParameterRule() {
		return getSuiteParameterAccess().getRule();
	}

	//SuiteReturn:
	//	name=[SuiteReturnDefinition|QualifiedName] NL '->' NL target=VariableVariable;
	public SuiteReturnElements getSuiteReturnAccess() {
		return pSuiteReturn;
	}
	
	public ParserRule getSuiteReturnRule() {
		return getSuiteReturnAccess().getRule();
	}

	//Parameter:
	//	name=ParameterName NL ':' NL value=ValueOrEnumValueOrOperationCollection;
	public ParameterElements getParameterAccess() {
		return pParameter;
	}
	
	public ParserRule getParameterRule() {
		return getParameterAccess().getRule();
	}

	//ParameterName:
	//	FixedParameterName | ArbitraryParameterOrResultName;
	public ParameterNameElements getParameterNameAccess() {
		return pParameterName;
	}
	
	public ParserRule getParameterNameRule() {
		return getParameterNameAccess().getRule();
	}

	//FixedParameterName:
	//	annotation=[jvmTypes::JvmAnnotationReference];
	public FixedParameterNameElements getFixedParameterNameAccess() {
		return pFixedParameterName;
	}
	
	public ParserRule getFixedParameterNameRule() {
		return getFixedParameterNameAccess().getRule();
	}

	//ArbitraryParameterOrResultName:
	//	'+' (identifier=ID | stringIdentifier=STRING);
	public ArbitraryParameterOrResultNameElements getArbitraryParameterOrResultNameAccess() {
		return pArbitraryParameterOrResultName;
	}
	
	public ParserRule getArbitraryParameterOrResultNameRule() {
		return getArbitraryParameterOrResultNameAccess().getRule();
	}

	//Operation:
	//	StandardOperation | CustomOperation;
	public OperationElements getOperationAccess() {
		return pOperation;
	}
	
	public ParserRule getOperationRule() {
		return getOperationAccess().getRule();
	}

	//StandardOperation:
	//	'(' NL firstOperand=ValueOrEnumValueOrOperation NL (operators+=('+' | '-' | '*' | '/' | '%' | '..') NL
	//	moreOperands+=ValueOrEnumValueOrOperation NL)+ ')';
	public StandardOperationElements getStandardOperationAccess() {
		return pStandardOperation;
	}
	
	public ParserRule getStandardOperationRule() {
		return getStandardOperationAccess().getRule();
	}

	//CustomOperation:
	//	'[' NL (prefixOperand=ValueOrEnumValueOrOperationCollection NL)? definition=[OperationDefinition|QualifiedName] (NL
	//	'with' postfixOperand=ValueOrEnumValueOrOperationCollection)? NL ']';
	public CustomOperationElements getCustomOperationAccess() {
		return pCustomOperation;
	}
	
	public ParserRule getCustomOperationRule() {
		return getCustomOperationAccess().getRule();
	}

	//ValueOrEnumValueOrOperationCollection:
	//	value=ValueOrEnumValueOrOperation (NL ',' NL moreValues+=ValueOrEnumValueOrOperation)*;
	public ValueOrEnumValueOrOperationCollectionElements getValueOrEnumValueOrOperationCollectionAccess() {
		return pValueOrEnumValueOrOperationCollection;
	}
	
	public ParserRule getValueOrEnumValueOrOperationCollectionRule() {
		return getValueOrEnumValueOrOperationCollectionAccess().getRule();
	}

	//ValueOrEnumValueOrOperation:
	//	Value | EnumValue | Operation;
	public ValueOrEnumValueOrOperationElements getValueOrEnumValueOrOperationAccess() {
		return pValueOrEnumValueOrOperation;
	}
	
	public ParserRule getValueOrEnumValueOrOperationRule() {
		return getValueOrEnumValueOrOperationAccess().getRule();
	}

	//Value:
	//	StaticValue | Variable | NestedObject | TypedNestedObject;
	public ValueElements getValueAccess() {
		return pValue;
	}
	
	public ParserRule getValueRule() {
		return getValueAccess().getRule();
	}

	//ConstantValue:
	//	StaticValue | Constant;
	public ConstantValueElements getConstantValueAccess() {
		return pConstantValue;
	}
	
	public ParserRule getConstantValueRule() {
		return getConstantValueAccess().getRule();
	}

	//StaticValue:
	//	StringValue | RegexValue | IntegerValue | DecimalValue | BooleanValue | DateValue | TimeValue | DateAndTimeValue |
	//	NullValue | InexistentValue | EmptyValue | JavaConstantValue;
	public StaticValueElements getStaticValueAccess() {
		return pStaticValue;
	}
	
	public ParserRule getStaticValueRule() {
		return getStaticValueAccess().getRule();
	}

	//IntegerValue:
	//	integerValue=INTEGER;
	public IntegerValueElements getIntegerValueAccess() {
		return pIntegerValue;
	}
	
	public ParserRule getIntegerValueRule() {
		return getIntegerValueAccess().getRule();
	}

	//DecimalValue:
	//	decimalValue=DECIMAL;
	public DecimalValueElements getDecimalValueAccess() {
		return pDecimalValue;
	}
	
	public ParserRule getDecimalValueRule() {
		return getDecimalValueAccess().getRule();
	}

	//StringValue:
	//	stringValue=STRING;
	public StringValueElements getStringValueAccess() {
		return pStringValue;
	}
	
	public ParserRule getStringValueRule() {
		return getStringValueAccess().getRule();
	}

	//RegexValue:
	//	regexValue=REGEX;
	public RegexValueElements getRegexValueAccess() {
		return pRegexValue;
	}
	
	public ParserRule getRegexValueRule() {
		return getRegexValueAccess().getRule();
	}

	//BooleanValue:
	//	booleanValue=(BOOLEAN_TRUE | BOOLEAN_FALSE);
	public BooleanValueElements getBooleanValueAccess() {
		return pBooleanValue;
	}
	
	public ParserRule getBooleanValueRule() {
		return getBooleanValueAccess().getRule();
	}

	//DateValue:
	//	IsoDateValue | EuropeanDateValue | USDateValue;
	public DateValueElements getDateValueAccess() {
		return pDateValue;
	}
	
	public ParserRule getDateValueRule() {
		return getDateValueAccess().getRule();
	}

	//IsoDateValue:
	//	dateValue=ISODATE;
	public IsoDateValueElements getIsoDateValueAccess() {
		return pIsoDateValue;
	}
	
	public ParserRule getIsoDateValueRule() {
		return getIsoDateValueAccess().getRule();
	}

	//EuropeanDateValue:
	//	dateValue=EURODATE;
	public EuropeanDateValueElements getEuropeanDateValueAccess() {
		return pEuropeanDateValue;
	}
	
	public ParserRule getEuropeanDateValueRule() {
		return getEuropeanDateValueAccess().getRule();
	}

	//USDateValue:
	//	dateValue=USDATE;
	public USDateValueElements getUSDateValueAccess() {
		return pUSDateValue;
	}
	
	public ParserRule getUSDateValueRule() {
		return getUSDateValueAccess().getRule();
	}

	//TimeValue:
	//	IsoTimeValue | Simple24HrsTimeValue | Simple12HrsTimeValue;
	public TimeValueElements getTimeValueAccess() {
		return pTimeValue;
	}
	
	public ParserRule getTimeValueRule() {
		return getTimeValueAccess().getRule();
	}

	//IsoTimeValue:
	//	timeValue=ISOTIME;
	public IsoTimeValueElements getIsoTimeValueAccess() {
		return pIsoTimeValue;
	}
	
	public ParserRule getIsoTimeValueRule() {
		return getIsoTimeValueAccess().getRule();
	}

	//Simple24HrsTimeValue:
	//	timeValue=TWENTYFOURHRSTIME;
	public Simple24HrsTimeValueElements getSimple24HrsTimeValueAccess() {
		return pSimple24HrsTimeValue;
	}
	
	public ParserRule getSimple24HrsTimeValueRule() {
		return getSimple24HrsTimeValueAccess().getRule();
	}

	//Simple12HrsTimeValue:
	//	timeValue=TWELVEHRSTIME;
	public Simple12HrsTimeValueElements getSimple12HrsTimeValueAccess() {
		return pSimple12HrsTimeValue;
	}
	
	public ParserRule getSimple12HrsTimeValueRule() {
		return getSimple12HrsTimeValueAccess().getRule();
	}

	//DateAndTimeValue:
	//	IsoDateAndTimeValue | EuropeanDateAnd24HrsTimeValue | EuropeanDateAnd12HrsTimeValue | USDateAnd12HrsTimeValue;
	public DateAndTimeValueElements getDateAndTimeValueAccess() {
		return pDateAndTimeValue;
	}
	
	public ParserRule getDateAndTimeValueRule() {
		return getDateAndTimeValueAccess().getRule();
	}

	//IsoDateAndTimeValue:
	//	dateValue=ISODATE timeValue=ISOTIME;
	public IsoDateAndTimeValueElements getIsoDateAndTimeValueAccess() {
		return pIsoDateAndTimeValue;
	}
	
	public ParserRule getIsoDateAndTimeValueRule() {
		return getIsoDateAndTimeValueAccess().getRule();
	}

	//EuropeanDateAnd24HrsTimeValue:
	//	dateValue=EURODATE NL timeValue=TWENTYFOURHRSTIME;
	public EuropeanDateAnd24HrsTimeValueElements getEuropeanDateAnd24HrsTimeValueAccess() {
		return pEuropeanDateAnd24HrsTimeValue;
	}
	
	public ParserRule getEuropeanDateAnd24HrsTimeValueRule() {
		return getEuropeanDateAnd24HrsTimeValueAccess().getRule();
	}

	//EuropeanDateAnd12HrsTimeValue:
	//	dateValue=EURODATE NL timeValue=TWELVEHRSTIME;
	public EuropeanDateAnd12HrsTimeValueElements getEuropeanDateAnd12HrsTimeValueAccess() {
		return pEuropeanDateAnd12HrsTimeValue;
	}
	
	public ParserRule getEuropeanDateAnd12HrsTimeValueRule() {
		return getEuropeanDateAnd12HrsTimeValueAccess().getRule();
	}

	//USDateAnd12HrsTimeValue:
	//	dateValue=USDATE NL timeValue=TWELVEHRSTIME;
	public USDateAnd12HrsTimeValueElements getUSDateAnd12HrsTimeValueAccess() {
		return pUSDateAnd12HrsTimeValue;
	}
	
	public ParserRule getUSDateAnd12HrsTimeValueRule() {
		return getUSDateAnd12HrsTimeValueAccess().getRule();
	}

	//JavaConstantValue:
	//	'<' constant=JavaConstantReference '>';
	public JavaConstantValueElements getJavaConstantValueAccess() {
		return pJavaConstantValue;
	}
	
	public ParserRule getJavaConstantValueRule() {
		return getJavaConstantValueAccess().getRule();
	}

	//Variable:
	//	name=[VariableOrConstantEntity|QualifiedName] ('#' attribute=QualifiedName)?;
	public VariableElements getVariableAccess() {
		return pVariable;
	}
	
	public ParserRule getVariableRule() {
		return getVariableAccess().getRule();
	}

	//VariableVariable:
	//	name=[VariableEntity|QualifiedName];
	public VariableVariableElements getVariableVariableAccess() {
		return pVariableVariable;
	}
	
	public ParserRule getVariableVariableRule() {
		return getVariableVariableAccess().getRule();
	}

	//Constant:
	//	name=[ConstantEntity|QualifiedName];
	public ConstantElements getConstantAccess() {
		return pConstant;
	}
	
	public ParserRule getConstantRule() {
		return getConstantAccess().getRule();
	}

	//NullValue:
	//	{Null} 'null';
	public NullValueElements getNullValueAccess() {
		return pNullValue;
	}
	
	public ParserRule getNullValueRule() {
		return getNullValueAccess().getRule();
	}

	//InexistentValue:
	//	{Inexistent} 'inexistent';
	public InexistentValueElements getInexistentValueAccess() {
		return pInexistentValue;
	}
	
	public ParserRule getInexistentValueRule() {
		return getInexistentValueAccess().getRule();
	}

	//EmptyValue:
	//	{Empty} 'empty';
	public EmptyValueElements getEmptyValueAccess() {
		return pEmptyValue;
	}
	
	public ParserRule getEmptyValueRule() {
		return getEmptyValueAccess().getRule();
	}

	//EnumValue:
	//	enumValue=[jvmTypes::JvmEnumerationLiteral|UPPERCASE_ID];
	public EnumValueElements getEnumValueAccess() {
		return pEnumValue;
	}
	
	public ParserRule getEnumValueRule() {
		return getEnumValueAccess().getRule();
	}

	//NestedObject:
	//	'{' NL (attributes+=KeyValuePair NL)+ '}';
	public NestedObjectElements getNestedObjectAccess() {
		return pNestedObject;
	}
	
	public ParserRule getNestedObjectRule() {
		return getNestedObjectAccess().getRule();
	}

	//TypedNestedObject:
	//	'<' type=JavaClassReference '>' NL nestedObject=NestedObject;
	public TypedNestedObjectElements getTypedNestedObjectAccess() {
		return pTypedNestedObject;
	}
	
	public ParserRule getTypedNestedObjectRule() {
		return getTypedNestedObjectAccess().getRule();
	}

	//KeyValuePair:
	//	(identifier=ID | stringIdentifier=STRING) NL ':' NL value=ValueOrEnumValueOrOperationCollection;
	public KeyValuePairElements getKeyValuePairAccess() {
		return pKeyValuePair;
	}
	
	public ParserRule getKeyValuePairRule() {
		return getKeyValuePairAccess().getRule();
	}

	//JavaClassReference:
	//	type=[jvmTypes::JvmType|QualifiedJavaClassName];
	public JavaClassReferenceElements getJavaClassReferenceAccess() {
		return pJavaClassReference;
	}
	
	public ParserRule getJavaClassReferenceRule() {
		return getJavaClassReferenceAccess().getRule();
	}

	//MethodReference:
	//	type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' method=[jvmTypes::JvmOperation];
	public MethodReferenceElements getMethodReferenceAccess() {
		return pMethodReference;
	}
	
	public ParserRule getMethodReferenceRule() {
		return getMethodReferenceAccess().getRule();
	}

	//JavaConstantReference:
	//	type=[jvmTypes::JvmType|QualifiedJavaClassName] '#' constant=[jvmTypes::JvmField|UPPERCASE_ID];
	public JavaConstantReferenceElements getJavaConstantReferenceAccess() {
		return pJavaConstantReference;
	}
	
	public ParserRule getJavaConstantReferenceRule() {
		return getJavaConstantReferenceAccess().getRule();
	}

	//ExecutionMultiplier:
	//	count=ConstantValue '*';
	public ExecutionMultiplierElements getExecutionMultiplierAccess() {
		return pExecutionMultiplier;
	}
	
	public ParserRule getExecutionMultiplierRule() {
		return getExecutionMultiplierAccess().getRule();
	}

	//QualifiedName:
	//	ID ('.' ID)*;
	public QualifiedNameElements getQualifiedNameAccess() {
		return pQualifiedName;
	}
	
	public ParserRule getQualifiedNameRule() {
		return getQualifiedNameAccess().getRule();
	}

	//QualifiedJavaClassName:
	//	QualifiedName '.' UPPERCASE_ID;
	public QualifiedJavaClassNameElements getQualifiedJavaClassNameAccess() {
		return pQualifiedJavaClassName;
	}
	
	public ParserRule getQualifiedJavaClassNameRule() {
		return getQualifiedJavaClassNameAccess().getRule();
	}

	//QualifiedNameWithWildcard:
	//	QualifiedName '.*'?;
	public QualifiedNameWithWildcardElements getQualifiedNameWithWildcardAccess() {
		return pQualifiedNameWithWildcard;
	}
	
	public ParserRule getQualifiedNameWithWildcardRule() {
		return getQualifiedNameWithWildcardAccess().getRule();
	}

	//DocumentationComment:
	//	content=ML_DOC_COMMENT NL;
	public DocumentationCommentElements getDocumentationCommentAccess() {
		return pDocumentationComment;
	}
	
	public ParserRule getDocumentationCommentRule() {
		return getDocumentationCommentAccess().getRule();
	}

	//NL:
	//	(NEWLINE WS?)*;
	public NLElements getNLAccess() {
		return pNL;
	}
	
	public ParserRule getNLRule() {
		return getNLAccess().getRule();
	}

	//NLFORCED:
	//	NEWLINE WS? NL;
	public NLFORCEDElements getNLFORCEDAccess() {
		return pNLFORCED;
	}
	
	public ParserRule getNLFORCEDRule() {
		return getNLFORCEDAccess().getRule();
	}

	//terminal BOOLEAN_TRUE:
	//	'true';
	public TerminalRule getBOOLEAN_TRUERule() {
		return tBOOLEAN_TRUE;
	} 

	//terminal BOOLEAN_FALSE:
	//	'false';
	public TerminalRule getBOOLEAN_FALSERule() {
		return tBOOLEAN_FALSE;
	} 

	//terminal UPPERCASE_ID:
	//	'A'..'Z' ('A'..'Z' | 'a'..'z' | '_' | '0'..'9')*;
	public TerminalRule getUPPERCASE_IDRule() {
		return tUPPERCASE_ID;
	} 

	//terminal ID:
	//	'^'? ('a'..'z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return tID;
	} 

	//terminal INTEGER returns ecore::EBigInteger:
	//	'-'? '0'..'9'+;
	public TerminalRule getINTEGERRule() {
		return tINTEGER;
	} 

	//terminal DECIMAL returns ecore::EBigDecimal:
	//	'-'? '0'..'9'+ '.' '0'..'9'+;
	public TerminalRule getDECIMALRule() {
		return tDECIMAL;
	} 

	//terminal STRING:
	//	'"' ('\\' ('b' | 't' | 'n' | 'f' | 'r' | 'u' | '"' | "'" | '\\') | !('\\' | '"'))* '"' |
	//	"'" ('\\' ('b' | 't' | 'n' | 'f' | 'r' | 'u' | '"' | "'" | '\\') | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return tSTRING;
	} 

	//terminal REGEX:
	//	'~' ('~~' | !('~~' | '~'))* '~';
	public TerminalRule getREGEXRule() {
		return tREGEX;
	} 

	//terminal ML_COMMENT:
	//	'/*' !'*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return tML_COMMENT;
	} 

	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')*;
	public TerminalRule getSL_COMMENTRule() {
		return tSL_COMMENT;
	} 

	//terminal SL_VISIBLE_COMMENT:
	//	'-- ' !('\n' | '\r')*;
	public TerminalRule getSL_VISIBLE_COMMENTRule() {
		return tSL_VISIBLE_COMMENT;
	} 

	//terminal SL_VISIBLE_TITLE_COMMENT:
	//	'--- ' !('\n' | '\r')*;
	public TerminalRule getSL_VISIBLE_TITLE_COMMENTRule() {
		return tSL_VISIBLE_TITLE_COMMENT;
	} 

	//terminal ML_VISIBLE_COMMENT:
	//	'/- '->'-/';
	public TerminalRule getML_VISIBLE_COMMENTRule() {
		return tML_VISIBLE_COMMENT;
	} 

	//terminal ML_VISIBLE_TITLE_COMMENT:
	//	'/-- '->'--/';
	public TerminalRule getML_VISIBLE_TITLE_COMMENTRule() {
		return tML_VISIBLE_TITLE_COMMENT;
	} 

	//terminal ML_DOC_COMMENT:
	//	'/**'->'*/';
	public TerminalRule getML_DOC_COMMENTRule() {
		return tML_DOC_COMMENT;
	} 

	//terminal DIVIDER:
	//	'----' '-'*;
	public TerminalRule getDIVIDERRule() {
		return tDIVIDER;
	} 

	//terminal WS:
	//	' ' | '\t'+;
	public TerminalRule getWSRule() {
		return tWS;
	} 

	//terminal NEWLINE:
	//	'\r' | '\n'+;
	public TerminalRule getNEWLINERule() {
		return tNEWLINE;
	} 

	//terminal ISODATE:
	//	'0'..'9' '0'..'9' '0'..'9' '0'..'9' '-' '0'..'1' '0'..'9' '-' '0'..'3' '0'..'9';
	public TerminalRule getISODATERule() {
		return tISODATE;
	} 

	//terminal ISOTIME:
	//	'T' TWENTYFOURHRSTIME ISOTIMEZONE? | TWENTYFOURHRSTIME ISOTIMEZONE;
	public TerminalRule getISOTIMERule() {
		return tISOTIME;
	} 

	//terminal ISOTIMEZONE:
	//	'Z' | ('+' | '-') '0'..'2' '0'..'9' ':'? '0'..'5' '0'..'9';
	public TerminalRule getISOTIMEZONERule() {
		return tISOTIMEZONE;
	} 

	//terminal EURODATE:
	//	'0'..'3' '0'..'9' '.' '0'..'1' '0'..'9' '.' '0'..'9' '0'..'9' '0'..'9' '0'..'9';
	public TerminalRule getEURODATERule() {
		return tEURODATE;
	} 

	//terminal USDATE:
	//	'0'..'1' '0'..'9' '/' '0'..'3' '0'..'9' '/' '0'..'9' '0'..'9' '0'..'9' '0'..'9';
	public TerminalRule getUSDATERule() {
		return tUSDATE;
	} 

	//terminal TWENTYFOURHRSTIME:
	//	'0'..'2' '0'..'9' ':' '0'..'5' '0'..'9' (':' '0'..'6' '0'..'9' ('.' ('0'..'9' '0'..'9' '0'..'9'))?)?;
	public TerminalRule getTWENTYFOURHRSTIMERule() {
		return tTWENTYFOURHRSTIME;
	} 

	//terminal TWELVEHRSTIME:
	//	'0'..'1' '0'..'9' ':' '0'..'5' '0'..'9' (':' '0'..'6' '0'..'9' ('.' ('0'..'9' '0'..'9' '0'..'9'))?)? ('am' | 'pm');
	public TerminalRule getTWELVEHRSTIMERule() {
		return tTWELVEHRSTIME;
	} 

	//terminal TIMESPAN:
	//	'0'..'9'+ ('y' | 'year' | 'years' | 'mon' | 'month' | 'months' | 'd' | 'day' | 'days' | 'h' | 'hour' | 'hours' | 'm' |
	//	'minute' | 'minutes' | 's' | 'second' | 'seconds' | 'ms' | 'millisecond' | 'milliseconds');
	public TerminalRule getTIMESPANRule() {
		return tTIMESPAN;
	} 

	//terminal MULTIPLIER:
	//	'0'..'9'+ ('.' '0'..'9'+)? 'x';
	public TerminalRule getMULTIPLIERRule() {
		return tMULTIPLIER;
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return tANY_OTHER;
	} 
}
